/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.container.component;

import com.yahoo.component.ComponentId;
import com.yahoo.config.model.producer.AnyConfigProducer;
import com.yahoo.config.model.producer.TreeConfigProducer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class ConfigProducerGroup<CHILD extends AnyConfigProducer>
extends TreeConfigProducer<CHILD> {
    private final Map<ComponentId, CHILD> producerById = new LinkedHashMap<ComponentId, CHILD>();

    public ConfigProducerGroup(TreeConfigProducer<? super ConfigProducerGroup> parent, String subId) {
        super(parent, subId);
    }

    public void addComponent(ComponentId id, CHILD producer) {
        AnyConfigProducer existing = (AnyConfigProducer)this.producerById.put(id, producer);
        if (existing != null) {
            throw new IllegalArgumentException("Both " + producer + " and " + existing + " are configured with the id '" + id + "'. All components must have a unique id.");
        }
        this.addChild(producer);
    }

    public CHILD removeComponent(ComponentId componentId) {
        AnyConfigProducer component = (AnyConfigProducer)this.producerById.remove(componentId);
        if (component == null) {
            return null;
        }
        this.removeChild(component);
        return (CHILD)component;
    }

    public Collection<CHILD> getComponents() {
        return Collections.unmodifiableCollection(this.getChildren().values());
    }

    public <T extends CHILD> Collection<T> getComponents(Class<T> componentClass) {
        ArrayList<AnyConfigProducer> result = new ArrayList<AnyConfigProducer>();
        for (AnyConfigProducer child : this.getChildren().values()) {
            if (!componentClass.isInstance(child)) continue;
            result.add((AnyConfigProducer)componentClass.cast(child));
        }
        return Collections.unmodifiableCollection(result);
    }

    public Map<ComponentId, CHILD> getComponentMap() {
        return Collections.unmodifiableMap(this.producerById);
    }
}

