/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.documentmodel;

import com.yahoo.document.DataType;
import com.yahoo.document.Field;
import com.yahoo.vespa.documentmodel.DocumentSummary;
import com.yahoo.vespa.documentmodel.SummaryElementsSelector;
import com.yahoo.vespa.documentmodel.SummaryTransform;
import com.yahoo.vespa.objects.FieldBase;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;

public class SummaryField
extends FieldBase
implements Cloneable {
    private Object owner;
    private SummaryElementsSelector elementsSelector = SummaryElementsSelector.selectAll();
    private SummaryTransform transform;
    private VsmCommand vsmCommand = VsmCommand.NONE;
    private DataType dataType;
    private Set<Source> sources = new LinkedHashSet<Source>();
    private Set<String> destinations = new LinkedHashSet<String>();
    private boolean implicit = false;
    private boolean unresolvedType = false;

    public SummaryField(String name, DataType type, Object owner) {
        this(name, type, SummaryTransform.NONE, owner);
    }

    public SummaryField(Field field, Object owner) {
        this(field, SummaryTransform.NONE, owner);
    }

    public SummaryField(Field field, SummaryTransform transform, Object owner) {
        this(field.getName(), field.getDataType(), transform, owner);
    }

    public SummaryField(String name, DataType type, SummaryTransform transform, Object owner) {
        super(name);
        this.owner = owner;
        this.transform = transform;
        this.dataType = type;
    }

    public static SummaryField createWithUnresolvedType(String name, DocumentSummary owner) {
        SummaryField summaryField = new SummaryField(name, (DataType)DataType.NONE, (Object)owner);
        summaryField.unresolvedType = true;
        return summaryField;
    }

    public void setImplicit(boolean implicit) {
        this.implicit = implicit;
    }

    public boolean isImplicit() {
        return this.implicit;
    }

    public boolean hasUnresolvedType() {
        return this.unresolvedType;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public void setElementsSelector(SummaryElementsSelector selector) {
        this.elementsSelector = selector;
    }

    public SummaryElementsSelector getElementsSelector() {
        return this.elementsSelector;
    }

    public void setTransform(SummaryTransform transform) {
        this.transform = transform;
        if (SummaryTransform.DYNAMICTEASER.equals((Object)transform) || SummaryTransform.BOLDED.equals((Object)transform)) {
            this.setVsmCommand(VsmCommand.FLATTENJUNIPER);
        }
    }

    public SummaryTransform getTransform() {
        return this.transform;
    }

    public String getSourceField() {
        String sourceName = this.getName();
        if (!this.sources.isEmpty()) {
            sourceName = this.sources.iterator().next().getName();
        }
        return sourceName;
    }

    public void addSource(String name) {
        this.sources.add(new Source(name));
    }

    public void addSource(Source source) {
        this.sources.add(source);
    }

    public Iterator<Source> sourceIterator() {
        return this.sources.iterator();
    }

    public int getSourceCount() {
        return this.sources.size();
    }

    public Set<Source> getSources() {
        return this.sources;
    }

    public String getSingleSource() {
        if (this.sources.isEmpty()) {
            return this.getName();
        }
        return this.sources.iterator().next().getName();
    }

    public void addDestination(String name) {
        this.destinations.add(name);
    }

    public final void addDestinations(Iterable<String> names) {
        for (String name : names) {
            this.addDestination(name);
        }
    }

    public Set<String> getDestinations() {
        return this.destinations;
    }

    public String toString(Collection<?> collection) {
        StringBuilder buffer = new StringBuilder();
        Iterator<?> i = collection.iterator();
        while (i.hasNext()) {
            buffer.append(i.next().toString());
            if (!i.hasNext()) continue;
            buffer.append(", ");
        }
        return buffer.toString();
    }

    public SummaryField mergeWith(SummaryField merge) {
        if (merge == null) {
            return this;
        }
        if (this.isImplicit()) {
            return merge;
        }
        if (merge.isImplicit()) {
            return this;
        }
        if (!merge.getName().equals(this.getName())) {
            throw new IllegalArgumentException(String.valueOf(merge) + " conflicts with " + String.valueOf(this) + ": different names");
        }
        if (merge.getTransform() != this.getTransform()) {
            throw new IllegalArgumentException(String.valueOf(merge) + " conflicts with " + String.valueOf(this) + ": different transforms");
        }
        if (!merge.dataType.equals((Object)this.dataType)) {
            throw new IllegalArgumentException(String.valueOf(merge) + " conflicts with " + String.valueOf(this) + ": different types");
        }
        this.setImplicit(false);
        if (!this.isHeadOf(this.sourceIterator(), merge.sourceIterator())) {
            if (this.isHeadOf(merge.sourceIterator(), this.sourceIterator())) {
                this.sources = new LinkedHashSet<Source>(merge.sources);
            } else {
                throw new IllegalArgumentException(String.valueOf(merge) + " conflicts with " + String.valueOf(this) + ": on source list must be the start of the other");
            }
        }
        this.destinations.addAll(merge.destinations);
        return this;
    }

    public boolean hasSource(String name) {
        if (this.sources.isEmpty() && name.equals(this.getName())) {
            return true;
        }
        for (Source s : this.sources) {
            if (!s.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    private boolean isHeadOf(Iterator<?> full, Iterator<?> head) {
        while (head.hasNext()) {
            if (!full.hasNext()) {
                return false;
            }
            if (full.next().equals(head.next())) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "summary field '" + this.getName() + "'";
    }

    public String toLocateString() {
        return "summary '" + this.getName() + "' in " + String.valueOf(this.owner);
    }

    public SummaryField clone() {
        try {
            SummaryField clone = (SummaryField)super.clone();
            if (this.sources != null) {
                clone.sources = new LinkedHashSet<Source>(this.sources);
            }
            if (this.destinations != null) {
                clone.destinations = new LinkedHashSet<String>(this.destinations);
            }
            clone.unresolvedType = this.unresolvedType;
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Programming error");
        }
    }

    public boolean hasExplicitSingleSource() {
        String sourceName;
        String fieldName = this.getName();
        if (fieldName.equals(sourceName = this.getSingleSource())) {
            return false;
        }
        if (sourceName.contains(".")) {
            return false;
        }
        return this.sources.size() <= 1;
    }

    public void setResolvedDataType(DataType type) {
        this.dataType = type;
        this.unresolvedType = false;
    }

    public VsmCommand getVsmCommand() {
        return this.vsmCommand;
    }

    public void setVsmCommand(VsmCommand vsmCommand) {
        this.vsmCommand = vsmCommand;
    }

    public static enum VsmCommand {
        NONE("NONE"),
        FLATTENSPACE("FLATTENSPACE"),
        FLATTENJUNIPER("FLATTENJUNIPER");

        private final String cmd;

        private VsmCommand(String cmd) {
            this.cmd = cmd;
        }

        public String toString() {
            return this.cmd;
        }
    }

    public static class Source {
        private final String name;
        private boolean override = false;

        public Source(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setOverride(boolean override) {
            this.override = override;
        }

        public boolean getOverride() {
            return this.override;
        }

        public int hashCode() {
            return this.name.hashCode() + Boolean.valueOf(this.override).hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Source)) {
                return false;
            }
            Source other = (Source)obj;
            return this.name.equals(other.name) && this.override == other.override;
        }

        public String toString() {
            return "source field '" + this.name + "'";
        }
    }
}

