/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.container;

import com.yahoo.cloud.config.ZookeeperServerConfig;
import com.yahoo.config.model.MallocImplResolver;
import com.yahoo.config.model.api.container.ContainerServiceType;
import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.config.model.producer.TreeConfigProducer;
import com.yahoo.config.provision.NodeResources;
import com.yahoo.search.config.QrStartConfig;
import com.yahoo.vespa.config.search.core.OnnxModelsConfig;
import com.yahoo.vespa.model.container.Container;
import com.yahoo.vespa.model.container.component.SimpleComponent;
import java.time.Duration;
import java.util.Optional;

public final class ApplicationContainer
extends Container
implements QrStartConfig.Producer,
OnnxModelsConfig.Producer,
ZookeeperServerConfig.Producer {
    private final boolean isHostedVespa;

    public ApplicationContainer(TreeConfigProducer<?> parent, String name, int index, DeployState deployState) {
        this(parent, name, false, index, deployState);
    }

    public ApplicationContainer(TreeConfigProducer<?> parent, String name, boolean retired, int index, DeployState deployState) {
        super(parent, name, retired, index, deployState);
        this.isHostedVespa = deployState.isHosted();
        this.addComponent(new SimpleComponent("com.yahoo.container.jdisc.messagebus.NetworkMultiplexerHolder"));
        this.addComponent(new SimpleComponent("com.yahoo.container.jdisc.messagebus.NetworkMultiplexerProvider"));
        this.addComponent(new SimpleComponent("com.yahoo.container.jdisc.messagebus.SessionCache"));
        this.addComponent(new SimpleComponent("com.yahoo.container.jdisc.SystemInfoProvider"));
        this.addComponent(new SimpleComponent("com.yahoo.container.jdisc.ZoneInfoProvider"));
        this.addComponent(new SimpleComponent("com.yahoo.container.jdisc.ClusterInfoProvider"));
    }

    @Override
    public void setMallocImpl(String mallocImpl) {
        if (mallocImpl == null || mallocImpl.isEmpty()) {
            return;
        }
        super.setMallocImpl(mallocImpl);
        MallocImplResolver.pathToLibrary(mallocImpl).ifPresent(this::setPreLoad);
    }

    public void getConfig(QrStartConfig.Builder builder) {
        this.realResources().ifPresent(r -> builder.jvm.availableProcessors(Math.max(2, (int)Math.ceil(r.vcpu()))));
    }

    public void getConfig(OnnxModelsConfig.Builder builder) {
        this.realResources().ifPresent(r -> {
            int count = r.gpuResources().count();
            if (count >= 0) {
                builder.gpu.count(count);
            }
        });
    }

    @Override
    protected ContainerServiceType myServiceType() {
        return ContainerServiceType.CONTAINER;
    }

    @Override
    public String getJvmOptions() {
        String jvmArgs;
        StringBuilder b = new StringBuilder();
        if (this.isHostedVespa) {
            b.append("-Djdk.tls.server.enableStatusRequestExtension=true ").append("-Djdk.tls.stapling.responseTimeout=2000 ").append("-Djdk.tls.stapling.cacheSize=256 ").append("-Djdk.tls.stapling.cacheLifetime=3600 ");
        }
        if (!(jvmArgs = super.getJvmOptions()).isBlank()) {
            b.append(jvmArgs.trim());
        }
        return b.toString().trim();
    }

    public void getConfig(ZookeeperServerConfig.Builder builder) {
        builder.myid(this.index());
    }

    @Override
    public Optional<String> getPreShutdownCommand() {
        return Optional.of(this.prepareStopCommand(Duration.ofMinutes(6L)));
    }

    private Optional<NodeResources> realResources() {
        NodeResources nodeResources;
        if (this.getHostResource() != null && !(nodeResources = this.getHostResource().realResources()).isUnspecified()) {
            return Optional.of(nodeResources);
        }
        return Optional.empty();
    }
}

