/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.content.cluster;

import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.vespa.model.builder.xml.dom.ModelElement;
import com.yahoo.vespa.model.content.DispatchTuning;
import java.util.logging.Level;

public class DomTuningDispatchBuilder {
    public static DispatchTuning build(ModelElement contentXml, DeployLogger logger) {
        DispatchTuning.Builder builder = new DispatchTuning.Builder();
        ModelElement tuningElement = contentXml.child("tuning");
        if (tuningElement == null) {
            return builder.build();
        }
        ModelElement dispatchElement = tuningElement.child("dispatch");
        if (dispatchElement == null) {
            return builder.build();
        }
        builder.setMaxHitsPerPartition(dispatchElement.childAsInteger("max-hits-per-partition"));
        String policy = dispatchElement.childAsString("dispatch-policy");
        if (policy != null && policy.equalsIgnoreCase("random")) {
            logger.logApplicationPackage(Level.WARNING, "'dispatch-policy' is set to 'random', this is deprecated and 'adaptive' will be used instead");
        }
        builder.setDispatchPolicy(dispatchElement.childAsString("dispatch-policy"));
        builder.setPrioritizeAvailability(dispatchElement.childAsBoolean("prioritize-availability"));
        builder.setMinActiveDocsCoverage(dispatchElement.childAsDouble("min-active-docs-coverage"));
        builder.setTopKProbability(dispatchElement.childAsDouble("top-k-probability"));
        return builder.build();
    }
}

