/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.schema.derived;

import com.yahoo.config.ConfigInstance;
import com.yahoo.schema.Schema;
import com.yahoo.schema.derived.Derived;
import com.yahoo.vespa.config.search.summary.JuniperrcConfig;
import com.yahoo.vespa.documentmodel.SummaryField;
import com.yahoo.vespa.documentmodel.SummaryTransform;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class Juniperrc
extends Derived {
    private static final int Mb = 0x100000;
    private final Set<String> boldingFields = new LinkedHashSet<String>();

    public Juniperrc(Schema schema) {
        this.derive(schema);
    }

    @Override
    protected void derive(Schema schema) {
        super.derive(schema);
        for (SummaryField summaryField : schema.getUniqueNamedSummaryFields().values()) {
            if (summaryField.getTransform() != SummaryTransform.BOLDED) continue;
            this.boldingFields.add(summaryField.getName());
        }
    }

    public void export(String toDirectory) throws IOException {
        JuniperrcConfig.Builder builder = new JuniperrcConfig.Builder();
        this.getConfig(builder);
        this.export(toDirectory, (ConfigInstance)builder.build());
    }

    @Override
    protected String getDerivedName() {
        return "juniperrc";
    }

    private static JuniperrcConfig.Override.Builder createOverride(String name) {
        return new JuniperrcConfig.Override.Builder().fieldname(name).length(0x4000000).max_matches(1).min_length(8192).surround_max(0x4000000);
    }

    public void getConfig(JuniperrcConfig.Builder builder) {
        if (!this.boldingFields.isEmpty()) {
            builder.prefix(true);
            builder.override((List)this.boldingFields.stream().map(Juniperrc::createOverride).collect(Collectors.toCollection(() -> new ArrayList())));
        }
    }
}

