/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.application.validation.change;

import com.yahoo.config.model.api.ConfigChangeAction;
import com.yahoo.config.provision.ClusterMembership;
import com.yahoo.config.provision.ClusterSpec;
import com.yahoo.config.provision.HostSpec;
import com.yahoo.config.provision.NodeResources;
import com.yahoo.vespa.model.VespaModel;
import com.yahoo.vespa.model.application.validation.Validation;
import com.yahoo.vespa.model.application.validation.change.ChangeValidator;
import com.yahoo.vespa.model.application.validation.change.VespaRestartAction;
import com.yahoo.vespa.model.container.ApplicationContainerCluster;
import com.yahoo.vespa.model.content.cluster.ContentCluster;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class NodeResourceChangeValidator
implements ChangeValidator {
    @Override
    public void validate(Validation.ChangeContext context) {
        for (ClusterSpec cluster : context.previousModel().allClusters()) {
            Optional<NodeResources> currentResources = this.resourcesOf(cluster, context.previousModel());
            Optional<NodeResources> nextResources = this.resourcesOf(cluster, context.model());
            if (currentResources.isEmpty() || nextResources.isEmpty() || !this.changeRequiresRestart(currentResources.get(), nextResources.get())) continue;
            this.createRestartActionsFor(cluster, context.previousModel()).forEach(context::require);
        }
    }

    private boolean changeRequiresRestart(NodeResources currentResources, NodeResources nextResources) {
        return currentResources.memoryGiB() != nextResources.memoryGiB();
    }

    private Optional<NodeResources> resourcesOf(ClusterSpec cluster, VespaModel model) {
        return model.allocatedHosts().getHosts().stream().filter(host -> host.membership().isPresent()).filter(host -> ((ClusterMembership)host.membership().get()).cluster().id().equals((Object)cluster.id())).findFirst().map(HostSpec::advertisedResources);
    }

    private List<ConfigChangeAction> createRestartActionsFor(ClusterSpec cluster, VespaModel model) {
        ApplicationContainerCluster containerCluster = model.getContainerClusters().get(cluster.id().value());
        if (containerCluster != null) {
            return this.createRestartActionsFor(containerCluster);
        }
        ContentCluster contentCluster = model.getContentClusters().get(cluster.id().value());
        if (contentCluster != null) {
            return this.createRestartActionsFor(contentCluster);
        }
        return List.of();
    }

    private List<ConfigChangeAction> createRestartActionsFor(ApplicationContainerCluster cluster) {
        return cluster.getContainers().stream().map(container -> new VespaRestartAction(cluster.id(), "Node resource change", container.getServiceInfo(), false)).collect(Collectors.toList());
    }

    private List<ConfigChangeAction> createRestartActionsFor(ContentCluster cluster) {
        return cluster.getSearch().getSearchNodes().stream().map(node -> new VespaRestartAction(cluster.id(), "Node resource change", node.getServiceInfo(), false)).collect(Collectors.toList());
    }
}

