/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.schema.derived;

import com.yahoo.config.ConfigInstance;
import com.yahoo.document.ArrayDataType;
import com.yahoo.document.DataType;
import com.yahoo.document.MapDataType;
import com.yahoo.document.PrimitiveDataType;
import com.yahoo.document.ReferenceDataType;
import com.yahoo.document.StructuredDataType;
import com.yahoo.document.TensorDataType;
import com.yahoo.document.WeightedSetDataType;
import com.yahoo.document.annotation.AnnotationReferenceDataType;
import com.yahoo.documentmodel.NewDocumentReferenceDataType;
import com.yahoo.schema.Index;
import com.yahoo.schema.RankProfile;
import com.yahoo.schema.RankProfileRegistry;
import com.yahoo.schema.Schema;
import com.yahoo.schema.derived.Derived;
import com.yahoo.schema.derived.Summaries;
import com.yahoo.schema.derived.SummaryClass;
import com.yahoo.schema.derived.SummaryClassField;
import com.yahoo.schema.document.Attribute;
import com.yahoo.schema.document.FieldSet;
import com.yahoo.schema.document.ImmutableSDField;
import com.yahoo.search.config.SchemaInfoConfig;
import com.yahoo.searchlib.rankingexpression.Reference;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public final class SchemaInfo
extends Derived {
    private final Schema schema;
    private final Map<String, RankProfileInfo> rankProfiles;
    private final Summaries summaries;
    private final IndexMode indexMode;

    public SchemaInfo(Schema schema, String indexMode, RankProfileRegistry rankProfileRegistry, Summaries summaries) {
        this(schema, SchemaInfo.indexMode(indexMode), rankProfileRegistry, summaries);
    }

    public SchemaInfo(Schema schema, IndexMode indexMode, RankProfileRegistry rankProfileRegistry, Summaries summaries) {
        this.schema = schema;
        this.rankProfiles = Collections.unmodifiableMap(this.toRankProfiles(rankProfileRegistry.rankProfilesOf(schema)));
        this.summaries = summaries;
        this.indexMode = indexMode;
    }

    private static IndexMode indexMode(String mode) {
        if (mode == null) {
            return IndexMode.INDEX;
        }
        return switch (mode) {
            case "index" -> IndexMode.INDEX;
            case "streaming" -> IndexMode.STREAMING;
            case "store-only" -> IndexMode.STORE_ONLY;
            default -> IndexMode.STORE_ONLY;
        };
    }

    public IndexMode getIndexMode() {
        return this.indexMode;
    }

    public String name() {
        return this.schema.getName();
    }

    @Override
    public String getDerivedName() {
        return "schema-info";
    }

    public Schema fullSchema() {
        return this.schema;
    }

    public Map<String, RankProfileInfo> rankProfiles() {
        return this.rankProfiles;
    }

    private Map<String, RankProfileInfo> toRankProfiles(Collection<RankProfile> rankProfiles) {
        LinkedHashMap<String, RankProfileInfo> rankProfileInfos = new LinkedHashMap<String, RankProfileInfo>();
        rankProfiles.forEach(profile -> rankProfileInfos.put(profile.name(), new RankProfileInfo((RankProfile)profile)));
        return rankProfileInfos;
    }

    public void getConfig(SchemaInfoConfig.Builder builder) {
        SchemaInfoConfig.Schema.Builder schemaBuilder = new SchemaInfoConfig.Schema.Builder();
        schemaBuilder.name(this.schema.getName());
        this.addFieldsConfig(schemaBuilder);
        this.addFieldSetConfig(schemaBuilder);
        this.addSummaryConfig(schemaBuilder);
        this.addRankProfilesConfig(schemaBuilder);
        builder.schema(schemaBuilder);
    }

    public void export(String toDirectory) throws IOException {
        SchemaInfoConfig.Builder builder = new SchemaInfoConfig.Builder();
        this.getConfig(builder);
        this.export(toDirectory, (ConfigInstance)builder.build());
    }

    private void addFieldsConfig(SchemaInfoConfig.Schema.Builder schemaBuilder) {
        for (ImmutableSDField field : this.schema.allFieldsList()) {
            this.addFieldConfig(field, schemaBuilder);
            for (Index index : field.getIndices().values()) {
                if (index.getName().equals(field.getName())) continue;
                this.addFieldConfig(index, field.getDataType(), schemaBuilder);
            }
            for (Attribute attribute : field.getAttributes().values()) {
                if (attribute.getName().equals(field.getName())) continue;
                this.addFieldConfig(attribute, field.getDataType(), schemaBuilder);
            }
        }
    }

    private void addFieldConfig(ImmutableSDField field, SchemaInfoConfig.Schema.Builder schemaBuilder) {
        SchemaInfoConfig.Schema.Field.Builder fieldBuilder = new SchemaInfoConfig.Schema.Field.Builder();
        fieldBuilder.name(field.getName());
        fieldBuilder.type(this.toTypeSpec(field.getDataType()));
        for (Map.Entry<String, String> alias : field.getAliasToName().entrySet()) {
            if (!alias.getValue().equals(field.getName())) continue;
            fieldBuilder.alias(alias.getKey());
        }
        fieldBuilder.attribute(field.doesAttributing());
        fieldBuilder.index(field.doesIndexing());
        fieldBuilder.bitPacked(field.doesBitPacking());
        schemaBuilder.field(fieldBuilder);
    }

    private void addFieldConfig(Index index, DataType type, SchemaInfoConfig.Schema.Builder schemaBuilder) {
        SchemaInfoConfig.Schema.Field.Builder fieldBuilder = new SchemaInfoConfig.Schema.Field.Builder();
        fieldBuilder.name(index.getName());
        fieldBuilder.type(this.toTypeSpec(type));
        Iterator<String> i = index.aliasIterator();
        while (i.hasNext()) {
            fieldBuilder.alias(i.next());
        }
        fieldBuilder.attribute(false);
        fieldBuilder.index(true);
        fieldBuilder.bitPacked(false);
        schemaBuilder.field(fieldBuilder);
    }

    private void addFieldConfig(Attribute attribute, DataType type, SchemaInfoConfig.Schema.Builder schemaBuilder) {
        SchemaInfoConfig.Schema.Field.Builder fieldBuilder = new SchemaInfoConfig.Schema.Field.Builder();
        fieldBuilder.name(attribute.getName());
        fieldBuilder.type(this.toTypeSpec(type));
        for (String alias : attribute.getAliases()) {
            fieldBuilder.alias(alias);
        }
        fieldBuilder.attribute(true);
        fieldBuilder.index(false);
        fieldBuilder.bitPacked(false);
        schemaBuilder.field(fieldBuilder);
    }

    private void addFieldSetConfig(SchemaInfoConfig.Schema.Builder schemaBuilder) {
        for (FieldSet fieldSet : this.schema.fieldSets().builtInFieldSets().values()) {
            this.addFieldSetConfig(fieldSet, schemaBuilder);
        }
        for (FieldSet fieldSet : this.schema.fieldSets().userFieldSets().values()) {
            this.addFieldSetConfig(fieldSet, schemaBuilder);
        }
    }

    private void addFieldSetConfig(FieldSet fieldSet, SchemaInfoConfig.Schema.Builder schemaBuilder) {
        SchemaInfoConfig.Schema.Fieldset.Builder fieldSetBuilder = new SchemaInfoConfig.Schema.Fieldset.Builder();
        fieldSetBuilder.name(fieldSet.getName());
        for (String fieldName : fieldSet.getFieldNames()) {
            fieldSetBuilder.field(fieldName);
        }
        schemaBuilder.fieldset(fieldSetBuilder);
    }

    private void addSummaryConfig(SchemaInfoConfig.Schema.Builder schemaBuilder) {
        for (SummaryClass summary : this.summaries.asList()) {
            SchemaInfoConfig.Schema.Summaryclass.Builder summaryBuilder = new SchemaInfoConfig.Schema.Summaryclass.Builder();
            summaryBuilder.name(summary.getName());
            for (SummaryClassField field : summary.fields().values()) {
                SchemaInfoConfig.Schema.Summaryclass.Fields.Builder fieldsBuilder = new SchemaInfoConfig.Schema.Summaryclass.Fields.Builder();
                fieldsBuilder.name(field.getName()).type(field.getType().getName()).dynamic(SummaryClass.commandRequiringQuery(field.getCommand()) || SummaryClass.elementsSelectorRequiringQuery(field.getElementsSelector()));
                summaryBuilder.fields(fieldsBuilder);
            }
            schemaBuilder.summaryclass(summaryBuilder);
        }
    }

    private void addRankProfilesConfig(SchemaInfoConfig.Schema.Builder schemaBuilder) {
        for (RankProfileInfo rankProfile : this.rankProfiles().values()) {
            SchemaInfoConfig.Schema.Rankprofile.Builder rankProfileConfig = new SchemaInfoConfig.Schema.Rankprofile.Builder().name(rankProfile.name()).hasSummaryFeatures(rankProfile.hasSummaryFeatures()).hasRankFeatures(rankProfile.hasRankFeatures()).significance(new SchemaInfoConfig.Schema.Rankprofile.Significance.Builder().useModel(rankProfile.useSignificanceModel()));
            for (Map.Entry<Reference, RankProfile.Input> input : rankProfile.inputs().entrySet()) {
                SchemaInfoConfig.Schema.Rankprofile.Input.Builder inputConfig = new SchemaInfoConfig.Schema.Rankprofile.Input.Builder();
                inputConfig.name(input.getKey().toString());
                inputConfig.type(input.getValue().type().toString());
                rankProfileConfig.input(inputConfig);
            }
            schemaBuilder.rankprofile(rankProfileConfig);
        }
    }

    private String toTypeSpec(DataType dataType) {
        if (dataType instanceof PrimitiveDataType) {
            return dataType.getName();
        }
        if (dataType instanceof AnnotationReferenceDataType) {
            AnnotationReferenceDataType annotationType = (AnnotationReferenceDataType)dataType;
            return "annotationreference<" + annotationType.getAnnotationType().getName() + ">";
        }
        if (dataType instanceof ArrayDataType) {
            ArrayDataType arrayType = (ArrayDataType)dataType;
            return "array<" + this.toTypeSpec(arrayType.getNestedType()) + ">";
        }
        if (dataType instanceof MapDataType) {
            MapDataType mapType = (MapDataType)dataType;
            return "map<" + this.toTypeSpec(mapType.getKeyType()) + "," + this.toTypeSpec(mapType.getValueType()) + ">";
        }
        if (dataType instanceof ReferenceDataType) {
            ReferenceDataType referenceType = (ReferenceDataType)dataType;
            return "reference<" + this.toTypeSpec((DataType)referenceType.getTargetType()) + ">";
        }
        if (dataType instanceof NewDocumentReferenceDataType) {
            NewDocumentReferenceDataType referenceType = (NewDocumentReferenceDataType)dataType;
            return "reference<" + this.toTypeSpec((DataType)referenceType.getTargetType()) + ">";
        }
        if (dataType instanceof StructuredDataType) {
            StructuredDataType structType = (StructuredDataType)dataType;
            return structType.getName();
        }
        if (dataType instanceof TensorDataType) {
            TensorDataType tensorType = (TensorDataType)dataType;
            return tensorType.getTensorType().toString();
        }
        if (dataType instanceof WeightedSetDataType) {
            WeightedSetDataType weightedSetDataType = (WeightedSetDataType)dataType;
            return "weightedset<" + this.toTypeSpec(weightedSetDataType.getNestedType()) + ">";
        }
        throw new IllegalArgumentException("Unknown data type " + String.valueOf(dataType) + " class " + String.valueOf(dataType.getClass()));
    }

    public static enum IndexMode {
        INDEX,
        STREAMING,
        STORE_ONLY;

    }

    public static final class RankProfileInfo {
        private final String name;
        private final boolean hasSummaryFeatures;
        private final boolean hasRankFeatures;
        private final boolean useSignificanceModel;
        private final Map<Reference, RankProfile.Input> inputs;

        public RankProfileInfo(RankProfile profile) {
            this.name = profile.name();
            this.hasSummaryFeatures = !profile.getSummaryFeatures().isEmpty();
            this.hasRankFeatures = !profile.getRankFeatures().isEmpty();
            this.inputs = profile.inputs();
            this.useSignificanceModel = profile.useSignificanceModel();
        }

        public String name() {
            return this.name;
        }

        public boolean hasSummaryFeatures() {
            return this.hasSummaryFeatures;
        }

        public boolean hasRankFeatures() {
            return this.hasRankFeatures;
        }

        public boolean useSignificanceModel() {
            return this.useSignificanceModel;
        }

        public Map<Reference, RankProfile.Input> inputs() {
            return this.inputs;
        }
    }
}

