/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.schema.expressiontransforms;

import com.yahoo.schema.OnnxModel;
import com.yahoo.schema.expressiontransforms.RankProfileTransformContext;
import com.yahoo.searchlib.ranking.features.FeatureNames;
import com.yahoo.searchlib.rankingexpression.RankingExpression;
import com.yahoo.searchlib.rankingexpression.Reference;
import com.yahoo.searchlib.rankingexpression.evaluation.TensorValue;
import com.yahoo.searchlib.rankingexpression.evaluation.Value;
import com.yahoo.searchlib.rankingexpression.parser.ParseException;
import com.yahoo.searchlib.rankingexpression.rule.Arguments;
import com.yahoo.searchlib.rankingexpression.rule.CompositeNode;
import com.yahoo.searchlib.rankingexpression.rule.ExpressionNode;
import com.yahoo.searchlib.rankingexpression.rule.ReferenceNode;
import com.yahoo.searchlib.rankingexpression.rule.TensorFunctionNode;
import com.yahoo.searchlib.rankingexpression.transform.ExpressionTransformer;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ConstantTensorTransformer
extends ExpressionTransformer<RankProfileTransformContext> {
    public ExpressionNode transform(ExpressionNode node, RankProfileTransformContext context) {
        if (node instanceof TensorFunctionNode) {
            TensorFunctionNode tfn = (TensorFunctionNode)node;
            node = tfn.withTransformedExpressions(expr -> this.transform((ExpressionNode)expr, context));
        }
        if (node instanceof ReferenceNode) {
            return this.transformFeature((ReferenceNode)node, context);
        }
        if (node instanceof CompositeNode) {
            return this.transformChildren((CompositeNode)node, context);
        }
        return node;
    }

    private ExpressionNode transformFeature(ReferenceNode node, RankProfileTransformContext context) {
        Reference ref = node.reference();
        String name = ref.name();
        Arguments args = ref.arguments();
        if (name.equals("onnx") && args.size() == 1) {
            ExpressionNode arg = (ExpressionNode)args.expressions().get(0);
            Map<String, OnnxModel> models = context.rankProfile().onnxModels();
            OnnxModel model = models.get(arg.toString());
            if (model != null) {
                for (Map.Entry<String, String> entry : model.getInputMap().entrySet()) {
                    String source = entry.getValue();
                    StringReader reader = new StringReader(source);
                    try {
                        RankingExpression asExpression = new RankingExpression((Reader)reader);
                        String transformed = this.transform(asExpression.getRoot(), context).toString();
                        if (source.equals(transformed)) continue;
                        throw new IllegalStateException("unexpected rewrite: " + source + " => " + transformed + " for onnx input " + entry.getKey());
                    }
                    catch (ParseException e) {
                        throw new IllegalArgumentException("illegal onnx input '" + source + "': " + e.getMessage());
                    }
                }
                return node;
            }
        }
        if (!node.getArguments().isEmpty() && !FeatureNames.isSimpleFeature((Reference)node.reference())) {
            return this.transformArguments(node, context);
        }
        return this.transformConstantReference(node, context);
    }

    private ExpressionNode transformArguments(ReferenceNode node, RankProfileTransformContext context) {
        List arguments = node.getArguments().expressions();
        ArrayList<ExpressionNode> transformedArguments = new ArrayList<ExpressionNode>(arguments.size());
        for (ExpressionNode argument : arguments) {
            transformedArguments.add(this.transform(argument, context));
        }
        return node.setArguments(transformedArguments);
    }

    private ExpressionNode transformConstantReference(ReferenceNode node, RankProfileTransformContext context) {
        String constantName = node.getName();
        Reference constantReference = node.reference();
        if (FeatureNames.isConstantFeature((Reference)constantReference)) {
            constantName = constantReference.simpleArgument().orElse(null);
        } else if (constantReference.isIdentifier()) {
            constantReference = FeatureNames.asConstantFeature((String)constantName);
        } else {
            return node;
        }
        Value value = (Value)context.constants().get(constantName);
        if (value == null || value.type().rank() == 0) {
            return node;
        }
        TensorValue tensorValue = (TensorValue)value;
        String tensorType = tensorValue.asTensor().type().toString();
        context.rankProperties().put(String.valueOf(constantReference) + ".value", tensorValue.toString());
        context.rankProperties().put(String.valueOf(constantReference) + ".type", tensorType);
        return new ReferenceNode(constantReference);
    }
}

