/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.schema.expressiontransforms;

import ai.vespa.rankingexpression.importer.configmodelview.ImportedMlModels;
import com.yahoo.schema.RankProfile;
import com.yahoo.search.query.profile.QueryProfileRegistry;
import com.yahoo.searchlib.rankingexpression.Reference;
import com.yahoo.searchlib.rankingexpression.evaluation.DoubleValue;
import com.yahoo.searchlib.rankingexpression.evaluation.TensorValue;
import com.yahoo.searchlib.rankingexpression.evaluation.Value;
import com.yahoo.searchlib.rankingexpression.transform.TransformContext;
import com.yahoo.tensor.Tensor;
import com.yahoo.tensor.TensorType;
import com.yahoo.tensor.evaluation.TypeContext;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;

public class RankProfileTransformContext
extends TransformContext {
    private final RankProfile rankProfile;
    private final QueryProfileRegistry queryProfiles;
    private final ImportedMlModels importedModels;
    private final Map<String, RankProfile.RankingExpressionFunction> inlineFunctions;
    private final Map<String, String> rankProperties = new LinkedHashMap<String, String>();

    public RankProfileTransformContext(RankProfile rankProfile, QueryProfileRegistry queryProfiles, Map<Reference, TensorType> featureTypes, ImportedMlModels importedModels, Map<Reference, RankProfile.Constant> constants, Map<String, RankProfile.RankingExpressionFunction> inlineFunctions) {
        super(RankProfileTransformContext.valuesOf(constants), (TypeContext)rankProfile.typeContext(queryProfiles, featureTypes));
        this.rankProfile = rankProfile;
        this.queryProfiles = queryProfiles;
        this.importedModels = importedModels;
        this.inlineFunctions = inlineFunctions;
    }

    public RankProfile rankProfile() {
        return this.rankProfile;
    }

    public QueryProfileRegistry queryProfiles() {
        return this.queryProfiles;
    }

    public ImportedMlModels importedModels() {
        return this.importedModels;
    }

    public Map<String, RankProfile.RankingExpressionFunction> inlineFunctions() {
        return this.inlineFunctions;
    }

    public Map<String, String> rankProperties() {
        return this.rankProperties;
    }

    private static Map<String, Value> valuesOf(Map<Reference, RankProfile.Constant> constants) {
        return constants.values().stream().filter(constant -> constant.value().isPresent()).collect(Collectors.toMap(constant -> (String)constant.name().simpleArgument().get(), constant -> RankProfileTransformContext.asValue(constant.value().get())));
    }

    private static Value asValue(Tensor tensor) {
        if (tensor.type().rank() == 0) {
            return DoubleValue.of((double)tensor.asDouble());
        }
        return TensorValue.of((Tensor)tensor);
    }
}

