/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.schema.processing;

import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.document.Field;
import com.yahoo.schema.RankProfileRegistry;
import com.yahoo.schema.Schema;
import com.yahoo.schema.document.Attribute;
import com.yahoo.schema.document.SDField;
import com.yahoo.schema.processing.Processor;
import com.yahoo.tensor.TensorType;
import com.yahoo.vespa.model.container.search.QueryProfiles;
import java.util.Optional;

public class PagedAttributeValidator
extends Processor {
    private static final String disavantagesUrl = "https://docs.vespa.ai/en/attributes.html#paged-attributes-disadvantages";

    public PagedAttributeValidator(Schema schema, DeployLogger deployLogger, RankProfileRegistry rankProfileRegistry, QueryProfiles queryProfiles) {
        super(schema, deployLogger, rankProfileRegistry, queryProfiles);
    }

    @Override
    public void process(boolean validate, boolean documentsOnly) {
        if (!validate) {
            return;
        }
        for (SDField field : this.schema.allConcreteFields()) {
            for (Attribute attribute : field.getAttributes().values()) {
                if (!attribute.isPaged()) continue;
                this.validatePagedSetting(field, attribute);
            }
        }
    }

    private void validatePagedSetting(Field field, Attribute attribute) {
        if (!this.isSupportedType(attribute)) {
            this.fail(this.schema, field, "The 'paged' attribute setting is not supported for fast-rank tensor and predicate types");
        }
        if (attribute.getType() == Attribute.Type.TENSOR && attribute.hnswIndexParams().isPresent()) {
            this.warn(this.schema.getName(), field.getName(), "The 'paged' attribute setting in combination with HNSW indexing is strongly discouraged, see https://docs.vespa.ai/en/attributes.html#paged-attributes-disadvantages for details");
        }
    }

    private boolean isSupportedType(Attribute attribute) {
        Attribute.Type type = attribute.getType();
        return type != Attribute.Type.PREDICATE && this.isSupportedTensorType(attribute.tensorType(), attribute.isFastRank());
    }

    private boolean isSupportedTensorType(Optional<TensorType> tensorType, boolean fastRank) {
        if (tensorType.isPresent()) {
            return !fastRank;
        }
        return true;
    }
}

