/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.configmodel.producers;

import com.yahoo.document.ArrayDataType;
import com.yahoo.document.DataType;
import com.yahoo.document.DocumentType;
import com.yahoo.document.MapDataType;
import com.yahoo.document.NumericDataType;
import com.yahoo.document.PositionDataType;
import com.yahoo.document.PrimitiveDataType;
import com.yahoo.document.StructDataType;
import com.yahoo.document.TensorDataType;
import com.yahoo.document.WeightedSetDataType;
import com.yahoo.document.annotation.AnnotationReferenceDataType;
import com.yahoo.document.annotation.AnnotationType;
import com.yahoo.documentmodel.NewDocumentReferenceDataType;
import com.yahoo.documentmodel.NewDocumentType;
import com.yahoo.documentmodel.OwnedStructDataType;
import com.yahoo.documentmodel.VespaDocumentType;
import com.yahoo.schema.document.annotation.SDAnnotationType;
import java.util.IdentityHashMap;
import java.util.Map;

public class DataTypeRecognizer {
    private Map<Object, String> toUniqueNames = new IdentityHashMap<Object, String>();

    DataTypeRecognizer() {
    }

    String nameOf(Object type) {
        return this.toUniqueNames.computeIfAbsent(type, t -> this.makeUniqueName(t));
    }

    private String makeUniqueName(Object type) {
        if (type == PositionDataType.INSTANCE) {
            return "{builtin position}";
        }
        if (type == DataType.DOCUMENT) {
            return "{builtin root document}";
        }
        if (type == VespaDocumentType.INSTANCE) {
            return "{builtin vespa document}";
        }
        Class<?> typeClass = type.getClass();
        if (typeClass == AnnotationReferenceDataType.class) {
            AnnotationReferenceDataType t = (AnnotationReferenceDataType)type;
            AnnotationType ann = t.getAnnotationType();
            return "annotationreference<" + ann.getName() + ">";
        }
        if (typeClass == AnnotationType.class) {
            AnnotationType t = (AnnotationType)type;
            return "annotation<" + t.getName() + ">";
        }
        if (typeClass == SDAnnotationType.class) {
            SDAnnotationType t = (SDAnnotationType)((Object)type);
            return "annotation<" + t.getName() + ">";
        }
        if (typeClass == ArrayDataType.class) {
            ArrayDataType t = (ArrayDataType)type;
            DataType nt = t.getNestedType();
            return "array<" + this.nameOf(nt) + ">";
        }
        if (typeClass == DocumentType.class) {
            DocumentType t = (DocumentType)type;
            return "{document " + t.getName() + "}";
        }
        if (typeClass == MapDataType.class) {
            MapDataType t = (MapDataType)type;
            DataType kt = t.getKeyType();
            DataType vt = t.getValueType();
            return "map<" + this.nameOf(kt) + ", " + this.nameOf(vt) + ">";
        }
        if (typeClass == NewDocumentReferenceDataType.class) {
            NewDocumentReferenceDataType t = (NewDocumentReferenceDataType)((Object)type);
            return "reference<" + t.getTargetTypeName() + ">";
        }
        if (typeClass == NewDocumentType.class) {
            NewDocumentType t = (NewDocumentType)type;
            return "{new-document " + t.getName() + "}";
        }
        if (typeClass == OwnedStructDataType.class) {
            OwnedStructDataType t = (OwnedStructDataType)type;
            return "{owned-struct " + t.getName() + " @ " + t.getOwnerName() + "}";
        }
        if (typeClass == NumericDataType.class) {
            NumericDataType t = (NumericDataType)type;
            return "{numeric " + t.getName() + "}";
        }
        if (typeClass == PrimitiveDataType.class) {
            PrimitiveDataType t = (PrimitiveDataType)type;
            return "{primitive " + t.getName() + "}";
        }
        if (typeClass == StructDataType.class) {
            StructDataType t = (StructDataType)type;
            return "{struct " + t.getName() + "}";
        }
        if (typeClass == TensorDataType.class) {
            TensorDataType t = (TensorDataType)type;
            return "{tensor" + String.valueOf(t.getTensorType()) + "}";
        }
        if (typeClass == WeightedSetDataType.class) {
            WeightedSetDataType t = (WeightedSetDataType)type;
            DataType nt = t.getNestedType();
            String prefix = "weightedset<";
            String cine = t.createIfNonExistent() ? " [createIfNonExistent]" : "";
            String riz = t.removeIfZero() ? " [removeIfZero]" : "";
            String suffix = ">";
            return prefix + this.nameOf(nt) + cine + riz + suffix;
        }
        throw new IllegalArgumentException("unknown type class: " + String.valueOf(typeClass));
    }
}

