/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.admin.otel;

import com.yahoo.cloud.config.OpenTelemetryConfig;
import com.yahoo.config.model.ApplicationConfigProducerRoot;
import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.config.model.producer.AnyConfigProducer;
import com.yahoo.config.model.producer.TreeConfigProducer;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.provision.Zone;
import com.yahoo.vespa.model.AbstractService;
import com.yahoo.vespa.model.PortAllocBridge;
import com.yahoo.vespa.model.admin.otel.OpenTelemetryConfigGenerator;
import java.util.Optional;

public class OpenTelemetryCollector
extends AbstractService
implements OpenTelemetryConfig.Producer {
    private final Zone zone;
    private final ApplicationId applicationId;
    private final boolean isHostedVespa;

    public OpenTelemetryCollector(TreeConfigProducer<?> parent) {
        super(parent, "otelcol");
        this.zone = null;
        this.applicationId = null;
        this.isHostedVespa = false;
        this.setProp("clustertype", "admin");
        this.setProp("clustername", "admin");
    }

    public OpenTelemetryCollector(TreeConfigProducer<?> parent, DeployState deployState) {
        super(parent, "otelcol");
        this.zone = deployState.zone();
        this.applicationId = deployState.getProperties().applicationId();
        this.isHostedVespa = deployState.isHosted();
        this.setProp("clustertype", "admin");
        this.setProp("clustername", "admin");
    }

    @Override
    public Optional<String> getStartupCommand() {
        return Optional.of("exec $ROOT/bin/vespa-otelcol-start -c " + this.getConfigId());
    }

    @Override
    public void allocatePorts(int start, PortAllocBridge from) {
    }

    @Override
    public int getPortCount() {
        return 0;
    }

    public void getConfig(OpenTelemetryConfig.Builder builder) {
        OpenTelemetryConfigGenerator generator = new OpenTelemetryConfigGenerator(this.zone, this.applicationId, this.isHostedVespa);
        AnyConfigProducer pp = this;
        AnyConfigProducer p = pp.getParent();
        while (p != null && p != pp) {
            if (pp instanceof ApplicationConfigProducerRoot) {
                ApplicationConfigProducerRoot root = (ApplicationConfigProducerRoot)pp;
                generator.addStatePorts(root.getStatePorts());
                break;
            }
            pp = p;
            p = pp.getParent();
        }
        builder.yaml(generator.generate());
        builder.refPaths(generator.referencedPaths());
    }
}

