/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.application.validation;

import com.yahoo.vespa.model.application.validation.Validation;
import com.yahoo.vespa.model.application.validation.Validator;
import com.yahoo.vespa.model.container.ApplicationContainerCluster;
import com.yahoo.vespa.model.container.http.HttpFilterChain;
import java.util.Comparator;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.stream.Collectors;

public class CloudUserFilterValidator
implements Validator {
    @Override
    public void validate(Validation.Context context) {
        if (!context.deployState().isHostedTenantApplication(context.model().getAdmin().getApplicationType())) {
            return;
        }
        if (context.deployState().getProperties().allowUserFilters()) {
            return;
        }
        record Violation(String cluster, String chain) {
        }
        TreeSet<Violation> violations = new TreeSet<Violation>(Comparator.comparing(Violation::chain).thenComparing(Violation::cluster));
        for (ApplicationContainerCluster cluster : context.model().getContainerClusters().values()) {
            if (cluster.getHttp() == null) continue;
            for (HttpFilterChain chain : cluster.getHttp().getFilterChains().allChains().allComponents()) {
                if (chain.type() != HttpFilterChain.Type.USER) continue;
                String msg = "Found filter chain violation - chain '%s' in cluster '%s'".formatted(cluster.name(), chain.id());
                context.deployState().getDeployLogger().log(Level.WARNING, msg);
                violations.add(new Violation(cluster.name(), chain.id()));
            }
        }
        if (violations.isEmpty()) {
            return;
        }
        String violationsStr = violations.stream().map(v -> "chain '%s' in cluster '%s'".formatted(v.chain(), v.cluster())).collect(Collectors.joining(", ", "[", "]"));
        String msg = "HTTP filter chains are currently not supported in Vespa Cloud (%s)".formatted(violationsStr);
        context.illegal(msg);
    }
}

