/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.application.validation;

import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.config.provision.ClusterSpec;
import com.yahoo.config.provision.HostSpec;
import com.yahoo.config.provision.NodeResources;
import com.yahoo.schema.Schema;
import com.yahoo.schema.derived.SchemaInfo;
import com.yahoo.schema.document.Attribute;
import com.yahoo.schema.document.ImmutableSDField;
import com.yahoo.vespa.model.application.validation.Validation;
import com.yahoo.vespa.model.application.validation.Validator;
import com.yahoo.vespa.model.search.SearchCluster;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.stream.Collectors;

public class PagedAttributesRemoteStorageValidator
implements Validator {
    @Override
    public void validate(Validation.Context context) {
        Set contentClustersWithRemoteStorage = context.model().allocatedHosts().getHosts().stream().filter(hostSpec -> hostSpec.realResources().storageType() == NodeResources.StorageType.remote).map(HostSpec::membership).filter(Optional::isPresent).map(Optional::get).filter(membership -> membership.cluster().type() == ClusterSpec.Type.content).map(membership -> membership.cluster().id().value()).collect(Collectors.toSet());
        for (SearchCluster cluster : context.model().getSearchClusters()) {
            if (!contentClustersWithRemoteStorage.contains(cluster.getClusterName())) continue;
            for (SchemaInfo schema : cluster.schemas().values()) {
                PagedAttributesRemoteStorageValidator.validatePagedAttributes(context.deployState().getDeployLogger(), cluster.getClusterName(), schema.fullSchema());
            }
        }
    }

    private static void validatePagedAttributes(DeployLogger logger, String clusterName, Schema schema) {
        List<Attribute> fields = schema.allFields().flatMap(field -> PagedAttributesRemoteStorageValidator.pagedAttributes(field).stream()).collect(Collectors.toList());
        if (fields.isEmpty()) {
            return;
        }
        logger.logApplicationPackage(Level.WARNING, "Cluster '%s' has nodes with remote storage and fields with paged attributes. This might lead to performance issues when doing I/O. Consider using storage-type='local' or removing 'paged' setting for these fields: %s".formatted(clusterName, PagedAttributesRemoteStorageValidator.join(fields)));
    }

    private static String join(List<Attribute> fields) {
        String ret = fields.stream().limit(10L).map(Attribute::getName).map(s -> "'" + s + "'").collect(Collectors.joining(", "));
        return ret + (fields.size() > 10 ? ", ..." : "");
    }

    private static Set<Attribute> pagedAttributes(ImmutableSDField field) {
        return field.getAttributes().values().stream().filter(Attribute::isPaged).collect(Collectors.toSet());
    }
}

