/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.application.validation.change;

import com.yahoo.config.model.api.ConfigChangeAction;
import com.yahoo.config.model.api.ServiceInfo;
import com.yahoo.config.provision.ClusterSpec;
import java.util.List;
import java.util.stream.Collectors;

public abstract class VespaConfigChangeAction
implements ConfigChangeAction {
    private final ClusterSpec.Id id;
    private final String message;
    private final List<ServiceInfo> services;

    protected VespaConfigChangeAction(ClusterSpec.Id id, String message, List<ServiceInfo> services) {
        this.id = id;
        this.message = message;
        this.services = services;
    }

    public abstract VespaConfigChangeAction modifyAction(String var1, List<ServiceInfo> var2, String var3);

    public ClusterSpec.Id clusterId() {
        return this.id;
    }

    public String getMessage() {
        return this.message;
    }

    public List<ServiceInfo> getServices() {
        return this.services;
    }

    public String toString() {
        return "type='" + String.valueOf(this.getType()) + "', message='" + this.message + "', services=[" + this.services.stream().map(service -> service.getServiceName() + " '" + service.getConfigId() + "'").collect(Collectors.joining(", ")) + "]";
    }

    public boolean equals(Object o) {
        if (!(o instanceof VespaConfigChangeAction)) {
            return false;
        }
        VespaConfigChangeAction rhs = (VespaConfigChangeAction)o;
        if (!this.getType().equals((Object)rhs.getType())) {
            return false;
        }
        if (!this.message.equals(rhs.message)) {
            return false;
        }
        return this.services.equals(rhs.services);
    }

    public int hashCode() {
        int result = this.getType().hashCode();
        result = 31 * result + this.message.hashCode();
        result = 31 * result + this.services.hashCode();
        return result;
    }
}

