/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.container.http.ssl;

import com.yahoo.jdisc.http.ConnectorConfig;
import com.yahoo.vespa.model.container.http.ssl.SslProvider;
import java.util.Optional;

public class CloudSslProvider
extends SslProvider {
    private final String privateKey;
    private final String certificate;
    private final String caCertificatePath;
    private final String caCertificate;
    private final ConnectorConfig.Ssl.ClientAuth.Enum clientAuthentication;

    public CloudSslProvider(String servername, String privateKey, String certificate, String caCertificatePath, String caCertificate, ConnectorConfig.Ssl.ClientAuth.Enum clientAuthentication, boolean enableTokenSupport) {
        super("cloud-ssl-provider@", servername, CloudSslProvider.componentClass(enableTokenSupport), null);
        this.privateKey = privateKey;
        this.certificate = certificate;
        this.caCertificatePath = caCertificatePath;
        this.caCertificate = caCertificate;
        this.clientAuthentication = clientAuthentication;
    }

    private static String componentClass(boolean enableTokenSupport) {
        return enableTokenSupport ? "com.yahoo.jdisc.http.ssl.impl.CloudTokenSslContextProvider" : "com.yahoo.jdisc.http.ssl.impl.ConfiguredSslContextFactoryProvider";
    }

    @Override
    public void amendConnectorConfig(ConnectorConfig.Builder builder) {
        builder.ssl.enabled(true);
        builder.ssl.privateKey(this.privateKey);
        builder.ssl.certificate(this.certificate);
        builder.ssl.caCertificateFile(Optional.ofNullable(this.caCertificatePath).orElse(""));
        builder.ssl.caCertificate(Optional.ofNullable(this.caCertificate).orElse(""));
        builder.ssl.clientAuth(this.clientAuthentication);
    }
}

