/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.content;

public class DispatchTuning {
    public static final DispatchTuning empty = new Builder().build();
    private final Integer maxHitsPerPartition;
    private final DispatchPolicy dispatchPolicy;
    private final Boolean prioritizeAvailability;
    private final Double minActiveDocsCoverage;
    private final Double topkProbability;

    private DispatchTuning(Builder builder) {
        this.maxHitsPerPartition = builder.maxHitsPerPartition;
        this.dispatchPolicy = builder.dispatchPolicy;
        this.prioritizeAvailability = builder.prioritizeAvailability;
        this.minActiveDocsCoverage = builder.minActiveDocsCoverage;
        this.topkProbability = builder.topKProbability;
    }

    public Integer getMaxHitsPerPartition() {
        return this.maxHitsPerPartition;
    }

    public DispatchPolicy getDispatchPolicy() {
        return this.dispatchPolicy;
    }

    public Boolean getPrioritizeAvailability() {
        return this.prioritizeAvailability;
    }

    public Double getMinActiveDocsCoverage() {
        return this.minActiveDocsCoverage;
    }

    public Double getTopkProbability() {
        return this.topkProbability;
    }

    public static class Builder {
        private Integer maxHitsPerPartition;
        private DispatchPolicy dispatchPolicy;
        private Boolean prioritizeAvailability;
        private Double minActiveDocsCoverage;
        private Double topKProbability;

        public DispatchTuning build() {
            return new DispatchTuning(this);
        }

        public Builder setMaxHitsPerPartition(Integer maxHitsPerPartition) {
            this.maxHitsPerPartition = maxHitsPerPartition;
            return this;
        }

        public Builder setDispatchPolicy(String policy) {
            if (policy != null) {
                this.dispatchPolicy = Builder.toDispatchPolicy(policy);
            }
            return this;
        }

        public Builder setPrioritizeAvailability(Boolean prioritizeAvailability) {
            this.prioritizeAvailability = prioritizeAvailability;
            return this;
        }

        public Builder setMinActiveDocsCoverage(Double minCoverage) {
            this.minActiveDocsCoverage = minCoverage;
            return this;
        }

        public Builder setTopKProbability(Double topKProbability) {
            this.topKProbability = topKProbability;
            return this;
        }

        public static DispatchPolicy toDispatchPolicy(String policy) {
            return switch (policy.toLowerCase()) {
                case "adaptive", "random" -> DispatchPolicy.ADAPTIVE;
                case "round-robin" -> DispatchPolicy.ROUNDROBIN;
                case "latency-amortized-over-requests" -> DispatchPolicy.LATENCY_AMORTIZED_OVER_REQUESTS;
                case "latency-amortized-over-time" -> DispatchPolicy.LATENCY_AMORTIZED_OVER_TIME;
                case "best-of-random-2" -> DispatchPolicy.BEST_OF_RANDOM_2;
                default -> throw new IllegalArgumentException("Unknown dispatch policy '" + policy + "'");
            };
        }
    }

    public static enum DispatchPolicy {
        ROUNDROBIN,
        LATENCY_AMORTIZED_OVER_REQUESTS,
        LATENCY_AMORTIZED_OVER_TIME,
        BEST_OF_RANDOM_2,
        ADAPTIVE;

    }
}

