/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.schema.processing;

import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.document.DataType;
import com.yahoo.document.Field;
import com.yahoo.schema.RankProfileRegistry;
import com.yahoo.schema.Schema;
import com.yahoo.schema.document.SDField;
import com.yahoo.schema.processing.DynamicSummaryTransformUtils;
import com.yahoo.schema.processing.Processor;
import com.yahoo.vespa.documentmodel.SummaryField;
import com.yahoo.vespa.documentmodel.SummaryTransform;
import com.yahoo.vespa.indexinglanguage.ExpressionConverter;
import com.yahoo.vespa.indexinglanguage.expressions.AttributeExpression;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import com.yahoo.vespa.indexinglanguage.expressions.IndexExpression;
import com.yahoo.vespa.indexinglanguage.expressions.OutputExpression;
import com.yahoo.vespa.indexinglanguage.expressions.ScriptExpression;
import com.yahoo.vespa.indexinglanguage.expressions.StatementExpression;
import com.yahoo.vespa.indexinglanguage.expressions.SummaryExpression;
import com.yahoo.vespa.model.container.search.QueryProfiles;
import java.util.LinkedList;
import java.util.List;

public class IndexingOutputs
extends Processor {
    public IndexingOutputs(Schema schema, DeployLogger deployLogger, RankProfileRegistry rankProfileRegistry, QueryProfiles queryProfiles) {
        super(schema, deployLogger, rankProfileRegistry, queryProfiles);
    }

    @Override
    public void process(boolean validate, boolean documentsOnly) {
        for (SDField field : this.schema.allConcreteFields()) {
            ScriptExpression script = field.getIndexingScript();
            if (script == null) continue;
            this.findSummaryTo(this.schema, field);
            MyConverter converter = new MyConverter(this.schema, field, validate);
            field.setIndexingScript(this.schema.getName(), (ScriptExpression)converter.convert((Expression)script));
        }
    }

    public void findSummaryTo(Schema schema, SDField field) {
        List<SummaryField> summaryFields = schema.getSummaryFields(field);
        this.fillSummaryToFromSearch(schema, field, summaryFields);
    }

    private void fillSummaryToFromSearch(Schema schema, SDField field, List<SummaryField> summaryFields) {
        for (SummaryField summaryField : summaryFields) {
            this.fillSummaryToFromSummaryField(schema, field, summaryField);
        }
    }

    private void fillSummaryToFromSummaryField(Schema schema, SDField field, SummaryField summaryField) {
        DataType fieldType;
        SummaryTransform summaryTransform = summaryField.getTransform();
        if (summaryTransform.isDynamic() && summaryField.getSourceCount() > 2) {
            return;
        }
        if (summaryTransform.isDynamic() && !DynamicSummaryTransformUtils.isSupportedType(fieldType = field.getDataType())) {
            this.warn(schema, field, "Dynamic summaries are only supported for fields of type string and array<string>, ignoring summary field '" + summaryField.getName() + "' for field '" + field.getName() + "' of type " + fieldType.getName() + ".");
        }
    }

    private class MyConverter
    extends ExpressionConverter {
        final Schema schema;
        final Field field;
        final boolean validate;

        MyConverter(Schema schema, Field field, boolean validate) {
            this.schema = schema;
            this.field = field;
            this.validate = validate;
        }

        protected boolean shouldConvert(Expression exp) {
            if (!(exp instanceof OutputExpression)) {
                return false;
            }
            String fieldName = ((OutputExpression)exp).getFieldName();
            if (fieldName == null) {
                return true;
            }
            if (this.validate && !fieldName.equals(this.field.getName())) {
                IndexingOutputs.this.fail(this.schema, this.field, "Indexing expression '" + String.valueOf(exp) + "' attempts to write to a field other than '" + this.field.getName() + "'.");
            }
            return false;
        }

        protected Expression doConvert(Expression exp) {
            LinkedList<Object> ret = new LinkedList<Object>();
            if (exp instanceof AttributeExpression) {
                ret.add(new AttributeExpression(this.field.getName()));
            } else if (exp instanceof IndexExpression) {
                ret.add(new IndexExpression(this.field.getName()));
            } else if (exp instanceof SummaryExpression) {
                ret.add(new SummaryExpression(this.field.getName()));
            } else {
                throw new UnsupportedOperationException(exp.getClass().getName());
            }
            return new StatementExpression(ret);
        }
    }
}

