/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.application.validation.change;

import com.yahoo.config.application.api.ValidationId;
import com.yahoo.documentmodel.NewDocumentType;
import com.yahoo.vespa.model.application.validation.Validation;
import com.yahoo.vespa.model.application.validation.change.ChangeValidator;
import com.yahoo.vespa.model.content.cluster.ContentCluster;

public class ContentTypeRemovalValidator
implements ChangeValidator {
    @Override
    public void validate(Validation.ChangeContext context) {
        for (ContentCluster currentCluster : context.previousModel().getContentClusters().values()) {
            ContentCluster nextCluster = context.model().getContentClusters().get(currentCluster.getSubId());
            if (nextCluster == null) continue;
            for (NewDocumentType type : currentCluster.getDocumentDefinitions().values()) {
                if (nextCluster.getDocumentDefinitions().containsKey(type.getName())) continue;
                context.invalid(ValidationId.contentTypeRemoval, "Schema '" + type.getName() + "' is removed in content cluster '" + currentCluster.getName() + "'. This will cause loss of all data in this schema");
            }
        }
    }
}

