/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.application.validation.change;

import com.yahoo.config.model.api.ServiceInfo;
import com.yahoo.config.provision.ClusterSpec;
import com.yahoo.documentmodel.NewDocumentType;
import com.yahoo.schema.derived.AttributeFields;
import com.yahoo.schema.document.Attribute;
import com.yahoo.vespa.model.AbstractService;
import com.yahoo.vespa.model.application.validation.Validation;
import com.yahoo.vespa.model.application.validation.change.ChangeValidator;
import com.yahoo.vespa.model.application.validation.change.VespaConfigChangeAction;
import com.yahoo.vespa.model.application.validation.change.VespaRestartAction;
import com.yahoo.vespa.model.application.validation.change.search.ChangeMessageBuilder;
import com.yahoo.vespa.model.application.validation.change.search.DocumentTypeChangeValidator;
import com.yahoo.vespa.model.content.cluster.ContentCluster;
import com.yahoo.vespa.model.search.DocumentDatabase;
import com.yahoo.vespa.model.search.SearchCluster;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class StreamingSearchClusterChangeValidator
implements ChangeValidator {
    @Override
    public void validate(Validation.ChangeContext context) {
        context.previousModel().getContentClusters().forEach((clusterName, currentCluster) -> {
            ContentCluster nextCluster = context.model().getContentClusters().get(clusterName);
            if (nextCluster != null) {
                if (!nextCluster.getSearch().hasStreaming()) {
                    return;
                }
                if (currentCluster.getSearch().getSearchCluster() != null && nextCluster.getSearch().getSearchCluster() != null) {
                    StreamingSearchClusterChangeValidator.validateStreamingCluster(currentCluster, currentCluster.getSearch().getSearchCluster(), nextCluster, nextCluster.getSearch().getSearchCluster()).forEach(context::require);
                }
            }
        });
    }

    private static List<VespaConfigChangeAction> validateStreamingCluster(ContentCluster currentCluster, SearchCluster currentStreamingCluster, ContentCluster nextCluster, SearchCluster nextStreamingCluster) {
        ArrayList<VespaConfigChangeAction> result = new ArrayList<VespaConfigChangeAction>();
        for (DocumentDatabase currentDB : currentStreamingCluster.getDocumentDbs()) {
            DocumentDatabase nextDB = nextStreamingCluster.getDocumentDB(currentDB.getName());
            if (nextDB == null) continue;
            result.addAll(StreamingSearchClusterChangeValidator.validateDocumentDB(currentCluster, currentDB, nextCluster, nextDB));
        }
        return result;
    }

    private static List<VespaConfigChangeAction> validateDocumentDB(ContentCluster currentCluster, DocumentDatabase currentDB, ContentCluster nextCluster, DocumentDatabase nextDB) {
        ArrayList<VespaConfigChangeAction> result = new ArrayList<VespaConfigChangeAction>();
        result.addAll(StreamingSearchClusterChangeValidator.validateDocumentTypeChanges(currentCluster.id(), StreamingSearchClusterChangeValidator.getDocumentType(currentCluster, currentDB), StreamingSearchClusterChangeValidator.getDocumentType(nextCluster, nextDB)));
        result.addAll(StreamingSearchClusterChangeValidator.validateAttributeFastAccessAdded(currentCluster.id(), currentDB.getDerivedConfiguration().getAttributeFields(), nextDB.getDerivedConfiguration().getAttributeFields()));
        result.addAll(StreamingSearchClusterChangeValidator.validateAttributeFastAccessRemoved(currentCluster.id(), currentDB.getDerivedConfiguration().getAttributeFields(), nextDB.getDerivedConfiguration().getAttributeFields()));
        return StreamingSearchClusterChangeValidator.modifyActions(result, StreamingSearchClusterChangeValidator.getSearchNodeServices(nextCluster), nextDB.getName());
    }

    private static List<VespaConfigChangeAction> validateDocumentTypeChanges(ClusterSpec.Id id, NewDocumentType currentDocType, NewDocumentType nextDocType) {
        return new DocumentTypeChangeValidator(id, currentDocType, nextDocType).validate();
    }

    private static NewDocumentType getDocumentType(ContentCluster cluster, DocumentDatabase db) {
        return cluster.getDocumentDefinitions().get(db.getName());
    }

    private static List<VespaConfigChangeAction> validateAttributeFastAccessAdded(ClusterSpec.Id id, AttributeFields currentAttributes, AttributeFields nextAttributes) {
        return StreamingSearchClusterChangeValidator.validateAttributeFastAccessChanged(id, nextAttributes, currentAttributes, "add");
    }

    private static List<VespaConfigChangeAction> validateAttributeFastAccessRemoved(ClusterSpec.Id id, AttributeFields currentAttributes, AttributeFields nextAttributes) {
        return StreamingSearchClusterChangeValidator.validateAttributeFastAccessChanged(id, currentAttributes, nextAttributes, "remove");
    }

    private static List<VespaConfigChangeAction> validateAttributeFastAccessChanged(ClusterSpec.Id id, AttributeFields lhsAttributes, AttributeFields rhsAttributes, String change) {
        return lhsAttributes.attributes().stream().filter(attr -> attr.isFastAccess() && !StreamingSearchClusterChangeValidator.hasFastAccessAttribute(attr.getName(), rhsAttributes)).map(attr -> new VespaRestartAction(id, new ChangeMessageBuilder(attr.getName()).addChange(change + " fast-access attribute").build())).collect(Collectors.toList());
    }

    private static boolean hasFastAccessAttribute(String attrName, AttributeFields attributes) {
        Attribute attr = attributes.getAttribute(attrName);
        return attr != null && attr.isFastAccess();
    }

    private static List<ServiceInfo> getSearchNodeServices(ContentCluster cluster) {
        return cluster.getSearch().getSearchNodes().stream().map(AbstractService::getServiceInfo).toList();
    }

    private static List<VespaConfigChangeAction> modifyActions(List<VespaConfigChangeAction> result, List<ServiceInfo> services, String docTypeName) {
        return result.stream().map(action -> action.modifyAction("Document type '" + docTypeName + "': " + action.getMessage(), services, docTypeName)).collect(Collectors.toList());
    }
}

