/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.container;

import com.yahoo.config.model.builder.xml.XmlHelper;
import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.container.bundle.BundleInstantiationSpecification;
import com.yahoo.container.handler.threadpool.ContainerThreadpoolConfig;
import com.yahoo.container.handler.threadpool.ContainerThreadpoolImpl;
import com.yahoo.osgi.provider.model.ComponentModel;
import com.yahoo.vespa.model.container.component.SimpleComponent;
import java.util.logging.Level;
import org.w3c.dom.Element;

public abstract class ContainerThreadpool
extends SimpleComponent
implements ContainerThreadpoolConfig.Producer {
    private final String name;
    private final UserOptions options;

    protected ContainerThreadpool(DeployState ds, String name, Element parent) {
        super(new ComponentModel(BundleInstantiationSpecification.fromStrings((String)("threadpool@" + name), (String)ContainerThreadpoolImpl.class.getName(), null)));
        this.name = name;
        Element threadpoolElem = XmlHelper.getOptionalChild(parent, "threadpool").orElse(null);
        if (threadpoolElem == null) {
            this.options = new UserOptions(null, null, null, false);
        } else {
            boolean isRelative;
            Double max = null;
            Double min = null;
            Double queue = null;
            Element threadsElem = XmlHelper.getOptionalChild(threadpoolElem, "threads").orElse(null);
            if (threadsElem != null) {
                min = Double.parseDouble(threadsElem.getTextContent());
                String maxAttribute = XmlHelper.getOptionalAttribute(threadsElem, "max").orElse(null);
                String boostAttribute = XmlHelper.getOptionalAttribute(threadsElem, "boost").orElse(null);
                if (maxAttribute != null && boostAttribute != null) {
                    throw new IllegalArgumentException("For <threads>: both 'max' and 'boost' cannot be specified at the same time. Please use 'max' only.");
                }
                if (maxAttribute != null) {
                    max = Double.parseDouble(maxAttribute);
                } else if (boostAttribute != null) {
                    ds.getDeployLogger().logApplicationPackage(Level.WARNING, "For <threads>: the 'boost' attribute is deprecated, use 'max' instead.");
                    max = Double.parseDouble(boostAttribute);
                } else {
                    max = min;
                }
                Element queueElem = XmlHelper.getOptionalChild(threadpoolElem, "queue").orElse(null);
                if (queueElem != null) {
                    queue = Double.parseDouble(queueElem.getTextContent());
                }
                isRelative = true;
            } else {
                Element queueSizeElem;
                Element maxElem;
                Element minElem = XmlHelper.getOptionalChild(threadpoolElem, "min-threads").orElse(null);
                if (minElem != null) {
                    ds.getDeployLogger().logApplicationPackage(Level.WARNING, "For <threadpool>: <min-threads> is deprecated, use <threads> instead");
                }
                if ((maxElem = (Element)XmlHelper.getOptionalChild(threadpoolElem, "max-threads").orElse(null)) != null) {
                    ds.getDeployLogger().logApplicationPackage(Level.WARNING, "For <threadpool>: <max-threads> is deprecated, use <threads> with 'max' instead");
                }
                if (minElem != null) {
                    min = Double.parseDouble(minElem.getTextContent());
                }
                if (maxElem != null) {
                    max = Double.parseDouble(maxElem.getTextContent());
                }
                if ((queueSizeElem = (Element)XmlHelper.getOptionalChild(threadpoolElem, "queue-size").orElse(null)) != null) {
                    ds.getDeployLogger().logApplicationPackage(Level.WARNING, "For <threadpool>: <queue-size> is deprecated, use <queue> instead");
                }
                if (queueSizeElem != null) {
                    queue = Double.parseDouble(queueSizeElem.getTextContent());
                }
                isRelative = false;
            }
            if (min != null && min < 0.0) {
                throw new IllegalArgumentException("For <threadpool>: <threads> must be positive.");
            }
            if (max != null && max <= 0.0) {
                throw new IllegalArgumentException("For <threadpool>: 'max' on <threads> must be positive.");
            }
            if (queue != null && queue < 0.0) {
                throw new IllegalArgumentException("For <threadpool>: <queue> must be positive.");
            }
            if (min != null && max != null && min > max) {
                throw new IllegalArgumentException("For <threadpool>: 'max' on <threads> must be greater than <threads>.");
            }
            this.options = new UserOptions(max, min, queue, isRelative);
        }
    }

    protected abstract void setDefaultConfigValues(ContainerThreadpoolConfig.Builder var1);

    public void getConfig(ContainerThreadpoolConfig.Builder builder) {
        this.setDefaultConfigValues(builder);
        builder.name(this.name);
        if (this.options.max() != null) {
            if (this.options.isRelative()) {
                builder.relativeMaxThreads(this.options.max().doubleValue());
            } else {
                builder.maxThreads(this.options.max().intValue());
            }
        }
        if (this.options.min() != null) {
            if (this.options.isRelative()) {
                builder.relativeMinThreads(this.options.min().doubleValue());
            } else {
                builder.minThreads(this.options.min().intValue());
            }
        }
        if (this.options.queueSize() != null) {
            if (this.options.isRelative()) {
                builder.relativeQueueSize(this.options.queueSize().doubleValue());
            } else {
                builder.queueSize(this.options.queueSize().intValue());
            }
        }
    }

    record UserOptions(Double max, Double min, Double queueSize, boolean isRelative) {
    }
}

