/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.content;

import com.yahoo.config.model.api.ModelContext;
import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.config.model.producer.AnyConfigProducer;
import com.yahoo.config.model.producer.TreeConfigProducer;
import com.yahoo.config.provision.ClusterSpec;
import com.yahoo.documentmodel.NewDocumentType;
import com.yahoo.schema.derived.SchemaInfo;
import com.yahoo.vespa.config.search.DispatchConfig;
import com.yahoo.vespa.config.search.DispatchNodesConfig;
import com.yahoo.vespa.config.search.core.ProtonConfig;
import com.yahoo.vespa.model.builder.xml.dom.ModelElement;
import com.yahoo.vespa.model.content.ContentNode;
import com.yahoo.vespa.model.content.Redundancy;
import com.yahoo.vespa.model.content.ResourceLimits;
import com.yahoo.vespa.model.content.StorageGroup;
import com.yahoo.vespa.model.content.TopologicalDocumentTypeSorter;
import com.yahoo.vespa.model.search.IndexedSearchCluster;
import com.yahoo.vespa.model.search.IndexingCluster;
import com.yahoo.vespa.model.search.NodeSpec;
import com.yahoo.vespa.model.search.SearchNode;
import com.yahoo.vespa.model.search.Tuning;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;

public class ContentSearchCluster
extends TreeConfigProducer<AnyConfigProducer>
implements ProtonConfig.Producer,
Redundancy.Provider {
    private static final int DEFAULT_DOC_STORE_COMPRESSION_LEVEL = 3;
    private static final double DEFAULT_DISK_BLOAT = 0.25;
    private final boolean flushOnShutdown;
    private final Boolean syncTransactionLog;
    private IndexedSearchCluster searchCluster;
    private final IndexingCluster indexingCluster;
    private Redundancy redundancy;
    private final String clusterName;
    private final Map<String, NewDocumentType> documentDefinitions;
    private final Set<NewDocumentType> globallyDistributedDocuments;
    private Double visibilityDelay = 0.0;
    private final List<SearchNode> nonIndexed = new ArrayList<SearchNode>();
    private final Map<StorageGroup, NodeSpec> groupToSpecMap = new LinkedHashMap<StorageGroup, NodeSpec>();
    private ResourceLimits resourceLimits;
    private final double defaultFeedConcurrency;
    private final double defaultFeedNiceness;
    private final boolean forwardIssuesToQrs;
    private final int searchCoreMaxOutstandingMoveOps;
    private final int searchNodeInitializerThreads;
    private Tuning tuning;

    public ContentSearchCluster(TreeConfigProducer<?> parent, String clusterName, ModelContext.FeatureFlags featureFlags, Map<String, NewDocumentType> documentDefinitions, Set<NewDocumentType> globallyDistributedDocuments, boolean flushOnShutdown, Boolean syncTransactionLog, int searchNodeInitializeThreads) {
        super(parent, "search");
        this.indexingCluster = new IndexingCluster();
        this.clusterName = clusterName;
        this.documentDefinitions = documentDefinitions;
        this.globallyDistributedDocuments = globallyDistributedDocuments;
        this.flushOnShutdown = flushOnShutdown;
        this.syncTransactionLog = syncTransactionLog;
        this.defaultFeedConcurrency = featureFlags.feedConcurrency();
        this.defaultFeedNiceness = featureFlags.feedNiceness();
        this.forwardIssuesToQrs = featureFlags.forwardIssuesAsErrors();
        this.searchCoreMaxOutstandingMoveOps = featureFlags.searchCoreMaxOutstandingMoveOps();
        this.searchNodeInitializerThreads = searchNodeInitializeThreads;
    }

    public void setVisibilityDelay(double delay) {
        this.visibilityDelay = delay;
        if (this.searchCluster != null) {
            this.searchCluster.setVisibilityDelay(delay);
        }
    }

    public void addCluster(IndexedSearchCluster sc) {
        if (this.searchCluster != null) {
            throw new IllegalArgumentException("Duplicate indexed cluster '" + this.searchCluster.getClusterName() + "'");
        }
        this.searchCluster = sc;
    }

    public Boolean isStreaming() {
        if (this.searchCluster == null) {
            return false;
        }
        boolean hasStreaming = this.searchCluster.hasStreaming();
        if (this.searchCluster.hasIndexed() == hasStreaming) {
            return null;
        }
        return hasStreaming;
    }

    public boolean hasStreaming() {
        return this.searchCluster != null && this.searchCluster.hasStreaming();
    }

    public boolean hasIndexed() {
        return this.searchCluster != null && this.searchCluster.hasIndexed();
    }

    public List<SearchNode> getSearchNodes() {
        return this.searchCluster != null ? this.searchCluster.getSearchNodes() : this.nonIndexed;
    }

    public void addSearchNode(DeployState deployState, ContentNode node, StorageGroup parentGroup) {
        NodeSpec spec = this.getNextSearchNodeSpec(parentGroup);
        SearchNode searchNode = SearchNode.create(this.parent(), "" + node.getDistributionKey(), node.getDistributionKey(), spec, this.clusterName, node, this.flushOnShutdown, this.tuning, deployState.isHosted(), this.syncTransactionLog, deployState.getProperties().mallocImpl(Optional.of(ClusterSpec.Type.content)));
        searchNode.setHostResource(node.getHostResource());
        searchNode.initService(deployState);
        this.addSearchNode(searchNode);
    }

    public void addSearchNode(DeployState deployState, ContentNode node, StorageGroup parentGroup, ModelElement element) {
        NodeSpec spec = this.getNextSearchNodeSpec(parentGroup);
        SearchNode searchNode = (SearchNode)new SearchNode.Builder("" + node.getDistributionKey(), spec, this.clusterName, node, this.flushOnShutdown, this.tuning, this.syncTransactionLog).build(deployState, this.parent(), element.getXml());
        this.addSearchNode(searchNode);
    }

    private void addSearchNode(SearchNode searchNode) {
        if (this.searchCluster != null) {
            this.searchCluster.addSearcher(searchNode);
        } else {
            this.nonIndexed.add(searchNode);
        }
    }

    private TreeConfigProducer<AnyConfigProducer> parent() {
        return this.searchCluster != null ? this.searchCluster : this;
    }

    private NodeSpec getNextSearchNodeSpec(StorageGroup parentGroup) {
        NodeSpec spec = this.groupToSpecMap.get(parentGroup);
        spec = spec == null ? new NodeSpec(this.groupToSpecMap.size(), 0) : new NodeSpec(spec.groupIndex(), spec.partitionId() + 1);
        this.groupToSpecMap.put(parentGroup, spec);
        return spec;
    }

    public void setTuning(Tuning tuning) {
        this.tuning = tuning;
    }

    public void setResourceLimits(ResourceLimits resourceLimits) {
        this.resourceLimits = resourceLimits;
    }

    public boolean usesHierarchicDistribution() {
        return this.searchCluster != null && this.groupToSpecMap.size() > 1;
    }

    public void handleRedundancy(Redundancy redundancy) {
        this.redundancy = redundancy;
    }

    public List<NewDocumentType> getDocumentTypesWithStreamingCluster() {
        return this.documentTypes(this::hasIndexingModeStreaming);
    }

    public List<NewDocumentType> getDocumentTypesWithIndexedCluster() {
        return this.documentTypes(this::hasIndexingModeIndexed);
    }

    public List<NewDocumentType> getDocumentTypesWithStoreOnly() {
        return this.documentTypes(this::hasIndexingModeStoreOnly);
    }

    private List<NewDocumentType> documentTypes(Predicate<NewDocumentType> filter) {
        return this.documentDefinitions.values().stream().filter(filter).toList();
    }

    private boolean hasIndexingModeStreaming(NewDocumentType type) {
        if (this.searchCluster == null) {
            return false;
        }
        SchemaInfo schemaInfo = this.searchCluster.schemas().get(type.getName());
        return schemaInfo != null && schemaInfo.getIndexMode() == SchemaInfo.IndexMode.STREAMING;
    }

    private boolean hasIndexingModeIndexed(NewDocumentType type) {
        if (this.searchCluster == null) {
            return false;
        }
        SchemaInfo schemaInfo = this.searchCluster.schemas().get(type.getName());
        return schemaInfo != null && schemaInfo.getIndexMode() == SchemaInfo.IndexMode.INDEX;
    }

    private boolean hasIndexingModeStoreOnly(NewDocumentType type) {
        return !this.hasIndexingModeStreaming(type) && !this.hasIndexingModeIndexed(type);
    }

    public void getConfig(ProtonConfig.Builder builder) {
        boolean hasAnyNonIndexedSchema = false;
        for (NewDocumentType type : TopologicalDocumentTypeSorter.sort(this.documentDefinitions.values())) {
            ProtonConfig.Documentdb.Builder ddbB = new ProtonConfig.Documentdb.Builder();
            String docTypeName = type.getFullName().getName();
            boolean globalDocType = this.isGloballyDistributed(type);
            ddbB.inputdoctypename(docTypeName).configid(this.getConfigId()).visibilitydelay(this.visibilityDelay.doubleValue()).global(globalDocType);
            if (this.hasIndexingModeStreaming(type)) {
                hasAnyNonIndexedSchema = true;
                ddbB.configid(this.searchCluster.getDocumentDBConfigId(type.getFullName().getName()));
                ddbB.mode(ProtonConfig.Documentdb.Mode.Enum.STREAMING);
            } else if (this.hasIndexingModeIndexed(type)) {
                ddbB.configid(this.searchCluster.getDocumentDBConfigId(type.getFullName().getName()));
                ddbB.mode(ProtonConfig.Documentdb.Mode.Enum.INDEX);
            } else {
                hasAnyNonIndexedSchema = true;
                ddbB.mode(ProtonConfig.Documentdb.Mode.Enum.STORE_ONLY);
            }
            if (globalDocType) {
                ddbB.visibilitydelay(0.0);
            }
            builder.documentdb(ddbB);
        }
        if (hasAnyNonIndexedSchema) {
            builder.feeding.concurrency(Math.min(1.0, this.defaultFeedConcurrency * 2.0));
        } else {
            builder.feeding.concurrency(this.defaultFeedConcurrency);
        }
        builder.feeding.niceness(this.defaultFeedNiceness);
        builder.flush.memory.diskbloatfactor(0.25);
        builder.flush.memory.each.diskbloatfactor(0.25);
        builder.summary.log.chunk.compression.level(3);
        builder.summary.log.compact.compression.level(3);
        builder.maintenancejobs.maxoutstandingmoveops(this.searchCoreMaxOutstandingMoveOps);
        builder.forward_issues(this.forwardIssuesToQrs);
        int numDocumentDbs = builder.documentdb.size();
        builder.initialize(new ProtonConfig.Initialize.Builder().threads(this.searchNodeInitializerThreads == 0 ? numDocumentDbs + 1 : this.searchNodeInitializerThreads));
        if (this.resourceLimits != null) {
            this.resourceLimits.getConfig(builder);
        }
        if (this.tuning != null) {
            this.tuning.getConfig(builder);
        }
        if (this.redundancy != null) {
            this.redundancy.getConfig(builder);
        }
        this.setMaxFlushed(builder);
    }

    private void setMaxFlushed(ProtonConfig.Builder builder) {
        double concurrency = builder.feeding.build().concurrency();
        if (concurrency > this.defaultFeedConcurrency) {
            int maxFlushes = (int)Math.ceil(4.0 * concurrency);
            builder.index.maxflushed(maxFlushes);
        }
    }

    private boolean isGloballyDistributed(NewDocumentType docType) {
        return this.globallyDistributedDocuments.contains(docType);
    }

    public void getConfig(DispatchNodesConfig.Builder builder) {
        if (this.searchCluster != null) {
            this.searchCluster.getConfig(builder);
        }
    }

    public void getConfig(DispatchConfig.Builder builder) {
        if (this.searchCluster != null) {
            this.searchCluster.getConfig(builder);
        }
    }

    public IndexedSearchCluster getSearchCluster() {
        return this.searchCluster;
    }

    public boolean hasSearchCluster() {
        return this.searchCluster != null;
    }

    public IndexingCluster getIndexingDocproc() {
        return this.indexingCluster;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public String toString() {
        return "content cluster '" + this.clusterName + "'";
    }

    @Override
    public Redundancy redundancy() {
        return this.redundancy;
    }
}

