/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.content;

import com.yahoo.config.model.ConfigModelContext;
import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.config.provision.ClusterMembership;
import com.yahoo.config.provision.ClusterSpec;
import com.yahoo.config.provision.Environment;
import com.yahoo.vespa.config.content.StorDistributionConfig;
import com.yahoo.vespa.model.HostResource;
import com.yahoo.vespa.model.HostSystem;
import com.yahoo.vespa.model.builder.xml.dom.DomStorageNodeBuilder;
import com.yahoo.vespa.model.builder.xml.dom.ModelElement;
import com.yahoo.vespa.model.builder.xml.dom.NodesSpecification;
import com.yahoo.vespa.model.content.Distributor;
import com.yahoo.vespa.model.content.Redundancy;
import com.yahoo.vespa.model.content.StorageNode;
import com.yahoo.vespa.model.content.cluster.ContentCluster;
import com.yahoo.vespa.model.content.cluster.RedundancyBuilder;
import com.yahoo.vespa.model.content.engines.PersistenceEngine;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Level;

public class StorageGroup {
    private final boolean useCpuSocketAffinity;
    private final String index;
    private Optional<String> partitions;
    String name;
    private final boolean isHosted;
    private final Optional<Long> mmapNoCoreLimit;
    private final Optional<Boolean> coreOnOOM;
    private final Optional<String> noVespaMalloc;
    private final Optional<String> vespaMalloc;
    private final Optional<String> vespaMallocDebug;
    private final Optional<String> vespaMallocDebugStackTrace;
    private final List<StorageGroup> subgroups = new ArrayList<StorageGroup>();
    private final List<StorageNode> nodes = new ArrayList<StorageNode>();

    private StorageGroup(boolean isHosted, String name, String index, Optional<String> partitions, boolean useCpuSocketAffinity, Optional<Long> mmapNoCoreLimit, Optional<Boolean> coreOnOOM, Optional<String> noVespaMalloc, Optional<String> vespaMalloc, Optional<String> vespaMallocDebug, Optional<String> vespaMallocDebugStackTrace) {
        this.isHosted = isHosted;
        this.index = index;
        this.name = name;
        this.partitions = partitions;
        this.useCpuSocketAffinity = useCpuSocketAffinity;
        this.mmapNoCoreLimit = mmapNoCoreLimit;
        this.coreOnOOM = coreOnOOM;
        this.noVespaMalloc = noVespaMalloc;
        this.vespaMalloc = vespaMalloc;
        this.vespaMallocDebug = vespaMallocDebug;
        this.vespaMallocDebugStackTrace = vespaMallocDebugStackTrace;
    }

    private StorageGroup(boolean isHosted, String name, String index) {
        this(isHosted, name, index, Optional.empty(), false, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    }

    public String getName() {
        return this.name;
    }

    public List<StorageGroup> getSubgroups() {
        return this.subgroups;
    }

    public List<StorageNode> getNodes() {
        return this.nodes;
    }

    public boolean isHosted() {
        return this.isHosted;
    }

    public String getIndex() {
        return this.index;
    }

    public Optional<String> getPartitions() {
        return this.partitions;
    }

    public boolean useCpuSocketAffinity() {
        return this.useCpuSocketAffinity;
    }

    public Optional<Long> getMmapNoCoreLimit() {
        return this.mmapNoCoreLimit;
    }

    public Optional<Boolean> getCoreOnOOM() {
        return this.coreOnOOM;
    }

    public Optional<String> getNoVespaMalloc() {
        return this.noVespaMalloc;
    }

    public Optional<String> getVespaMalloc() {
        return this.vespaMalloc;
    }

    public Optional<String> getVespaMallocDebug() {
        return this.vespaMallocDebug;
    }

    public Optional<String> getVespaMallocDebugStackTrace() {
        return this.vespaMallocDebugStackTrace;
    }

    public List<StorageNode> recursiveGetNodes() {
        if (!this.nodes.isEmpty()) {
            return this.nodes;
        }
        ArrayList<StorageNode> nodes = new ArrayList<StorageNode>();
        for (StorageGroup subgroup : this.subgroups) {
            nodes.addAll(subgroup.recursiveGetNodes());
        }
        return nodes;
    }

    public Collection<StorDistributionConfig.Group.Builder> getGroupStructureConfig() {
        ArrayList<StorDistributionConfig.Group.Builder> groups = new ArrayList<StorDistributionConfig.Group.Builder>();
        StorDistributionConfig.Group.Builder myGroup = new StorDistributionConfig.Group.Builder();
        this.getConfig(myGroup);
        groups.add(myGroup);
        for (StorageGroup g : this.subgroups) {
            groups.addAll(g.getGroupStructureConfig());
        }
        return groups;
    }

    public void getConfig(StorDistributionConfig.Group.Builder builder) {
        builder.index(this.index == null ? "invalid" : this.index);
        builder.name(this.name == null ? "invalid" : this.name);
        this.partitions.ifPresent(arg_0 -> ((StorDistributionConfig.Group.Builder)builder).partitions(arg_0));
        for (StorageNode node : this.nodes) {
            StorDistributionConfig.Group.Nodes.Builder nb = new StorDistributionConfig.Group.Nodes.Builder();
            nb.index(node.getDistributionKey());
            nb.retired(node.isRetired());
            builder.nodes.add(nb);
        }
        builder.capacity(this.getCapacity());
    }

    public int getNumberOfLeafGroups() {
        if (this.subgroups.isEmpty()) {
            return 1;
        }
        int count = 0;
        for (StorageGroup g : this.subgroups) {
            count += g.getNumberOfLeafGroups();
        }
        return count;
    }

    public double getCapacity() {
        double capacity = 0.0;
        for (StorageNode node : this.nodes) {
            capacity += node.getCapacity();
        }
        for (StorageGroup group : this.subgroups) {
            capacity += group.getCapacity();
        }
        return capacity;
    }

    public int countNodes(boolean includeRetired) {
        int nodeCount = (int)this.nodes.stream().filter(node -> includeRetired || !node.isRetired()).count();
        for (StorageGroup group : this.subgroups) {
            nodeCount += group.countNodes(includeRetired);
        }
        return nodeCount;
    }

    public boolean equals(Object o) {
        if (o instanceof StorageGroup) {
            StorageGroup other = (StorageGroup)o;
            return this.index.equals(other.index) && this.name.equals(other.name) && this.partitions.equals(other.partitions);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.index, this.name, this.partitions);
    }

    public static Map<HostResource, ClusterMembership> provisionHosts(NodesSpecification nodesSpecification, ClusterSpec.Id clusterId, HostSystem hostSystem, ConfigModelContext context) {
        return nodesSpecification.provision(hostSystem, ClusterSpec.Type.content, clusterId, context.getDeployLogger(), true, context.clusterInfo().build());
    }

    public static class Builder {
        private final ModelElement clusterElement;
        private final ConfigModelContext context;

        public Builder(ModelElement clusterElement, ConfigModelContext context) {
            this.clusterElement = clusterElement;
            this.context = context;
        }

        public StorageGroup buildRootGroup(DeployState deployState, ContentCluster owner, Boolean isStreaming) {
            try {
                if (owner.isHosted()) {
                    this.validateRedundancyAndGroups(deployState.zone().environment());
                }
                Optional<ModelElement> group = Optional.ofNullable(this.clusterElement.child("group"));
                Optional<ModelElement> nodes = this.getNodes(this.clusterElement);
                if (group.isPresent() && nodes.isPresent()) {
                    throw new IllegalArgumentException("Both <group> and <nodes> is specified: Only one of these tags can be used in the same configuration");
                }
                if (group.isPresent() && group.get().integerAttribute("distribution-key") != null) {
                    deployState.getDeployLogger().logApplicationPackage(Level.INFO, "'distribution-key' attribute on a content cluster's root group is ignored");
                }
                GroupBuilder groupBuilder = this.collectGroup(owner.isHosted(), group, nodes, null, null);
                StorageGroup storageGroup = owner.isHosted() ? groupBuilder.buildHosted(deployState, owner, Optional.empty(), this.context) : groupBuilder.buildNonHosted(deployState, owner, Optional.empty());
                RedundancyBuilder redundancyBuilder = new RedundancyBuilder(this.clusterElement);
                Redundancy redundancy = redundancyBuilder.build(owner.isHosted(), isStreaming, storageGroup.subgroups.size(), storageGroup.getNumberOfLeafGroups(), storageGroup.countNodes(false));
                owner.setRedundancy(redundancy);
                if (storageGroup.partitions.isEmpty() && redundancy.groups() > 1) {
                    storageGroup.partitions = Optional.of(Builder.computePartitions(redundancy.finalRedundancy(), redundancy.groups()));
                }
                return storageGroup;
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("In " + String.valueOf(owner), e);
            }
        }

        private void validateRedundancyAndGroups(Environment environment) {
            ModelElement redundancyElement = this.clusterElement.child("redundancy");
            if (redundancyElement == null) {
                return;
            }
            long redundancy = redundancyElement.asLong();
            ModelElement nodesElement = this.clusterElement.child("nodes");
            if (nodesElement == null) {
                return;
            }
            NodesSpecification nodesSpec = NodesSpecification.from(nodesElement, this.context);
            if (!nodesSpec.hasCountAttribute() && environment == Environment.dev) {
                return;
            }
            int minNodesPerGroup = (int)Math.ceil((double)nodesSpec.minResources().nodes() / (double)nodesSpec.minResources().groups());
            if ((long)minNodesPerGroup < redundancy) {
                throw new IllegalArgumentException("This cluster specifies redundancy " + redundancy + ", but this cannot be higher than the minimum nodes per group, which is " + minNodesPerGroup);
            }
        }

        private static String computePartitions(int redundancyPerGroup, int numGroups) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < numGroups - 1; ++i) {
                sb.append(redundancyPerGroup);
                sb.append("|");
            }
            sb.append("*");
            return sb.toString();
        }

        private GroupBuilder collectGroup(boolean isHosted, Optional<ModelElement> groupElement, Optional<ModelElement> nodesElement, String name, String index) {
            Optional<NodesSpecification> nodeRequirement;
            StorageGroup group = new StorageGroup(isHosted, name, index, this.childAsString(groupElement, "distribution.partitions"), this.booleanAttributeOr(groupElement, "cpu-socket-affinity", false), this.childAsLong(groupElement, "mmap-core-limit"), this.childAsBoolean(groupElement, "core-on-oom"), this.childAsString(groupElement, "no-vespamalloc"), this.childAsString(groupElement, "vespamalloc"), this.childAsString(groupElement, "vespamalloc-debug"), this.childAsString(groupElement, "vespamalloc-debug-stacktrace"));
            List subGroups = groupElement.map(modelElement -> this.collectSubGroups(isHosted, group, (ModelElement)modelElement)).orElseGet(List::of);
            ArrayList<XmlNodeBuilder> explicitNodes = new ArrayList<XmlNodeBuilder>();
            explicitNodes.addAll(this.collectExplicitNodes(groupElement));
            explicitNodes.addAll(this.collectExplicitNodes(nodesElement));
            if (!subGroups.isEmpty() && nodesElement.isPresent()) {
                throw new IllegalArgumentException("A group can contain either explicit subgroups or a nodes specification, but not both.");
            }
            if (nodesElement.isPresent() && nodesElement.get().stringAttribute("count") != null) {
                nodeRequirement = Optional.of(NodesSpecification.from(nodesElement.get(), this.context));
            } else if (nodesElement.isPresent() && this.context.getDeployState().isHosted() && this.context.getDeployState().zone().environment().isManuallyDeployed()) {
                nodeRequirement = Optional.of(NodesSpecification.from(nodesElement.get(), this.context));
            } else if (nodesElement.isEmpty() && subGroups.isEmpty() && this.context.getDeployState().isHosted()) {
                nodeRequirement = Optional.of(NodesSpecification.nonDedicated(1, this.context));
            } else {
                if (nodesElement.isPresent() && nodesElement.get().stringAttribute("count") == null && this.context.getDeployState().isHosted()) {
                    throw new IllegalArgumentException("Clusters in hosted environments must have a <nodes count='N'> tag\nmatching all zones, and having no <node> subtags,\nsee https://docs.vespa.ai/en/reference/services.html#nodes");
                }
                nodeRequirement = Optional.empty();
            }
            return new GroupBuilder(group, subGroups, explicitNodes, nodeRequirement);
        }

        private Optional<String> childAsString(Optional<ModelElement> element, String childTagName) {
            return element.map(modelElement -> modelElement.childAsString(childTagName));
        }

        private Optional<Long> childAsLong(Optional<ModelElement> element, String childTagName) {
            return element.map(modelElement -> modelElement.childAsLong(childTagName));
        }

        private Optional<Boolean> childAsBoolean(Optional<ModelElement> element, String childTagName) {
            return element.map(modelElement -> modelElement.childAsBoolean(childTagName));
        }

        private boolean booleanAttributeOr(Optional<ModelElement> element, String attributeName, boolean defaultValue) {
            return element.map(modelElement -> modelElement.booleanAttribute(attributeName, defaultValue)).orElse(defaultValue);
        }

        private Optional<ModelElement> getNodes(ModelElement groupOrNodesElement) {
            if (groupOrNodesElement.getXml().getTagName().equals("nodes")) {
                return Optional.of(groupOrNodesElement);
            }
            return Optional.ofNullable(groupOrNodesElement.child("nodes"));
        }

        private List<XmlNodeBuilder> collectExplicitNodes(Optional<ModelElement> groupOrNodesElement) {
            if (groupOrNodesElement.isEmpty()) {
                return List.of();
            }
            ArrayList<XmlNodeBuilder> nodes = new ArrayList<XmlNodeBuilder>();
            for (ModelElement n : groupOrNodesElement.get().subElements("node")) {
                nodes.add(new XmlNodeBuilder(this.clusterElement, n));
            }
            return nodes;
        }

        private List<GroupBuilder> collectSubGroups(boolean isHosted, StorageGroup parentGroup, ModelElement parentGroupElement) {
            List<ModelElement> subGroupElements = parentGroupElement.subElements("group");
            if (subGroupElements.size() > 1 && parentGroup.getPartitions().isEmpty()) {
                throw new IllegalArgumentException("'distribution' attribute is required with multiple subgroups");
            }
            ArrayList<GroupBuilder> subGroups = new ArrayList<GroupBuilder>();
            Object indexPrefix = "";
            if (parentGroup.index != null) {
                indexPrefix = parentGroup.index + ".";
            }
            for (ModelElement g : subGroupElements) {
                subGroups.add(this.collectGroup(isHosted, Optional.of(g), Optional.ofNullable(g.child("nodes")), g.stringAttribute("name"), (String)indexPrefix + g.integerAttribute("distribution-key")));
            }
            return subGroups;
        }

        private static StorageNode createStorageNode(DeployState deployState, ContentCluster parent, HostResource hostResource, StorageGroup parentGroup, ClusterMembership clusterMembership) {
            StorageNode sNode = new StorageNode(deployState.getProperties(), parent.getStorageCluster(), null, clusterMembership.index(), clusterMembership.retired());
            sNode.setHostResource(hostResource);
            sNode.initService(deployState);
            parent.getSearch().addSearchNode(deployState, sNode, parentGroup);
            PersistenceEngine provider = parent.getPersistence().create(sNode);
            Distributor d = new Distributor(deployState.getProperties(), parent.getDistributorNodes(), clusterMembership.index(), null, provider);
            d.setHostResource(sNode.getHostResource());
            d.initService(deployState);
            return sNode;
        }

        private static class GroupBuilder {
            private final StorageGroup storageGroup;
            private final List<GroupBuilder> subGroups;
            private final List<XmlNodeBuilder> nodeBuilders;
            private final Optional<NodesSpecification> nodeRequirement;

            private GroupBuilder(StorageGroup storageGroup, List<GroupBuilder> subGroups, List<XmlNodeBuilder> nodeBuilders, Optional<NodesSpecification> nodeRequirement) {
                this.storageGroup = storageGroup;
                this.subGroups = subGroups;
                this.nodeBuilders = nodeBuilders;
                this.nodeRequirement = nodeRequirement;
            }

            public StorageGroup buildNonHosted(DeployState deployState, ContentCluster owner, Optional<GroupBuilder> parent) {
                for (GroupBuilder subGroup : this.subGroups) {
                    this.storageGroup.subgroups.add(subGroup.buildNonHosted(deployState, owner, Optional.of(this)));
                }
                for (XmlNodeBuilder nodeBuilder : this.nodeBuilders) {
                    this.storageGroup.nodes.add(nodeBuilder.build(deployState, owner, this.storageGroup));
                }
                if (parent.isEmpty() && this.subGroups.isEmpty() && this.nodeBuilders.isEmpty()) {
                    this.storageGroup.nodes.add(this.buildSingleNode(deployState, owner));
                }
                return this.storageGroup;
            }

            private StorageNode buildSingleNode(DeployState deployState, ContentCluster parent) {
                int distributionKey = 0;
                StorageNode storageNode = new StorageNode(deployState.getProperties(), parent.getStorageCluster(), 1.0, distributionKey, false);
                storageNode.setHostResource(parent.hostSystem().getHost("default_singlenode_container"));
                parent.getSearch().addSearchNode(deployState, storageNode, this.storageGroup);
                PersistenceEngine provider = parent.getPersistence().create(storageNode);
                storageNode.initService(deployState);
                Distributor distributor = new Distributor(deployState.getProperties(), parent.getDistributorNodes(), distributionKey, null, provider);
                distributor.setHostResource(storageNode.getHostResource());
                distributor.initService(deployState);
                return storageNode;
            }

            public StorageGroup buildHosted(DeployState deployState, ContentCluster owner, Optional<GroupBuilder> parent, ConfigModelContext context) {
                if (this.storageGroup.getIndex() != null) {
                    throw new IllegalArgumentException("Specifying individual groups is not supported on hosted applications");
                }
                Map<HostResource, ClusterMembership> hostMapping = this.nodeRequirement.isPresent() ? StorageGroup.provisionHosts(this.nodeRequirement.get(), ClusterSpec.Id.from((String)owner.getStorageCluster().getClusterName()), owner.getRoot().hostSystem(), context) : Map.of();
                Map<Optional<ClusterSpec.Group>, Map<HostResource, ClusterMembership>> hostGroups = this.collectAllocatedSubgroups(hostMapping);
                if (hostGroups.size() > 1) {
                    if (parent.isPresent()) {
                        throw new IllegalArgumentException("Cannot specify groups using the groups attribute in nested content groups");
                    }
                    for (Map.Entry<Optional<ClusterSpec.Group>, Map<HostResource, ClusterMembership>> hostGroup : hostGroups.entrySet()) {
                        String groupIndex = String.valueOf(hostGroup.getKey().get().index());
                        StorageGroup subgroup = new StorageGroup(true, groupIndex, groupIndex);
                        for (Map.Entry<HostResource, ClusterMembership> host : hostGroup.getValue().entrySet()) {
                            subgroup.nodes.add(Builder.createStorageNode(deployState, owner, host.getKey(), subgroup, host.getValue()));
                        }
                        this.storageGroup.subgroups.add(subgroup);
                    }
                } else {
                    for (Map.Entry<HostResource, ClusterMembership> host : hostMapping.entrySet()) {
                        this.storageGroup.nodes.add(Builder.createStorageNode(deployState, owner, host.getKey(), this.storageGroup, host.getValue()));
                    }
                    for (GroupBuilder subGroup : this.subGroups) {
                        this.storageGroup.subgroups.add(subGroup.buildHosted(deployState, owner, Optional.of(this), context));
                    }
                }
                return this.storageGroup;
            }

            private Map<Optional<ClusterSpec.Group>, Map<HostResource, ClusterMembership>> collectAllocatedSubgroups(Map<HostResource, ClusterMembership> hostMapping) {
                LinkedHashMap<Optional<ClusterSpec.Group>, Map<HostResource, ClusterMembership>> hostsPerGroup = new LinkedHashMap<Optional<ClusterSpec.Group>, Map<HostResource, ClusterMembership>>();
                for (Map.Entry<HostResource, ClusterMembership> entry : hostMapping.entrySet()) {
                    Optional group = entry.getValue().cluster().group();
                    Map hostsInGroup = hostsPerGroup.computeIfAbsent(group, k -> new LinkedHashMap());
                    hostsInGroup.put(entry.getKey(), entry.getValue());
                }
                return hostsPerGroup;
            }
        }

        private record XmlNodeBuilder(ModelElement clusterElement, ModelElement element) {
            public StorageNode build(DeployState deployState, ContentCluster parent, StorageGroup storageGroup) {
                StorageNode sNode = (StorageNode)new DomStorageNodeBuilder().build(deployState, parent.getStorageCluster(), this.element.getXml());
                parent.getSearch().addSearchNode(deployState, sNode, storageGroup, this.element);
                PersistenceEngine provider = parent.getPersistence().create(sNode);
                new Distributor.Builder(this.clusterElement, provider).build(deployState, parent.getDistributorNodes(), this.element.getXml());
                return sNode;
            }
        }
    }
}

