/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.builder.xml.dom.chains.search;

import com.yahoo.component.ComponentId;
import com.yahoo.component.ComponentSpecification;
import com.yahoo.config.model.builder.xml.XmlHelper;
import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.config.model.producer.AnyConfigProducer;
import com.yahoo.config.model.producer.TreeConfigProducer;
import com.yahoo.search.searchchain.model.federation.FederationOptions;
import com.yahoo.search.searchchain.model.federation.FederationSearcherModel;
import com.yahoo.text.XML;
import com.yahoo.vespa.model.builder.xml.dom.DomComponentBuilder;
import com.yahoo.vespa.model.builder.xml.dom.VespaDomBuilder;
import com.yahoo.vespa.model.builder.xml.dom.chains.GenericChainedComponentModelBuilder;
import com.yahoo.vespa.model.builder.xml.dom.chains.search.FederationOptionsBuilder;
import com.yahoo.vespa.model.container.component.Component;
import com.yahoo.vespa.model.container.search.searchchain.FederationSearcher;
import com.yahoo.vespa.model.container.search.searchchain.Searcher;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.w3c.dom.Element;

public class DomFederationSearcherBuilder
extends VespaDomBuilder.DomConfigProducerBuilderBase<Searcher<?>> {
    @Override
    protected FederationSearcher doBuild(DeployState deployState, TreeConfigProducer<AnyConfigProducer> ancestor, Element searcherElement) {
        FederationSearcherModel model = new FederationSearcherModelBuilder(searcherElement).build();
        Optional<Component> targetSelector = this.buildTargetSelector(deployState, ancestor, searcherElement, model.getComponentId());
        return new FederationSearcher(model, targetSelector);
    }

    private Optional<Component> buildTargetSelector(DeployState deployState, TreeConfigProducer<AnyConfigProducer> ancestor, Element searcherElement, ComponentId namespace) {
        Element targetSelectorElement = XML.getChild((Element)searcherElement, (String)"target-selector");
        if (targetSelectorElement == null) {
            return Optional.empty();
        }
        return Optional.of((Component)new DomComponentBuilder(namespace).build(deployState, ancestor, targetSelectorElement));
    }

    static class FederationSearcherModelBuilder
    extends GenericChainedComponentModelBuilder {
        private final List<FederationSearcherModel.TargetSpec> sources;
        private final boolean inheritDefaultSources;

        FederationSearcherModelBuilder(Element searcherSpec) {
            super(searcherSpec);
            this.sources = this.readSources(searcherSpec);
            this.inheritDefaultSources = this.readSourceSet(searcherSpec);
        }

        private boolean readSourceSet(Element searcherSpec) {
            return XML.getChild((Element)searcherSpec, (String)"source-set") != null;
        }

        private List<FederationSearcherModel.TargetSpec> readSources(Element searcherSpec) {
            ArrayList<FederationSearcherModel.TargetSpec> sources = new ArrayList<FederationSearcherModel.TargetSpec>();
            for (Element source : XML.getChildren((Element)searcherSpec, (String)"source")) {
                sources.add(this.readSource(source));
            }
            return sources;
        }

        private FederationSearcherModel.TargetSpec readSource(Element source) {
            ComponentSpecification componentSpecification = XmlHelper.getIdRef(source);
            FederationOptions federationOptions = this.readFederationOptions(XML.getChild((Element)source, (String)"federationoptions"));
            return new FederationSearcherModel.TargetSpec(componentSpecification, federationOptions);
        }

        private FederationOptions readFederationOptions(Element federationOptionsElement) {
            if (federationOptionsElement == null) {
                return new FederationOptions();
            }
            return new FederationOptionsBuilder(federationOptionsElement).build();
        }

        protected FederationSearcherModel build() {
            return new FederationSearcherModel(this.componentId, this.dependencies, this.sources, this.inheritDefaultSources);
        }
    }
}

