/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.search;

import com.yahoo.cloud.config.filedistribution.FiledistributorrpcConfig;
import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.config.model.producer.AnyConfigProducer;
import com.yahoo.config.model.producer.TreeConfigProducer;
import com.yahoo.config.provision.ClusterSpec;
import com.yahoo.config.provision.NodeResources;
import com.yahoo.metrics.MetricsmanagerConfig;
import com.yahoo.searchlib.TranslogserverConfig;
import com.yahoo.vespa.config.content.StorFilestorConfig;
import com.yahoo.vespa.config.content.core.StorCommunicationmanagerConfig;
import com.yahoo.vespa.config.content.core.StorServerConfig;
import com.yahoo.vespa.config.content.core.StorStatusConfig;
import com.yahoo.vespa.config.search.core.ProtonConfig;
import com.yahoo.vespa.defaults.Defaults;
import com.yahoo.vespa.model.AbstractService;
import com.yahoo.vespa.model.PortAllocBridge;
import com.yahoo.vespa.model.admin.monitoring.Monitoring;
import com.yahoo.vespa.model.application.validation.RestartConfigs;
import com.yahoo.vespa.model.builder.xml.dom.VespaDomBuilder;
import com.yahoo.vespa.model.content.ContentNode;
import com.yahoo.vespa.model.content.ResourceLimits;
import com.yahoo.vespa.model.search.NodeResourcesTuning;
import com.yahoo.vespa.model.search.NodeSpec;
import com.yahoo.vespa.model.search.SearchInterface;
import com.yahoo.vespa.model.search.Tuning;
import java.util.HashMap;
import java.util.Optional;
import org.w3c.dom.Element;

@RestartConfigs(value={ProtonConfig.class, MetricsmanagerConfig.class, TranslogserverConfig.class, StorFilestorConfig.class, StorCommunicationmanagerConfig.class, StorStatusConfig.class, StorServerConfig.class})
public class SearchNode
extends AbstractService
implements SearchInterface,
ProtonConfig.Producer,
FiledistributorrpcConfig.Producer,
MetricsmanagerConfig.Producer,
TranslogserverConfig.Producer {
    private static final int RPC_PORT = 0;
    private static final int UNUSED_1 = 1;
    private static final int UNUSED_2 = 2;
    private static final int UNUSED_3 = 3;
    private static final int HEALTH_PORT = 4;
    private static final int TLS_PORT = 5;
    private final boolean isHostedVespa;
    private final boolean flushOnShutdown;
    private final NodeSpec nodeSpec;
    private final int distributionKey;
    private final String clusterName;
    private final AbstractService serviceLayerService;
    private final Tuning tuning;
    private final Boolean syncTransactionLog;
    private ResourceLimits resourceLimits;

    public static SearchNode create(TreeConfigProducer<?> parent, String name, int distributionKey, NodeSpec nodeSpec, String clusterName, AbstractService serviceLayerService, boolean flushOnShutdown, Tuning tuning, boolean isHostedVespa, Boolean syncTransactionLog, String mallocImpl) {
        return new SearchNode(parent, name, distributionKey, nodeSpec, clusterName, serviceLayerService, flushOnShutdown, tuning, isHostedVespa, syncTransactionLog, mallocImpl);
    }

    private SearchNode(TreeConfigProducer<?> parent, String name, int distributionKey, NodeSpec nodeSpec, String clusterName, AbstractService serviceLayerService, boolean flushOnShutdown, Tuning tuning, boolean isHostedVespa, Boolean syncTransactionLog, String mallocImpl) {
        super(parent, name);
        this.distributionKey = distributionKey;
        this.serviceLayerService = serviceLayerService;
        this.isHostedVespa = isHostedVespa;
        this.nodeSpec = nodeSpec;
        this.clusterName = clusterName;
        this.flushOnShutdown = flushOnShutdown;
        this.portsMeta.on(0).tag("rpc").tag("rtc").tag("admin").tag("status");
        this.portsMeta.on(1).tag("unused");
        this.portsMeta.on(2).tag("unused");
        this.portsMeta.on(3).tag("unused");
        this.portsMeta.on(4).tag("http").tag("json").tag("health").tag("state");
        this.portsMeta.on(5).tag("tls");
        this.tuning = tuning;
        this.syncTransactionLog = syncTransactionLog;
        this.setPropertiesElastic(clusterName, distributionKey);
        this.addEnvironmentVariable("OMP_NUM_THREADS", 1);
        this.setMallocImpl(mallocImpl);
    }

    private void setPropertiesElastic(String clusterName, int distributionKey) {
        this.setProp("index", distributionKey).setProp("clustertype", "search").setProp("clustername", clusterName);
    }

    public String getClusterName() {
        return this.clusterName;
    }

    private String getClusterConfigId() {
        return this.getParent().getConfigId();
    }

    private String getBaseDir() {
        return Defaults.getDefaults().underVespaHome("var/db/vespa/search/cluster." + this.getClusterName()) + "/n" + this.distributionKey;
    }

    @Override
    public NodeSpec getNodeSpec() {
        return this.nodeSpec;
    }

    @Override
    public void allocatePorts(int start, PortAllocBridge from) {
        from.allocatePort("rpc");
        from.allocatePort("unused/1");
        from.allocatePort("unused/2");
        from.allocatePort("unused/3");
        from.allocatePort("health");
        from.allocatePort("tls");
    }

    @Override
    public int getPortCount() {
        return 6;
    }

    public int getRpcPort() {
        return this.getRelativePort(0);
    }

    @Override
    public int getHealthPort() {
        return this.getHttpPort();
    }

    int getTlsPort() {
        return this.getRelativePort(5);
    }

    @Override
    public String getServiceType() {
        return "searchnode";
    }

    public int getDistributionKey() {
        return this.distributionKey;
    }

    private int getHttpPort() {
        return this.getRelativePort(4);
    }

    public void getConfig(TranslogserverConfig.Builder builder) {
        Optional<NodeResources> nodeResources = this.getSpecifiedNodeResources();
        if (nodeResources.isPresent() && nodeResources.get().storageType() == NodeResources.StorageType.remote) {
            builder.usefsync(false);
        }
        builder.listenport(this.getTlsPort()).basedir(this.getTlsDir());
        if (this.syncTransactionLog != null) {
            builder.usefsync(this.syncTransactionLog.booleanValue());
        }
    }

    @Override
    public String toString() {
        return this.getHostName();
    }

    public AbstractService getServiceLayerService() {
        return this.serviceLayerService;
    }

    @Override
    public Optional<String> getStartupCommand() {
        String startup = "exec $ROOT/sbin/vespa-proton --identity " + this.getConfigId();
        if (this.serviceLayerService != null) {
            startup = startup + " --serviceidentity " + this.serviceLayerService.getConfigId();
        }
        return Optional.of(startup);
    }

    public void getConfig(FiledistributorrpcConfig.Builder builder) {
        builder.connectionspec("tcp/" + this.getHostName() + ":19090");
    }

    public void getConfig(ProtonConfig.Builder builder) {
        Optional<NodeResources> nodeResources;
        builder.rpcport(this.getRpcPort()).httpport(this.getHttpPort()).clustername(this.getClusterName()).basedir(this.getBaseDir()).tlsspec("tcp/" + this.getHost().getHostname() + ":" + this.getTlsPort()).tlsconfigid(this.getConfigId()).slobrokconfigid(this.getClusterConfigId()).routingconfigid(this.getClusterConfigId()).distributionkey(this.getDistributionKey());
        if (this.isHostedVespa) {
            builder.pruneremoveddocumentsage(349260.0);
        }
        if ((nodeResources = this.getSpecifiedNodeResources()).isPresent()) {
            int threadsPerSearch = this.tuning != null ? this.tuning.threadsPerSearch() : 1;
            NodeResourcesTuning nodeResourcesTuning = new NodeResourcesTuning(nodeResources.get(), threadsPerSearch);
            nodeResourcesTuning.getConfig(builder);
            if (this.tuning != null) {
                this.tuning.getConfig(builder);
            }
            if (this.resourceLimits != null) {
                this.resourceLimits.getConfig(builder);
            }
        }
    }

    private Optional<NodeResources> getSpecifiedNodeResources() {
        return this.getHostResource() != null ? this.getHostResource().realResources().asOptional() : Optional.empty();
    }

    @Override
    public HashMap<String, String> getDefaultMetricDimensions() {
        HashMap<String, String> dimensions = new HashMap<String, String>();
        if (this.clusterName != null) {
            dimensions.put("clustername", this.clusterName);
        }
        return dimensions;
    }

    public void getConfig(MetricsmanagerConfig.Builder builder) {
        Monitoring point = this.getMonitoringService();
        if (point != null) {
            builder.snapshot(new MetricsmanagerConfig.Snapshot.Builder().periods(point.getIntervalSeconds()).periods(Integer.valueOf(300)));
        }
        builder.consumer(new MetricsmanagerConfig.Consumer.Builder().name("log").tags("logdefault"));
    }

    private String getTlsDir() {
        return "tls";
    }

    @Override
    public Optional<String> getPreShutdownCommand() {
        if (this.flushOnShutdown) {
            int port = this.getRpcPort();
            String cmd = Defaults.getDefaults().underVespaHome("bin/vespa-proton-cmd ") + port + " prepareRestart";
            return Optional.of(cmd);
        }
        return Optional.empty();
    }

    public void setResourceLimits(ResourceLimits resourceLimits) {
        this.resourceLimits = resourceLimits;
    }

    public static class Builder
    extends VespaDomBuilder.DomConfigProducerBuilderBase<SearchNode> {
        private final String name;
        private final NodeSpec nodeSpec;
        private final String clusterName;
        private final ContentNode contentNode;
        private final boolean flushOnShutdown;
        private final Tuning tuning;
        private final Boolean syncTransactionLog;

        public Builder(String name, NodeSpec nodeSpec, String clusterName, ContentNode node, boolean flushOnShutdown, Tuning tuning, Boolean syncTransactionLog) {
            this.name = name;
            this.nodeSpec = nodeSpec;
            this.clusterName = clusterName;
            this.contentNode = node;
            this.flushOnShutdown = flushOnShutdown;
            this.tuning = tuning;
            this.syncTransactionLog = syncTransactionLog;
        }

        @Override
        protected SearchNode doBuild(DeployState deployState, TreeConfigProducer<AnyConfigProducer> ancestor, Element producerSpec) {
            return SearchNode.create(ancestor, this.name, this.contentNode.getDistributionKey(), this.nodeSpec, this.clusterName, this.contentNode, this.flushOnShutdown, this.tuning, deployState.isHosted(), this.syncTransactionLog, deployState.getProperties().mallocImpl(Optional.of(ClusterSpec.Type.content)));
        }
    }
}

