/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model;

import com.yahoo.vespa.model.HostPorts;
import com.yahoo.vespa.model.NetworkPortRequestor;
import java.util.ArrayList;
import java.util.List;

public class PortAllocBridge {
    private final HostPorts host;
    private final NetworkPortRequestor service;
    private final List<Integer> ports = new ArrayList<Integer>();

    public PortAllocBridge(HostPorts host, NetworkPortRequestor service) {
        this.host = host;
        this.service = service;
    }

    public int requirePort(int port, String suffix) {
        int got = this.host.requireNetworkPort(port, this.service, suffix);
        this.ports.add(got);
        return got;
    }

    public int wantPort(int port, String suffix) {
        int got = this.host.wantNetworkPort(port, this.service, suffix);
        this.ports.add(got);
        return got;
    }

    public int allocatePort(String suffix) {
        int got = this.host.allocateNetworkPort(this.service, suffix);
        this.ports.add(got);
        return got;
    }

    public List<Integer> result() {
        return this.ports;
    }
}

