/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.application.validation;

import com.yahoo.config.provision.CloudName;
import com.yahoo.vespa.model.application.validation.Validation;
import com.yahoo.vespa.model.application.validation.Validator;
import com.yahoo.vespa.model.container.http.AccessControl;
import com.yahoo.vespa.model.container.http.Http;
import java.util.Set;
import java.util.logging.Level;

public class AccessControlFilterExcludeValidator
implements Validator {
    @Override
    public void validate(Validation.Context context) {
        if (!context.deployState().isHosted() || context.deployState().zone().system().isPublicCloudLike()) {
            return;
        }
        if (context.deployState().getProperties().allowDisableMtls()) {
            return;
        }
        context.model().getContainerClusters().forEach((id, cluster) -> {
            Http http = cluster.getHttp();
            if (http != null && http.getAccessControl().isPresent()) {
                this.verifyNoExclusions((String)id, http.getAccessControl().get(), context);
            }
        });
    }

    private void verifyNoExclusions(String clusterId, AccessControl accessControl, Validation.Context context) {
        if (!accessControl.excludedBindings().isEmpty()) {
            String message = "Application cluster %s excludes paths from access control, this is not allowed and should be removed.".formatted(clusterId);
            if (Set.of(CloudName.DEFAULT, CloudName.YAHOO).contains(context.deployState().zone().cloud().name())) {
                context.deployState().getDeployLogger().log(Level.WARNING, message);
            } else {
                context.illegal(message);
            }
        }
    }
}

