/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.container;

import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.container.bundle.BundleInstantiationSpecification;
import com.yahoo.container.handler.threadpool.ContainerThreadpoolConfig;
import com.yahoo.container.handler.threadpool.ContainerThreadpoolImpl;
import com.yahoo.osgi.provider.model.ComponentModel;
import com.yahoo.vespa.model.container.component.SimpleComponent;
import com.yahoo.vespa.model.container.xml.ContainerThreadpoolOptionsBuilder;
import org.w3c.dom.Element;

public abstract class ContainerThreadpool
extends SimpleComponent
implements ContainerThreadpoolConfig.Producer {
    private final String name;
    private final UserOptions options;

    protected ContainerThreadpool(DeployState ds, String name, Element parent) {
        super(new ComponentModel(BundleInstantiationSpecification.fromStrings((String)("threadpool@" + name), (String)ContainerThreadpoolImpl.class.getName(), null)));
        this.name = name;
        this.options = ContainerThreadpoolOptionsBuilder.build(ds, parent);
    }

    protected abstract void setDefaultConfigValues(ContainerThreadpoolConfig.Builder var1);

    public void getConfig(ContainerThreadpoolConfig.Builder builder) {
        this.setDefaultConfigValues(builder);
        builder.name(this.name);
        if (this.options.max() != null) {
            if (this.options.isRelative()) {
                builder.relativeMaxThreads(this.options.max().doubleValue());
                builder.maxThreads(-1);
            } else {
                builder.maxThreads(this.options.max().intValue());
                builder.relativeMaxThreads(-1.0);
            }
        }
        if (this.options.min() != null) {
            if (this.options.isRelative()) {
                builder.relativeMinThreads(this.options.min().doubleValue());
                builder.minThreads(-1);
            } else {
                builder.minThreads(this.options.min().intValue());
                builder.relativeMinThreads(-1.0);
            }
        }
        if (this.options.queueSize() != null) {
            if (this.options.isRelative()) {
                builder.relativeQueueSize(this.options.queueSize().doubleValue());
                builder.queueSize(-1);
            } else {
                builder.queueSize(this.options.queueSize().intValue());
                builder.relativeQueueSize(-1.0);
            }
        }
    }

    public record UserOptions(Double max, Double min, Double queueSize, boolean isRelative) {
    }
}

