/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.container;

import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.container.bundle.BundleInstantiationSpecification;
import com.yahoo.container.handler.ThreadPoolProvider;
import com.yahoo.container.handler.ThreadpoolConfig;
import com.yahoo.osgi.provider.model.ComponentModel;
import com.yahoo.vespa.model.container.ApplicationContainerCluster;
import com.yahoo.vespa.model.container.ContainerCluster;
import com.yahoo.vespa.model.container.ContainerThreadpool;
import com.yahoo.vespa.model.container.component.SimpleComponent;
import java.util.logging.Level;

public class DefaultThreadpoolProvider
extends SimpleComponent
implements ThreadpoolConfig.Producer {
    private final ContainerCluster<?> cluster;
    private final ContainerThreadpool.UserOptions userOptions;

    public DefaultThreadpoolProvider(ContainerCluster<?> cluster) {
        this(null, cluster, null);
    }

    public DefaultThreadpoolProvider(DeployState ds, ContainerCluster<?> cluster, ContainerThreadpool.UserOptions userOptions) {
        super(new ComponentModel(BundleInstantiationSpecification.fromStrings((String)"default-threadpool", (String)ThreadPoolProvider.class.getName(), null)));
        this.cluster = cluster;
        this.userOptions = userOptions;
        if (this.userOptions != null) {
            this.warnOnTruncation(ds, userOptions);
        }
    }

    public void getConfig(ThreadpoolConfig.Builder builder) {
        int queueSize;
        int minThreads;
        int maxThreads;
        if (this.cluster instanceof ApplicationContainerCluster) {
            maxThreads = -100;
            minThreads = -2;
            queueSize = 0;
        } else {
            maxThreads = 4;
            minThreads = 4;
            queueSize = 50;
        }
        if (this.userOptions != null) {
            boolean neg = this.userOptions.isRelative();
            if (this.userOptions.max() != null) {
                maxThreads = (int)Math.round(neg ? -this.userOptions.max().doubleValue() : this.userOptions.max());
            }
            if (this.userOptions.min() != null) {
                minThreads = (int)Math.round(neg ? -this.userOptions.min().doubleValue() : this.userOptions.min());
            }
            if (this.userOptions.queueSize() != null) {
                queueSize = (int)Math.round(neg ? -this.userOptions.queueSize().doubleValue() : this.userOptions.queueSize());
            }
        }
        builder.corePoolSize(minThreads).maxthreads(maxThreads).queueSize(queueSize);
    }

    private void warnOnTruncation(DeployState ds, ContainerThreadpool.UserOptions userOptions) {
        if (userOptions.max() != null) {
            this.checkTruncation(ds, userOptions.max(), "max");
        }
        if (userOptions.min() != null) {
            this.checkTruncation(ds, userOptions.min(), "threads");
        }
        if (userOptions.queueSize() != null) {
            this.checkTruncation(ds, userOptions.queueSize(), "queue");
        }
    }

    private void checkTruncation(DeployState ds, Double value, String part) {
        double truncated = Math.round(value);
        if (truncated != value) {
            ds.getDeployLogger().logApplicationPackage(Level.WARNING, "For <threadpool> in <container>: the value " + part + "=" + value + " will be truncated to " + truncated + ". This behavior will be removed in Vespa 9.");
        }
    }
}

