/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.container.docproc;

import com.yahoo.collections.Pair;
import com.yahoo.config.docproc.DocprocConfig;
import com.yahoo.config.docproc.SchemamappingConfig;
import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.container.handler.threadpool.ContainerThreadpoolConfig;
import com.yahoo.container.jdisc.ContainerMbusConfig;
import com.yahoo.container.jdisc.config.SessionConfig;
import com.yahoo.vespa.model.container.ContainerCluster;
import com.yahoo.vespa.model.container.ContainerThreadpool;
import com.yahoo.vespa.model.container.component.ContainerSubsystem;
import com.yahoo.vespa.model.container.component.SystemBindingPattern;
import com.yahoo.vespa.model.container.docproc.DocprocChain;
import com.yahoo.vespa.model.container.docproc.DocprocChains;
import com.yahoo.vespa.model.container.docproc.DocumentProcessor;
import com.yahoo.vespa.model.container.docproc.MbusClient;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Element;

public class ContainerDocproc
extends ContainerSubsystem<DocprocChains>
implements ContainerMbusConfig.Producer,
SchemamappingConfig.Producer,
DocprocConfig.Producer {
    public final Options options;
    private final Map<Pair<String, String>, String> fieldNameSchemaMap = new HashMap<Pair<String, String>, String>();
    private final boolean useSimpleAnnotations;

    public ContainerDocproc(ContainerCluster<?> cluster, DocprocChains chains) {
        this(cluster, chains, Options.empty(), null);
    }

    public ContainerDocproc(ContainerCluster<?> cluster, DocprocChains chains, DeployState deployState) {
        this(cluster, chains, Options.empty(), deployState, true);
    }

    private ContainerDocproc(ContainerCluster<?> cluster, DocprocChains chains, Options options, DeployState deployState) {
        this(cluster, chains, options, deployState, true);
    }

    private void addSource(ContainerCluster<?> cluster, String name, SessionConfig.Type.Enum type) {
        MbusClient mbusClient = new MbusClient(name, type);
        mbusClient.addClientBindings(SystemBindingPattern.fromPattern("mbus://*/" + mbusClient.getSessionName()));
        cluster.addComponent(mbusClient);
    }

    public ContainerDocproc(ContainerCluster<?> cluster, DocprocChains chains, Options options, DeployState deployState, boolean addSourceClientProvider) {
        super(chains);
        assert (options != null) : "Null Options for " + String.valueOf(this) + " under cluster " + cluster.getName();
        this.options = options;
        boolean bl = this.useSimpleAnnotations = deployState != null && deployState.featureFlags().useSimpleAnnotations();
        if (addSourceClientProvider) {
            this.addSource(cluster, "source", SessionConfig.Type.SOURCE);
            this.addSource(cluster, "internalNoThrottledSource", SessionConfig.Type.INTERNAL);
        }
        cluster.addSearchAndDocprocBundles();
    }

    public void getConfig(ContainerMbusConfig.Builder builder) {
        builder.maxpendingcount(this.getMaxMessagesInQueue());
    }

    private int getMaxMessagesInQueue() {
        if (this.options.maxMessagesInQueue != null) {
            return this.options.maxMessagesInQueue;
        }
        return 2048 * ((DocprocChains)this.getChains()).allChains().allComponents().size();
    }

    private Integer getMaxQueueTimeMs() {
        return this.options.maxQueueTimeMs;
    }

    public void getConfig(DocprocConfig.Builder builder) {
        if (this.getMaxQueueTimeMs() != null) {
            builder.maxqueuetimems(this.getMaxQueueTimeMs().intValue());
        }
        builder.simpleAnnotations(this.useSimpleAnnotations);
    }

    public void getConfig(SchemamappingConfig.Builder builder) {
        HashMap<Pair<String, String>, String> allMappings = new HashMap<Pair<String, String>, String>();
        for (DocprocChain chain : ((DocprocChains)this.getChains()).allChains().allComponents()) {
            for (DocumentProcessor processor : chain.getInnerComponents()) {
                allMappings.putAll(this.fieldNameSchemaMap());
                allMappings.putAll(chain.fieldNameSchemaMap());
                allMappings.putAll(processor.fieldNameSchemaMap());
                for (Map.Entry e : allMappings.entrySet()) {
                    String doctype = (String)((Pair)e.getKey()).getFirst();
                    String from = (String)((Pair)e.getKey()).getSecond();
                    String to = (String)e.getValue();
                    builder.fieldmapping(new SchemamappingConfig.Fieldmapping.Builder().chain(chain.getId().stringValue()).docproc(processor.getGlobalComponentId().stringValue()).indocument(from).inprocessor(to).doctype(doctype != null ? doctype : ""));
                }
                allMappings.clear();
            }
        }
    }

    public Map<Pair<String, String>, String> fieldNameSchemaMap() {
        return this.fieldNameSchemaMap;
    }

    public static class Options {
        public final Element threadpoolXml;
        public final Integer maxMessagesInQueue;
        public final Integer maxQueueTimeMs;
        public final Double maxConcurrentFactor;
        public final Double documentExpansionFactor;
        public final Integer containerCoreMemory;

        public Options(Integer maxMessagesInQueue, Integer maxQueueTimeMs, Double maxConcurrentFactor, Double documentExpansionFactor, Integer containerCoreMemory, Element threadpoolXml) {
            this.threadpoolXml = threadpoolXml;
            this.maxMessagesInQueue = maxMessagesInQueue;
            this.maxQueueTimeMs = maxQueueTimeMs;
            this.maxConcurrentFactor = maxConcurrentFactor;
            this.documentExpansionFactor = documentExpansionFactor;
            this.containerCoreMemory = containerCoreMemory;
        }

        static Options empty() {
            return new Options(null, null, null, null, null, null);
        }
    }

    public static class Threadpool
    extends ContainerThreadpool {
        private final double threads;

        public Threadpool(DeployState ds, Element options) {
            super(ds, "docproc-handler", options);
            this.threads = ds.featureFlags().docprocHandlerThreadpool();
        }

        @Override
        public void setDefaultConfigValues(ContainerThreadpoolConfig.Builder builder) {
            builder.maxThreadExecutionTimeSeconds(190).keepAliveTime(5.0).relativeMaxThreads(this.threads).relativeMinThreads(this.threads).queueSize(Integer.MAX_VALUE);
        }
    }
}

