/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.container.search;

import com.yahoo.config.application.api.ApplicationPackage;
import com.yahoo.io.IOUtils;
import com.yahoo.io.reader.NamedReader;
import com.yahoo.language.Linguistics;
import com.yahoo.language.simple.SimpleLinguistics;
import com.yahoo.prelude.semantics.RuleImporter;
import com.yahoo.prelude.semantics.SemanticRulesConfig;
import com.yahoo.prelude.semantics.parser.ParseException;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SemanticRules
implements Serializable,
SemanticRulesConfig.Producer {
    private final List<RuleBase> ruleBases;

    public SemanticRules(List<RuleBase> ruleBases) {
        this.ruleBases = ruleBases;
    }

    public void getConfig(SemanticRulesConfig.Builder builder) {
        for (RuleBase ruleBase : this.ruleBases) {
            builder.rulebase(ruleBase.getConfig());
        }
    }

    public static class RuleBase {
        private final String name;
        private final boolean isDefault;
        private final String rules;

        public RuleBase(String name, boolean isDefault, String rules) {
            this.name = name;
            this.isDefault = isDefault;
            this.rules = rules;
        }

        private SemanticRulesConfig.Rulebase.Builder getConfig() {
            SemanticRulesConfig.Rulebase.Builder ruleBaseBuilder = new SemanticRulesConfig.Rulebase.Builder();
            ruleBaseBuilder.name(this.name);
            ruleBaseBuilder.isdefault(this.isDefault);
            ruleBaseBuilder.rules(this.rules);
            return ruleBaseBuilder;
        }
    }

    public static class SemanticRuleBuilder {
        public SemanticRules build(ApplicationPackage applicationPackage) {
            List ruleFiles = applicationPackage.getFiles(ApplicationPackage.RULES_DIR, "sr");
            SemanticRules rules = new SemanticRules(ruleFiles.stream().map(this::toRuleBaseConfigView).toList());
            SemanticRulesConfig.Builder builder = new SemanticRulesConfig.Builder();
            rules.getConfig(builder);
            SemanticRulesConfig config = builder.build();
            try {
                SemanticRuleBuilder.toMap(config);
                this.ensureZeroOrOneDefaultRule(config);
            }
            catch (ParseException e) {
                throw new IllegalArgumentException(e);
            }
            return rules;
        }

        private RuleBase toRuleBaseConfigView(NamedReader reader) {
            try {
                String ruleBaseString = IOUtils.readAll((Reader)reader.getReader());
                boolean isDefault = ruleBaseString.contains("@default");
                return new RuleBase(this.toName(reader.getName()), isDefault, ruleBaseString);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Could not load rules bases", e);
            }
        }

        private String toName(String fileName) {
            String shortName = new File(fileName).getName();
            return shortName.substring(0, shortName.length() - ".sr".length());
        }

        private void ensureZeroOrOneDefaultRule(SemanticRulesConfig config) {
            String defaultName = null;
            for (SemanticRulesConfig.Rulebase ruleBase : config.rulebase()) {
                if (defaultName != null && ruleBase.isdefault()) {
                    ArrayList<String> defaultRules = new ArrayList<String>(List.of(defaultName, ruleBase.name()));
                    defaultRules.sort(String::compareTo);
                    throw new IllegalArgumentException("Rules " + String.valueOf(defaultRules) + " are both marked as the default rule, there can only be one");
                }
                if (!ruleBase.isdefault()) continue;
                defaultName = ruleBase.name();
            }
        }

        static Map<String, com.yahoo.prelude.semantics.RuleBase> toMap(SemanticRulesConfig config) throws ParseException {
            RuleImporter ruleImporter = new RuleImporter(config, true, (Linguistics)new SimpleLinguistics());
            HashMap<String, com.yahoo.prelude.semantics.RuleBase> ruleBaseMap = new HashMap<String, com.yahoo.prelude.semantics.RuleBase>();
            for (SemanticRulesConfig.Rulebase ruleBaseConfig : config.rulebase()) {
                com.yahoo.prelude.semantics.RuleBase ruleBase = ruleImporter.importConfig(ruleBaseConfig);
                if (ruleBaseConfig.isdefault()) {
                    ruleBase.setDefault(true);
                }
                ruleBaseMap.put(ruleBase.getName(), ruleBase);
            }
            return ruleBaseMap;
        }
    }
}

