/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.content;

import com.yahoo.config.model.api.ModelContext;
import com.yahoo.config.provision.ClusterSpec;
import com.yahoo.vespa.config.content.core.StorDistributormanagerConfig;
import com.yahoo.vespa.config.content.core.StorServerConfig;
import com.yahoo.vespa.model.content.ContentNode;
import com.yahoo.vespa.model.content.DistributorCluster;
import com.yahoo.vespa.model.content.StorageNode;
import com.yahoo.vespa.model.content.engines.PersistenceEngine;
import java.util.Optional;

public class Distributor
extends ContentNode
implements StorDistributormanagerConfig.Producer {
    PersistenceEngine provider;

    public Distributor(ModelContext.Properties properties, DistributorCluster parent, int distributionKey, PersistenceEngine provider) {
        super(properties.featureFlags(), parent, parent.getClusterName(), StorageNode.rootFolder + parent.getClusterName() + "/distributor/" + distributionKey, distributionKey);
        this.provider = provider;
        this.setMallocImpl(properties.mallocImpl(Optional.of(ClusterSpec.Type.content)));
    }

    private int tuneNumDistributorStripes() {
        if (this.getHostResource() != null && !this.getHostResource().realResources().isUnspecified()) {
            int cores = (int)this.getHostResource().realResources().vcpu();
            if (cores <= 16) {
                return 1;
            }
            if (cores <= 64) {
                return 2;
            }
            return 4;
        }
        return 0;
    }

    @Override
    public void getConfig(StorServerConfig.Builder builder) {
        super.getConfig(builder);
        this.provider.getConfig(builder);
    }

    public void getConfig(StorDistributormanagerConfig.Builder builder) {
        builder.num_distributor_stripes(this.tuneNumDistributorStripes());
    }

    @Override
    public Optional<String> getStartupCommand() {
        return Optional.of("exec sbin/vespa-distributord -c $VESPA_CONFIG_ID");
    }
}

