/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.provision;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum SystemName {
    cd,
    main,
    Public,
    PublicCd,
    dev,
    kubernetes,
    kubernetesCd,
    Default;


    public static SystemName defaultSystem() {
        return Default;
    }

    public static SystemName from(String value) {
        return Arrays.stream(SystemName.values()).filter(systemName -> systemName.value().equals(value)).findAny().orElseThrow(() -> new IllegalArgumentException("'%s' is not a valid system".formatted(value)));
    }

    public String value() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case dev -> "dev";
            case cd -> "cd";
            case main -> "main";
            case Public -> "public";
            case PublicCd -> "publiccd";
            case kubernetes -> "kubernetes";
            case kubernetesCd -> "kubernetescd";
            case Default -> "default";
        };
    }

    public boolean isPublicCloudLike() {
        return this == Public || this == PublicCd;
    }

    public boolean isYahooLike() {
        return this == main || this == cd;
    }

    public boolean isKubernetesLike() {
        return this == kubernetes || this == kubernetesCd;
    }

    public boolean isCdLike() {
        return this == cd || this == PublicCd || this == kubernetesCd;
    }

    public boolean isProductionLike() {
        return this == main || this == Public || this == kubernetes;
    }

    public static Set<SystemName> all() {
        return EnumSet.allOf(SystemName.class);
    }

    public static Set<SystemName> allOf(Predicate<SystemName> predicate) {
        return Stream.of(SystemName.values()).filter(predicate).collect(Collectors.toUnmodifiableSet());
    }

    public static Set<SystemName> hostedVespa() {
        return EnumSet.of(main, cd, Public, PublicCd);
    }
}

