/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.provision;

import com.yahoo.cloud.config.ApplicationIdConfig;
import com.yahoo.config.provision.ApplicationName;
import com.yahoo.config.provision.InstanceName;
import com.yahoo.config.provision.TenantName;
import java.util.Comparator;
import java.util.Objects;
import java.util.regex.Pattern;

public class ApplicationId
implements Comparable<ApplicationId> {
    private static final ApplicationId global = new ApplicationId(TenantName.from("hosted-vespa"), ApplicationName.from("routing"), InstanceName.from("default")){};
    private static final Comparator<ApplicationId> comparator = Comparator.comparing(ApplicationId::tenant).thenComparing(ApplicationId::application).thenComparing(ApplicationId::instance).thenComparing(global::equals, Boolean::compare);
    private final TenantName tenant;
    private final ApplicationName application;
    private final InstanceName instance;
    private final String serializedForm;

    private ApplicationId(TenantName tenant, ApplicationName applicationName, InstanceName instanceName) {
        this.tenant = tenant;
        this.application = applicationName;
        this.instance = instanceName;
        this.serializedForm = this.toSerializedForm();
    }

    public static ApplicationId from(ApplicationIdConfig config) {
        return ApplicationId.from(TenantName.from(config.tenant()), ApplicationName.from(config.application()), InstanceName.from(config.instance()));
    }

    public static ApplicationId from(TenantName tenant, ApplicationName application, InstanceName instance) {
        return new ApplicationId(tenant, application, instance);
    }

    public static ApplicationId from(String tenant, String application, String instance) {
        return new ApplicationId(TenantName.from(tenant), ApplicationName.from(application), InstanceName.from(instance));
    }

    public static ApplicationId fromSerializedForm(String idString) {
        return ApplicationId.fromIdString(idString, ":");
    }

    public static ApplicationId fromFullString(String idString) {
        return ApplicationId.fromIdString(idString, ".");
    }

    private static ApplicationId fromIdString(String idString, String splitCharacter) {
        String[] parts = idString.split(Pattern.quote(splitCharacter));
        if (parts.length != 3) {
            throw new IllegalArgumentException("Application ids must be on the form tenant" + splitCharacter + "application" + splitCharacter + "instance, but was " + idString);
        }
        return ApplicationId.from(parts[0], parts[1], parts[2]);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.tenant, this.application, this.instance});
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ApplicationId rhs = (ApplicationId)other;
        return this.tenant.equals((Object)rhs.tenant) && this.application.equals((Object)rhs.application) && this.instance.equals((Object)rhs.instance);
    }

    public String serializedForm() {
        return this.serializedForm;
    }

    public String toShortString() {
        return this.tenant().value() + "." + this.application().value() + (String)(this.instance().isDefault() ? "" : "." + this.instance().value());
    }

    public String toFullString() {
        return this.tenant().value() + "." + this.application().value() + "." + this.instance().value();
    }

    private String toSerializedForm() {
        return this.tenant.value() + ":" + this.application.value() + ":" + this.instance.value();
    }

    public String toSerializedFormWithoutInstance() {
        return this.tenant.value() + ":" + this.application.value();
    }

    public String toString() {
        return this.toShortString();
    }

    public TenantName tenant() {
        return this.tenant;
    }

    public ApplicationName application() {
        return this.application;
    }

    public InstanceName instance() {
        return this.instance;
    }

    @Override
    public int compareTo(ApplicationId other) {
        return comparator.compare(this, other);
    }

    public static ApplicationId defaultId() {
        return new ApplicationId(TenantName.defaultName(), ApplicationName.defaultName(), InstanceName.defaultName());
    }

    public static String toSerializedForm(TenantName tenant, ApplicationName application) {
        return tenant.value() + ":" + application.value();
    }

    public static ApplicationId global() {
        return global;
    }

    public static class Builder {
        private TenantName tenant = TenantName.defaultName();
        private ApplicationName application = null;
        private InstanceName instance = InstanceName.defaultName();

        public Builder tenant(TenantName ten) {
            this.tenant = ten;
            return this;
        }

        public Builder tenant(String ten) {
            return this.tenant(TenantName.from(ten));
        }

        public Builder applicationName(ApplicationName nam) {
            this.application = nam;
            return this;
        }

        public Builder applicationName(String nam) {
            return this.applicationName(ApplicationName.from(nam));
        }

        public Builder instanceName(InstanceName ins) {
            this.instance = ins;
            return this;
        }

        public Builder instanceName(String ins) {
            return this.instanceName(InstanceName.from(ins));
        }

        public ApplicationId build() {
            if (this.application == null) {
                throw new IllegalArgumentException("must set application name in builder");
            }
            return ApplicationId.from(this.tenant, this.application, this.instance);
        }
    }
}

