/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.provision.zone;

import java.util.Objects;
import java.util.OptionalDouble;
import java.util.OptionalLong;

public record NodeSlice(OptionalDouble fraction, OptionalLong minCount) {
    public static final NodeSlice ALL = NodeSlice.minCount(Long.MAX_VALUE);

    public NodeSlice {
        Objects.requireNonNull(fraction);
        Objects.requireNonNull(minCount);
        if (fraction.isEmpty() == minCount.isEmpty()) {
            throw new IllegalArgumentException("Exactly one of 'fraction' or 'minCount' must be set");
        }
        if (fraction.isPresent() && fraction.getAsDouble() > 1.0) {
            throw new IllegalArgumentException("Fraction must be <= 1.0, got " + fraction.getAsDouble());
        }
    }

    public boolean satisfiedBy(long count, long totalCount) {
        if (this.fraction.isPresent()) {
            return (double)count + 1.0E-9 >= (double)totalCount * this.fraction.getAsDouble();
        }
        return count >= Math.min(this.minCount.orElse(0L), totalCount);
    }

    public static NodeSlice fraction(double fraction) {
        return new NodeSlice(OptionalDouble.of(fraction), OptionalLong.empty());
    }

    public static NodeSlice minCount(long count) {
        return new NodeSlice(OptionalDouble.empty(), OptionalLong.of(count));
    }
}

