/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config;

import com.yahoo.config.codegen.CNode;
import com.yahoo.config.codegen.LeafCNode;
import com.yahoo.vespa.config.ConfigDefinition;
import java.util.Arrays;

public class ConfigDefinitionBuilder {
    public static ConfigDefinition createConfigDefinition(CNode root) {
        ConfigDefinition def = new ConfigDefinition(root.getName(), root.getNamespace());
        for (CNode node : root.getChildren()) {
            ConfigDefinitionBuilder.addNode(def, node);
        }
        return def;
    }

    private static void addNode(ConfigDefinition def, CNode node) {
        block34: {
            String name;
            block36: {
                block35: {
                    block33: {
                        name = node.getName();
                        if (!(node instanceof LeafCNode)) break block33;
                        if (node.isArray) {
                            String enumValues = null;
                            String type = ((LeafCNode)node).getType();
                            if ("enum".equals(type)) {
                                enumValues = ConfigDefinitionBuilder.convertToEnumValueCommaSeparated(((LeafCNode.EnumLeaf)node).getLegalValues());
                            }
                            def.arrayDef(name).setTypeSpec(new ConfigDefinition.TypeSpec(name, ((LeafCNode)node).getType(), null, enumValues, null, null));
                        } else if (node.isMap) {
                            def.leafMapDef(name).setTypeSpec(new ConfigDefinition.TypeSpec(name, ((LeafCNode)node).getType(), null, null, null, null));
                        } else if (node instanceof LeafCNode.IntegerLeaf) {
                            ConfigDefinitionBuilder.addNode(def, (LeafCNode.IntegerLeaf)node);
                        } else if (node instanceof LeafCNode.LongLeaf) {
                            ConfigDefinitionBuilder.addNode(def, (LeafCNode.LongLeaf)node);
                        } else if (node instanceof LeafCNode.BooleanLeaf) {
                            ConfigDefinitionBuilder.addNode(def, (LeafCNode.BooleanLeaf)node);
                        } else if (node instanceof LeafCNode.DoubleLeaf) {
                            ConfigDefinitionBuilder.addNode(def, (LeafCNode.DoubleLeaf)node);
                        } else if (node instanceof LeafCNode.ReferenceLeaf) {
                            ConfigDefinitionBuilder.addNode(def, (LeafCNode.ReferenceLeaf)node);
                        } else if (node instanceof LeafCNode.FileLeaf) {
                            ConfigDefinitionBuilder.addNode(def, (LeafCNode.FileLeaf)node);
                        } else if (node instanceof LeafCNode.PathLeaf) {
                            ConfigDefinitionBuilder.addNode(def, (LeafCNode.PathLeaf)node);
                        } else if (node instanceof LeafCNode.OptionalPathLeaf) {
                            ConfigDefinitionBuilder.addNode(def, (LeafCNode.OptionalPathLeaf)node);
                        } else if (node instanceof LeafCNode.UrlLeaf) {
                            ConfigDefinitionBuilder.addNode(def, (LeafCNode.UrlLeaf)node);
                        } else if (node instanceof LeafCNode.ModelLeaf) {
                            ConfigDefinitionBuilder.addNode(def, (LeafCNode.ModelLeaf)node);
                        } else if (node instanceof LeafCNode.StringLeaf) {
                            ConfigDefinitionBuilder.addNode(def, (LeafCNode.StringLeaf)node);
                        } else if (node instanceof LeafCNode.EnumLeaf) {
                            ConfigDefinitionBuilder.addNode(def, (LeafCNode.EnumLeaf)node);
                        } else {
                            System.err.println("Unknown node type for node with name '" + name + "'");
                        }
                        break block34;
                    }
                    if (!node.isArray) break block35;
                    if (node.getChildren() == null || node.getChildren().length <= 0) break block34;
                    ConfigDefinition.InnerArrayDef newDef = def.innerArrayDef(name);
                    for (CNode childNode : node.getChildren()) {
                        ConfigDefinitionBuilder.addNode((ConfigDefinition)newDef, childNode);
                    }
                    break block34;
                }
                if (!node.isMap) break block36;
                ConfigDefinition.StructMapDef newDef = def.structMapDef(name);
                if (node.getChildren() == null || node.getChildren().length <= 0) break block34;
                for (CNode childNode : node.getChildren()) {
                    ConfigDefinitionBuilder.addNode((ConfigDefinition)newDef, childNode);
                }
                break block34;
            }
            ConfigDefinition.StructDef newDef = def.structDef(name);
            if (node.getChildren() != null && node.getChildren().length > 0) {
                for (CNode childNode : node.getChildren()) {
                    ConfigDefinitionBuilder.addNode((ConfigDefinition)newDef, childNode);
                }
            }
        }
    }

    private static void addNode(ConfigDefinition def, LeafCNode.IntegerLeaf leaf) {
        if (leaf.getDefaultValue() != null) {
            def.addIntDef(leaf.getName(), Integer.valueOf(leaf.getDefaultValue().getValue()));
        } else {
            def.addIntDef(leaf.getName());
        }
    }

    private static void addNode(ConfigDefinition def, LeafCNode.LongLeaf leaf) {
        if (leaf.getDefaultValue() != null) {
            def.addLongDef(leaf.getName(), Long.valueOf(leaf.getDefaultValue().getValue()));
        } else {
            def.addLongDef(leaf.getName());
        }
    }

    private static void addNode(ConfigDefinition def, LeafCNode.BooleanLeaf leaf) {
        if (leaf.getDefaultValue() != null) {
            def.addBoolDef(leaf.getName(), Boolean.valueOf(leaf.getDefaultValue().getValue()));
        } else {
            def.addBoolDef(leaf.getName());
        }
    }

    private static void addNode(ConfigDefinition def, LeafCNode.DoubleLeaf leaf) {
        if (leaf.getDefaultValue() != null) {
            def.addDoubleDef(leaf.getName(), Double.valueOf(leaf.getDefaultValue().getValue()));
        } else {
            def.addDoubleDef(leaf.getName());
        }
    }

    private static void addNode(ConfigDefinition def, LeafCNode.StringLeaf leaf) {
        if (leaf.getDefaultValue() != null) {
            def.addStringDef(leaf.getName(), leaf.getDefaultValue().getValue());
        } else {
            def.addStringDef(leaf.getName());
        }
    }

    private static void addNode(ConfigDefinition def, LeafCNode.ReferenceLeaf leaf) {
        if (leaf.getDefaultValue() != null) {
            def.addReferenceDef(leaf.getName(), leaf.getDefaultValue().getValue());
        } else {
            def.addReferenceDef(leaf.getName(), null);
        }
    }

    private static void addNode(ConfigDefinition def, LeafCNode.FileLeaf leaf) {
        if (leaf.getDefaultValue() != null) {
            def.addFileDef(leaf.getName(), leaf.getDefaultValue().getValue());
        } else {
            def.addFileDef(leaf.getName(), null);
        }
    }

    private static void addNode(ConfigDefinition def, LeafCNode.PathLeaf leaf) {
        if (leaf.getDefaultValue() != null) {
            def.addPathDef(leaf.getName(), leaf.getDefaultValue().getValue());
        } else {
            def.addPathDef(leaf.getName(), null);
        }
    }

    private static void addNode(ConfigDefinition def, LeafCNode.OptionalPathLeaf leaf) {
        if (leaf.getDefaultValue() != null) {
            def.addOptionalPathDef(leaf.getName(), leaf.getDefaultValue().getValue());
        } else {
            def.addOptionalPathDef(leaf.getName(), null);
        }
    }

    private static void addNode(ConfigDefinition def, LeafCNode.UrlLeaf leaf) {
        if (leaf.getDefaultValue() != null) {
            def.addUrlDef(leaf.getName(), leaf.getDefaultValue().getValue());
        } else {
            def.addUrlDef(leaf.getName(), null);
        }
    }

    private static void addNode(ConfigDefinition def, LeafCNode.ModelLeaf leaf) {
        def.addModelDef(leaf.getName());
    }

    private static void addNode(ConfigDefinition def, LeafCNode.EnumLeaf leaf) {
        if (leaf.getDefaultValue() != null) {
            def.addEnumDef(leaf.getName(), Arrays.asList(leaf.getLegalValues()), leaf.getDefaultValue().getValue());
        } else {
            def.addEnumDef(leaf.getName(), Arrays.asList(leaf.getLegalValues()), null);
        }
    }

    private static String convertToEnumValueCommaSeparated(String[] enumValues) {
        StringBuilder sb = new StringBuilder();
        for (String s : enumValues) {
            sb.append(s);
            sb.append(", ");
        }
        int length = sb.length();
        sb.delete(length - 2, length);
        return sb.toString();
    }
}

