/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.protocol;

import com.yahoo.jrt.Request;
import com.yahoo.slime.Inspector;
import com.yahoo.slime.Slime;
import com.yahoo.slime.SlimeUtils;
import com.yahoo.vespa.config.PayloadChecksum;
import com.yahoo.vespa.config.PayloadChecksums;
import com.yahoo.vespa.config.protocol.CompressionInfo;
import com.yahoo.vespa.config.protocol.Trace;

class SlimeResponseData {
    static final String RESPONSE_VERSION = "version";
    static final String RESPONSE_DEF_NAME = "defName";
    static final String RESPONSE_DEF_NAMESPACE = "defNamespace";
    static final String RESPONSE_DEF_MD5 = "defMD5";
    static final String RESPONSE_CONFIGID = "configId";
    static final String RESPONSE_CLIENT_HOSTNAME = "clientHostname";
    static final String RESPONSE_TRACE = "trace";
    static final String RESPONSE_CONFIG_MD5 = "configMD5";
    static final String RESPONSE_CONFIG_XXHASH64 = "configXxhash64";
    static final String RESPONSE_CONFIG_GENERATION = "generation";
    static final String RESPONSE_APPLY_ON_RESTART = "applyOnRestart";
    static final String RESPONSE_COMPRESSION_INFO = "compressionInfo";
    private final Request request;
    private Slime data = null;

    SlimeResponseData(Request request) {
        this.request = request;
    }

    private Slime getData() {
        if (this.request.returnValues().size() > 0) {
            if (this.data == null) {
                this.data = SlimeUtils.jsonToSlime((String)this.request.returnValues().get(0).asString());
            }
            return this.data;
        }
        return new Slime();
    }

    Inspector getResponseField(String responseTrace) {
        return this.getData().get().field(responseTrace);
    }

    long getResponseConfigGeneration() {
        Inspector inspector = this.getResponseField(RESPONSE_CONFIG_GENERATION);
        return inspector.valid() ? inspector.asLong() : -1L;
    }

    Trace getResponseTrace() {
        Inspector trace = this.getResponseField(RESPONSE_TRACE);
        return trace.valid() ? Trace.fromSlime(trace) : Trace.createDummy();
    }

    PayloadChecksum getResponseConfigMd5() {
        Inspector md5Field = this.getResponseField(RESPONSE_CONFIG_MD5);
        return md5Field.valid() ? new PayloadChecksum(md5Field.asString(), PayloadChecksum.Type.MD5) : PayloadChecksum.empty(PayloadChecksum.Type.MD5);
    }

    PayloadChecksum getResponseConfigXxhash64() {
        Inspector xxhash64Field = this.getResponseField(RESPONSE_CONFIG_XXHASH64);
        return xxhash64Field.valid() ? new PayloadChecksum(xxhash64Field.asString(), PayloadChecksum.Type.XXHASH64) : PayloadChecksum.empty(PayloadChecksum.Type.XXHASH64);
    }

    PayloadChecksums getResponseConfigChecksums() {
        return PayloadChecksums.from(this.getResponseConfigMd5(), this.getResponseConfigXxhash64());
    }

    CompressionInfo getCompressionInfo() {
        return CompressionInfo.fromSlime(this.getResponseField(RESPONSE_COMPRESSION_INFO));
    }

    boolean getResponseApplyOnRestart() {
        Inspector inspector = this.getResponseField(RESPONSE_APPLY_ON_RESTART);
        return inspector.valid() && inspector.asBool();
    }
}

