/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.protocol;

import com.yahoo.slime.Cursor;
import com.yahoo.yolean.trace.TraceNode;
import com.yahoo.yolean.trace.TraceVisitor;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;

public class SlimeTraceSerializer
extends TraceVisitor {
    static final String TIMESTAMP = "timestamp";
    static final String PAYLOAD = "payload";
    static final String CHILDREN = "children";
    final Deque<Cursor> cursors = new ArrayDeque<Cursor>();

    public SlimeTraceSerializer(Cursor cursor) {
        this.cursors.push(cursor);
    }

    public void visit(TraceNode node) {
        Cursor current = this.cursors.pop();
        current.setLong(TIMESTAMP, node.timestamp());
        this.encodePayload(current, node.payload());
        this.addChildrenCursors(current, node);
    }

    private void encodePayload(Cursor current, Object payload) {
        if (payload instanceof String) {
            current.setString(PAYLOAD, (String)payload);
        } else if (payload instanceof Long) {
            current.setLong(PAYLOAD, ((Long)payload).longValue());
        } else if (payload instanceof Boolean) {
            current.setBool(PAYLOAD, ((Boolean)payload).booleanValue());
        } else if (payload instanceof Double) {
            current.setDouble(PAYLOAD, ((Double)payload).doubleValue());
        } else if (payload instanceof byte[]) {
            current.setData(PAYLOAD, (byte[])payload);
        }
    }

    private void addChildrenCursors(Cursor current, TraceNode node) {
        Iterator it = node.children().iterator();
        if (it.hasNext()) {
            Cursor childrenArray = current.setArray(CHILDREN);
            while (it.hasNext()) {
                this.cursors.push(childrenArray.addObject());
                it.next();
            }
        }
    }
}

