/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.protocol;

import com.yahoo.vespa.config.ConfigDefinition;
import com.yahoo.vespa.config.ConfigKey;
import com.yahoo.vespa.config.PayloadChecksum;
import com.yahoo.vespa.config.protocol.JRTConfigRequest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;

public class RequestValidation {
    private static final Logger log = Logger.getLogger(RequestValidation.class.getName());

    public static int validateRequest(JRTConfigRequest request) {
        ConfigKey<?> key = request.getConfigKey();
        if (!RequestValidation.verifyName(key.getName())) {
            log.log(Level.WARNING, "Illegal name '" + key.getName() + "'");
            return 100100;
        }
        if (!RequestValidation.verifyNamespace(key.getNamespace())) {
            log.log(Level.WARNING, "Illegal name space '" + key.getNamespace() + "'");
            return 100108;
        }
        if (!new PayloadChecksum(request.getRequestDefMd5(), PayloadChecksum.Type.MD5).valid()) {
            log.log(Level.WARNING, "Illegal checksum '" + key.getNamespace() + "'");
            return 100103;
        }
        if (!request.getRequestConfigChecksums().valid()) {
            log.log(Level.WARNING, "Illegal config checksum '" + String.valueOf(request.getRequestConfigChecksums()) + "'");
            return 100104;
        }
        if (!RequestValidation.verifyGeneration(request.getRequestGeneration())) {
            log.log(Level.WARNING, "Illegal generation '" + request.getRequestGeneration() + "'");
            return 100106;
        }
        if (!RequestValidation.verifyTimeout(request.getTimeout())) {
            log.log(Level.WARNING, "Illegal timeout '" + request.getTimeout() + "'");
            return 100105;
        }
        if (!RequestValidation.verifyHostname(request.getClientHostName())) {
            log.log(Level.WARNING, "Illegal client host name '" + request.getClientHostName() + "'");
            return 100110;
        }
        return 0;
    }

    public static boolean verifyName(String name) {
        Matcher m = ConfigDefinition.namePattern.matcher(name);
        return m.matches();
    }

    public static boolean verifyTimeout(Long timeout) {
        return timeout > 0L;
    }

    private static boolean verifyGeneration(Long generation) {
        return generation >= 0L;
    }

    private static boolean verifyNamespace(String namespace) {
        Matcher m = ConfigDefinition.namespacePattern.matcher(namespace);
        return m.matches();
    }

    private static boolean verifyHostname(String clientHostName) {
        return !"".equals(clientHostName);
    }
}

