/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jdisc.http.filter.security.cloud.config;

import com.yahoo.config.BooleanNode;
import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigBuilder;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.InnerNode;
import com.yahoo.config.InnerNodeVector;
import com.yahoo.config.LeafNode;
import com.yahoo.config.LeafNodeVector;
import com.yahoo.config.StringNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;

public final class CloudDataPlaneFilterConfig
extends ConfigInstance {
    public static final String CONFIG_DEF_MD5 = "ed2e1a73db2928397d1f4c8737fecd9b";
    public static final String CONFIG_DEF_NAME = "cloud-data-plane-filter";
    public static final String CONFIG_DEF_NAMESPACE = "jdisc.http.filter.security.cloud.config";
    public static final String[] CONFIG_DEF_SCHEMA = new String[]{"namespace=jdisc.http.filter.security.cloud.config", "legacyMode bool default=false", "clients[].id string", "clients[].permissions[] string", "clients[].certificates[] string"};
    private final BooleanNode legacyMode;
    private final InnerNodeVector<Clients> clients;

    public static String getDefMd5() {
        return CONFIG_DEF_MD5;
    }

    public static String getDefName() {
        return CONFIG_DEF_NAME;
    }

    public static String getDefNamespace() {
        return CONFIG_DEF_NAMESPACE;
    }

    public CloudDataPlaneFilterConfig(Builder builder) {
        this(builder, true);
    }

    private CloudDataPlaneFilterConfig(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
            throw new IllegalArgumentException("The following builder parameters for cloud-data-plane-filter must be initialized: " + builder.__uninitialized);
        }
        this.legacyMode = builder.legacyMode == null ? new BooleanNode(false) : new BooleanNode(builder.legacyMode.booleanValue());
        this.clients = Clients.createVector(builder.clients);
    }

    public boolean legacyMode() {
        return this.legacyMode.value();
    }

    public List<Clients> clients() {
        return this.clients;
    }

    public Clients clients(int i) {
        return (Clients)((Object)this.clients.get(i));
    }

    private ChangesRequiringRestart getChangesRequiringRestart(CloudDataPlaneFilterConfig newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart(CONFIG_DEF_NAME);
        return changes;
    }

    private static boolean containsFieldsFlaggedWithRestart() {
        return false;
    }

    public static final class Builder
    implements ConfigInstance.Builder {
        private Set<String> __uninitialized = new HashSet<String>();
        private Boolean legacyMode = null;
        public List<Clients.Builder> clients = new ArrayList<Clients.Builder>();
        private boolean _applyOnRestart = false;

        public Builder() {
        }

        public Builder(CloudDataPlaneFilterConfig config) {
            this.legacyMode(config.legacyMode());
            for (Clients c : config.clients()) {
                this.clients(new Clients.Builder(c));
            }
        }

        private Builder override(Builder __superior) {
            if (__superior.legacyMode != null) {
                this.legacyMode(__superior.legacyMode);
            }
            if (!__superior.clients.isEmpty()) {
                this.clients.addAll(__superior.clients);
            }
            return this;
        }

        public Builder legacyMode(boolean __value) {
            this.legacyMode = __value;
            return this;
        }

        private Builder legacyMode(String __value) {
            return this.legacyMode(Boolean.valueOf(__value));
        }

        public Builder clients(Clients.Builder __builder) {
            this.clients.add(__builder);
            return this;
        }

        public Builder clients(Consumer<Clients.Builder> __func) {
            Clients.Builder __inner = new Clients.Builder();
            __func.accept(__inner);
            this.clients.add(__inner);
            return this;
        }

        public Builder clients(List<Clients.Builder> __builders) {
            this.clients = __builders;
            return this;
        }

        public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
            if (producer instanceof Producer) {
                ((Producer)producer).getConfig(this);
                return true;
            }
            return false;
        }

        public final String getDefMd5() {
            return CloudDataPlaneFilterConfig.CONFIG_DEF_MD5;
        }

        public final String getDefName() {
            return CloudDataPlaneFilterConfig.CONFIG_DEF_NAME;
        }

        public final String getDefNamespace() {
            return CloudDataPlaneFilterConfig.CONFIG_DEF_NAMESPACE;
        }

        public final boolean getApplyOnRestart() {
            return this._applyOnRestart;
        }

        public final void setApplyOnRestart(boolean applyOnRestart) {
            this._applyOnRestart = applyOnRestart;
        }

        public CloudDataPlaneFilterConfig build() {
            return new CloudDataPlaneFilterConfig(this);
        }
    }

    public static final class Clients
    extends InnerNode {
        private final StringNode id;
        private final LeafNodeVector<String, StringNode> permissions;
        private final LeafNodeVector<String, StringNode> certificates;

        public Clients(Builder builder) {
            this(builder, true);
        }

        private Clients(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for cloud-data-plane-filter.clients[] must be initialized: " + builder.__uninitialized);
            }
            this.id = builder.id == null ? new StringNode() : new StringNode(builder.id);
            this.permissions = new LeafNodeVector(builder.permissions, (LeafNode)new StringNode());
            this.certificates = new LeafNodeVector(builder.certificates, (LeafNode)new StringNode());
        }

        public String id() {
            return this.id.value();
        }

        public List<String> permissions() {
            return this.permissions.asList();
        }

        public String permissions(int i) {
            return ((StringNode)this.permissions.get(i)).value();
        }

        public List<String> certificates() {
            return this.certificates.asList();
        }

        public String certificates(int i) {
            return ((StringNode)this.certificates.get(i)).value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Clients newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("clients");
            return changes;
        }

        private static InnerNodeVector<Clients> createVector(List<Builder> builders) {
            ArrayList<Clients> elems = new ArrayList<Clients>();
            for (Builder b : builders) {
                elems.add(new Clients(b));
            }
            return new InnerNodeVector(elems);
        }

        public static final class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>(Arrays.asList("id"));
            private String id = null;
            public List<String> permissions = new ArrayList<String>();
            public List<String> certificates = new ArrayList<String>();

            public Builder() {
            }

            public Builder(Clients config) {
                this.id(config.id());
                this.permissions(config.permissions());
                this.certificates(config.certificates());
            }

            private Builder override(Builder __superior) {
                if (__superior.id != null) {
                    this.id(__superior.id);
                }
                if (!__superior.permissions.isEmpty()) {
                    this.permissions.addAll(__superior.permissions);
                }
                if (!__superior.certificates.isEmpty()) {
                    this.certificates.addAll(__superior.certificates);
                }
                return this;
            }

            public Builder id(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.id = __value;
                this.__uninitialized.remove("id");
                return this;
            }

            public Builder permissions(String __value) {
                this.permissions.add(__value);
                return this;
            }

            public Builder permissions(Collection<String> __values) {
                this.permissions.addAll(__values);
                return this;
            }

            public Builder certificates(String __value) {
                this.certificates.add(__value);
                return this;
            }

            public Builder certificates(Collection<String> __values) {
                this.certificates.addAll(__values);
                return this;
            }

            public Clients build() {
                return new Clients(this);
            }
        }
    }

    public static interface Producer
    extends ConfigInstance.Producer {
        public void getConfig(Builder var1);
    }
}

