/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.configdefinition;

import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigBuilder;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.DoubleNode;
import com.yahoo.config.InnerNode;
import com.yahoo.config.InnerNodeVector;
import com.yahoo.config.IntegerNode;
import com.yahoo.config.LeafNode;
import com.yahoo.config.LeafNodeVector;
import com.yahoo.config.StringNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;

public final class IlscriptsConfig
extends ConfigInstance {
    public static final String CONFIG_DEF_MD5 = "270fbf596c4b5159d4e692a552b03553";
    public static final String CONFIG_DEF_NAME = "ilscripts";
    public static final String CONFIG_DEF_NAMESPACE = "vespa.configdefinition";
    public static final String[] CONFIG_DEF_SCHEMA = new String[]{"namespace=vespa.configdefinition", "maxtermoccurrences int default=10000", "maxtokenlength int default=1000", "fieldmatchmaxlength int default=1000000", "maxReplacementCharactersRatio double default=0.3", "maxReplacementCharacters int default=10000", "ilscript[].doctype string", "ilscript[].docfield[] string", "ilscript[].content[] string"};
    private final IntegerNode maxtermoccurrences;
    private final IntegerNode maxtokenlength;
    private final IntegerNode fieldmatchmaxlength;
    private final DoubleNode maxReplacementCharactersRatio;
    private final IntegerNode maxReplacementCharacters;
    private final InnerNodeVector<Ilscript> ilscript;

    public static String getDefMd5() {
        return CONFIG_DEF_MD5;
    }

    public static String getDefName() {
        return CONFIG_DEF_NAME;
    }

    public static String getDefNamespace() {
        return CONFIG_DEF_NAMESPACE;
    }

    public IlscriptsConfig(Builder builder) {
        this(builder, true);
    }

    private IlscriptsConfig(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
            throw new IllegalArgumentException("The following builder parameters for ilscripts must be initialized: " + String.valueOf(builder.__uninitialized));
        }
        this.maxtermoccurrences = builder.maxtermoccurrences == null ? new IntegerNode(10000) : new IntegerNode(builder.maxtermoccurrences.intValue());
        this.maxtokenlength = builder.maxtokenlength == null ? new IntegerNode(1000) : new IntegerNode(builder.maxtokenlength.intValue());
        this.fieldmatchmaxlength = builder.fieldmatchmaxlength == null ? new IntegerNode(1000000) : new IntegerNode(builder.fieldmatchmaxlength.intValue());
        this.maxReplacementCharactersRatio = builder.maxReplacementCharactersRatio == null ? new DoubleNode(0.3) : new DoubleNode(builder.maxReplacementCharactersRatio.doubleValue());
        this.maxReplacementCharacters = builder.maxReplacementCharacters == null ? new IntegerNode(10000) : new IntegerNode(builder.maxReplacementCharacters.intValue());
        this.ilscript = Ilscript.createVector(builder.ilscript);
    }

    public int maxtermoccurrences() {
        return this.maxtermoccurrences.value();
    }

    public int maxtokenlength() {
        return this.maxtokenlength.value();
    }

    public int fieldmatchmaxlength() {
        return this.fieldmatchmaxlength.value();
    }

    public double maxReplacementCharactersRatio() {
        return this.maxReplacementCharactersRatio.value();
    }

    public int maxReplacementCharacters() {
        return this.maxReplacementCharacters.value();
    }

    public List<Ilscript> ilscript() {
        return this.ilscript;
    }

    public Ilscript ilscript(int i) {
        return (Ilscript)((Object)this.ilscript.get(i));
    }

    private ChangesRequiringRestart getChangesRequiringRestart(IlscriptsConfig newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart(CONFIG_DEF_NAME);
        return changes;
    }

    private static boolean containsFieldsFlaggedWithRestart() {
        return false;
    }

    public static final class Builder
    implements ConfigInstance.Builder {
        private Set<String> __uninitialized = new HashSet<String>();
        private Integer maxtermoccurrences = null;
        private Integer maxtokenlength = null;
        private Integer fieldmatchmaxlength = null;
        private Double maxReplacementCharactersRatio = null;
        private Integer maxReplacementCharacters = null;
        public List<Ilscript.Builder> ilscript = new ArrayList<Ilscript.Builder>();
        private boolean _applyOnRestart = false;

        public Builder() {
        }

        public Builder(IlscriptsConfig config) {
            this.maxtermoccurrences(config.maxtermoccurrences());
            this.maxtokenlength(config.maxtokenlength());
            this.fieldmatchmaxlength(config.fieldmatchmaxlength());
            this.maxReplacementCharactersRatio(config.maxReplacementCharactersRatio());
            this.maxReplacementCharacters(config.maxReplacementCharacters());
            for (Ilscript i : config.ilscript()) {
                this.ilscript(new Ilscript.Builder(i));
            }
        }

        private Builder override(Builder __superior) {
            if (__superior.maxtermoccurrences != null) {
                this.maxtermoccurrences(__superior.maxtermoccurrences);
            }
            if (__superior.maxtokenlength != null) {
                this.maxtokenlength(__superior.maxtokenlength);
            }
            if (__superior.fieldmatchmaxlength != null) {
                this.fieldmatchmaxlength(__superior.fieldmatchmaxlength);
            }
            if (__superior.maxReplacementCharactersRatio != null) {
                this.maxReplacementCharactersRatio(__superior.maxReplacementCharactersRatio);
            }
            if (__superior.maxReplacementCharacters != null) {
                this.maxReplacementCharacters(__superior.maxReplacementCharacters);
            }
            if (!__superior.ilscript.isEmpty()) {
                this.ilscript.addAll(__superior.ilscript);
            }
            return this;
        }

        public Builder maxtermoccurrences(int __value) {
            this.maxtermoccurrences = __value;
            return this;
        }

        private Builder maxtermoccurrences(String __value) {
            return this.maxtermoccurrences(Integer.valueOf(__value));
        }

        public Builder maxtokenlength(int __value) {
            this.maxtokenlength = __value;
            return this;
        }

        private Builder maxtokenlength(String __value) {
            return this.maxtokenlength(Integer.valueOf(__value));
        }

        public Builder fieldmatchmaxlength(int __value) {
            this.fieldmatchmaxlength = __value;
            return this;
        }

        private Builder fieldmatchmaxlength(String __value) {
            return this.fieldmatchmaxlength(Integer.valueOf(__value));
        }

        public Builder maxReplacementCharactersRatio(double __value) {
            this.maxReplacementCharactersRatio = __value;
            return this;
        }

        private Builder maxReplacementCharactersRatio(String __value) {
            return this.maxReplacementCharactersRatio(Double.valueOf(__value));
        }

        public Builder maxReplacementCharacters(int __value) {
            this.maxReplacementCharacters = __value;
            return this;
        }

        private Builder maxReplacementCharacters(String __value) {
            return this.maxReplacementCharacters(Integer.valueOf(__value));
        }

        public Builder ilscript(Ilscript.Builder __builder) {
            this.ilscript.add(__builder);
            return this;
        }

        public Builder ilscript(Consumer<Ilscript.Builder> __func) {
            Ilscript.Builder __inner = new Ilscript.Builder();
            __func.accept(__inner);
            this.ilscript.add(__inner);
            return this;
        }

        public Builder ilscript(List<Ilscript.Builder> __builders) {
            this.ilscript = __builders;
            return this;
        }

        public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
            if (producer instanceof Producer) {
                ((Producer)producer).getConfig(this);
                return true;
            }
            return false;
        }

        public final String getDefMd5() {
            return IlscriptsConfig.CONFIG_DEF_MD5;
        }

        public final String getDefName() {
            return IlscriptsConfig.CONFIG_DEF_NAME;
        }

        public final String getDefNamespace() {
            return IlscriptsConfig.CONFIG_DEF_NAMESPACE;
        }

        public final boolean getApplyOnRestart() {
            return this._applyOnRestart;
        }

        public final void setApplyOnRestart(boolean applyOnRestart) {
            this._applyOnRestart = applyOnRestart;
        }

        public IlscriptsConfig build() {
            return new IlscriptsConfig(this);
        }
    }

    public static final class Ilscript
    extends InnerNode {
        private final StringNode doctype;
        private final LeafNodeVector<String, StringNode> docfield;
        private final LeafNodeVector<String, StringNode> content;

        public Ilscript(Builder builder) {
            this(builder, true);
        }

        private Ilscript(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for ilscripts.ilscript[] must be initialized: " + String.valueOf(builder.__uninitialized));
            }
            this.doctype = builder.doctype == null ? new StringNode() : new StringNode(builder.doctype);
            this.docfield = new LeafNodeVector(builder.docfield, (LeafNode)new StringNode());
            this.content = new LeafNodeVector(builder.content, (LeafNode)new StringNode());
        }

        public String doctype() {
            return this.doctype.value();
        }

        public List<String> docfield() {
            return this.docfield.asList();
        }

        public String docfield(int i) {
            return ((StringNode)this.docfield.get(i)).value();
        }

        public List<String> content() {
            return this.content.asList();
        }

        public String content(int i) {
            return ((StringNode)this.content.get(i)).value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Ilscript newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("ilscript");
            return changes;
        }

        private static InnerNodeVector<Ilscript> createVector(List<Builder> builders) {
            ArrayList<Ilscript> elems = new ArrayList<Ilscript>();
            for (Builder b : builders) {
                elems.add(new Ilscript(b));
            }
            return new InnerNodeVector(elems);
        }

        public static final class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>(List.of("doctype"));
            private String doctype = null;
            public List<String> docfield = new ArrayList<String>();
            public List<String> content = new ArrayList<String>();

            public Builder() {
            }

            public Builder(Ilscript config) {
                this.doctype(config.doctype());
                this.docfield(config.docfield());
                this.content(config.content());
            }

            private Builder override(Builder __superior) {
                if (__superior.doctype != null) {
                    this.doctype(__superior.doctype);
                }
                if (!__superior.docfield.isEmpty()) {
                    this.docfield.addAll(__superior.docfield);
                }
                if (!__superior.content.isEmpty()) {
                    this.content.addAll(__superior.content);
                }
                return this;
            }

            public Builder doctype(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.doctype = __value;
                this.__uninitialized.remove("doctype");
                return this;
            }

            public Builder docfield(String __value) {
                this.docfield.add(__value);
                return this;
            }

            public Builder docfield(Collection<String> __values) {
                this.docfield.addAll(__values);
                return this;
            }

            public Builder content(String __value) {
                this.content.add(__value);
                return this;
            }

            public Builder content(Collection<String> __values) {
                this.content.addAll(__values);
                return this;
            }

            public Ilscript build() {
                return new Ilscript(this);
            }
        }
    }

    public static interface Producer
    extends ConfigInstance.Producer {
        public void getConfig(Builder var1);
    }
}

