/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.codegen;

import com.yahoo.config.codegen.CNode;
import com.yahoo.config.codegen.ConfigGenerator;
import com.yahoo.config.codegen.InnerCNode;
import com.yahoo.config.codegen.JavaClassBuilder;
import com.yahoo.config.codegen.LeafCNode;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;

public class BuilderGenerator {
    public static String getBuilder(InnerCNode node) {
        return BuilderGenerator.getDeclaration(node) + "\n" + ConfigGenerator.indentCode("  ", BuilderGenerator.getUninitializedScalars(node) + "\n\n" + Arrays.stream(node.getChildren()).map(BuilderGenerator::getBuilderFieldDefinition).collect(Collectors.joining("\n")) + "\n\n" + BuilderGenerator.getBuilderConstructors(node, ConfigGenerator.nodeClass(node)) + "\n\n" + BuilderGenerator.getOverrideMethod(node) + "\n\n" + BuilderGenerator.getBuilderSetters(node) + "\n" + BuilderGenerator.getSpecialRootBuilderCode(node) + "\n" + BuilderGenerator.getBuildMethod(node) + "\n") + "}";
    }

    private static String getDeclaration(InnerCNode node) {
        String getInterfaces = node.getParent() == null ? "implements ConfigInstance.Builder" : "implements ConfigBuilder";
        return "public static final class Builder " + getInterfaces + " {";
    }

    private static String getSpecialRootBuilderCode(InnerCNode node) {
        return node.getParent() == null ? "\n" + BuilderGenerator.getRootDeclarations() + "\n" : "";
    }

    private static String getBuildMethod(InnerCNode node) {
        return "public " + ConfigGenerator.nodeClass(node) + " build() {\n  return new " + ConfigGenerator.nodeClass(node) + "(this);\n}\n";
    }

    private static String getRootDeclarations() {
        return "private boolean _applyOnRestart = false;\n\n@java.lang.Override\npublic final boolean dispatchGetConfig(ConfigInstance.Producer producer) {\n  if (producer instanceof Producer) {\n    ((Producer)producer).getConfig(this);\n    return true;\n  }\n  return false;\n}\n\n@java.lang.Override\npublic final String getDefMd5() { return CONFIG_DEF_MD5; }\n\n@java.lang.Override\npublic final String getDefName() { return CONFIG_DEF_NAME; }\n\n@java.lang.Override\npublic final String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }\n\n@java.lang.Override\npublic final boolean getApplyOnRestart() { return _applyOnRestart; }\n\n@java.lang.Override\npublic final void setApplyOnRestart(boolean applyOnRestart) { _applyOnRestart = applyOnRestart; }";
    }

    private static String getUninitializedScalars(InnerCNode node) {
        ArrayList<CallSite> scalarsWithoutDefault = new ArrayList<CallSite>();
        for (CNode child : node.getChildren()) {
            if (!(child instanceof LeafCNode) || child.isArray || child.isMap || ((LeafCNode)child).getDefaultValue() != null || child instanceof LeafCNode.OptionalPathLeaf) continue;
            scalarsWithoutDefault.add((CallSite)((Object)("\"" + child.getName() + "\"")));
        }
        String uninitializedList = scalarsWithoutDefault.size() > 0 ? "Arrays.asList(\n" + ConfigGenerator.indentCode("  ", String.join((CharSequence)",\n", scalarsWithoutDefault) + "\n)") : "";
        return "private Set<String> __uninitialized = new HashSet<String>(" + uninitializedList + ");";
    }

    private static String getBuilderFieldDefinition(CNode node) {
        if (node.isArray) {
            return String.format("public List<%s> %s = new ArrayList<>();", BuilderGenerator.builderType(node), node.getName());
        }
        if (node.isMap) {
            return String.format("public Map<String, %s> %s = new LinkedHashMap<>();", BuilderGenerator.builderType(node), node.getName());
        }
        if (node instanceof InnerCNode) {
            return String.format("public %s %s = new %s();", BuilderGenerator.builderType(node), node.getName(), BuilderGenerator.builderType(node));
        }
        if (node instanceof LeafCNode) {
            String boxedBuilderType = BuilderGenerator.boxedBuilderType((LeafCNode)node);
            if (boxedBuilderType.startsWith("Optional<")) {
                return String.format("private %s %s = Optional.empty();", boxedBuilderType, node.getName());
            }
            return String.format("private %s %s = null;", boxedBuilderType, node.getName());
        }
        throw new IllegalStateException("Cannot produce builder field definition for node");
    }

    private static String getBuilderSetters(CNode node) {
        CNode[] children;
        ArrayList<String> elem = new ArrayList<String>();
        for (CNode child : children = node.getChildren()) {
            if (child instanceof InnerCNode && child.isArray) {
                elem.add(BuilderSetters.innerArraySetters((InnerCNode)child));
                continue;
            }
            if (child instanceof InnerCNode && child.isMap) {
                elem.add(BuilderSetters.innerMapSetters(child));
                continue;
            }
            if (child instanceof LeafCNode && child.isArray) {
                elem.add(BuilderSetters.leafArraySetters((LeafCNode)child));
                continue;
            }
            if (child instanceof LeafCNode && child.isMap) {
                elem.add(BuilderSetters.leafMapSetters(child));
                continue;
            }
            if (child instanceof InnerCNode) {
                elem.add(BuilderSetters.structSetter((InnerCNode)child));
                continue;
            }
            if (!(child instanceof LeafCNode)) continue;
            elem.add(BuilderSetters.scalarSetters((LeafCNode)child));
        }
        return String.join((CharSequence)"\n\n", elem);
    }

    private static String setBuilderValueFromConfig(CNode child, CNode node) {
        String name = child.getName();
        boolean isArray = child.isArray;
        boolean isMap = child.isMap;
        if (child instanceof LeafCNode.FileLeaf && isArray) {
            return name + "(" + ConfigGenerator.userDataType(child) + ".toValues(config." + name + "()));";
        }
        if (child instanceof LeafCNode.FileLeaf && isMap) {
            return name + "(" + ConfigGenerator.userDataType(child) + ".toValueMap(config." + name + "()));";
        }
        if (child instanceof LeafCNode.FileLeaf) {
            return name + "(config." + name + "().value());";
        }
        if (child instanceof LeafCNode.PathLeaf && isArray) {
            return name + "(" + ConfigGenerator.nodeClass(child) + ".toFileReferences(config." + name + "));";
        }
        if (child instanceof LeafCNode.PathLeaf && isMap) {
            return name + "(" + ConfigGenerator.nodeClass(child) + ".toFileReferenceMap(config." + name + "));";
        }
        if (child instanceof LeafCNode.PathLeaf) {
            return name + "(config." + name + ".getFileReference());";
        }
        if (child instanceof LeafCNode.OptionalPathLeaf) {
            return name + "(config." + name + ".getFileReference());";
        }
        if (child instanceof LeafCNode.UrlLeaf && isArray) {
            return name + "(" + ConfigGenerator.nodeClass(child) + ".toUrlReferences(config." + name + "));";
        }
        if (child instanceof LeafCNode.UrlLeaf && isMap) {
            return name + "(" + ConfigGenerator.nodeClass(child) + ".toUrlReferenceMap(config." + name + "));";
        }
        if (child instanceof LeafCNode.UrlLeaf) {
            return name + "(config." + name + ".getUrlReference());";
        }
        if (child instanceof LeafCNode.ModelLeaf && isArray) {
            return name + "(" + ConfigGenerator.nodeClass(child) + ".toModelReferences(config." + name + "));";
        }
        if (child instanceof LeafCNode.ModelLeaf && isMap) {
            return name + "(" + ConfigGenerator.nodeClass(child) + ".toModelReferenceMap(config." + name + "));";
        }
        if (child instanceof LeafCNode.ModelLeaf) {
            return name + "(config." + name + ".getModelReference());";
        }
        if (child instanceof LeafCNode) {
            return name + "(config." + name + "());";
        }
        if (child instanceof InnerCNode && isArray) {
            return BuilderGenerator.setInnerArrayBuildersFromConfig((InnerCNode)child, node);
        }
        if (child instanceof InnerCNode && isMap) {
            return BuilderGenerator.setInnerMapBuildersFromConfig((InnerCNode)child);
        }
        return name + "(new " + BuilderGenerator.builderType(child) + "(config." + name + "()));";
    }

    private static String setInnerArrayBuildersFromConfig(InnerCNode innerArr, CNode node) {
        String elemName = JavaClassBuilder.createUniqueSymbol(node, innerArr.getName());
        return "for (" + ConfigGenerator.userDataType(innerArr) + " " + elemName + " : config." + innerArr.getName() + "()) {\n  " + innerArr.getName() + "(new " + BuilderGenerator.builderType(innerArr) + "(" + elemName + "));\n}";
    }

    private static String setInnerMapBuildersFromConfig(InnerCNode innerMap) {
        String entryName = "__entry";
        return "for (Map.Entry<String, " + ConfigGenerator.userDataType(innerMap) + "> " + entryName + " : config." + innerMap.getName() + "().entrySet()) {\n  " + innerMap.getName() + "(" + entryName + ".getKey(), new " + ConfigGenerator.userDataType(innerMap) + ".Builder(" + entryName + ".getValue()));\n}";
    }

    private static String getBuilderConstructors(CNode node, String className) {
        return "public Builder() { }\n\npublic Builder(" + className + " config) {\n" + ConfigGenerator.indentCode("  ", Arrays.stream(node.getChildren()).map(child -> BuilderGenerator.setBuilderValueFromConfig(child, node)).collect(Collectors.joining("\n"))) + "\n}";
    }

    private static String conditionStatement(CNode child) {
        String superior = "__superior";
        if (child.isArray) {
            return "if (!" + superior + "." + child.getName() + ".isEmpty())";
        }
        if (child.isMap) {
            return "";
        }
        if (child instanceof LeafCNode) {
            return "if (" + superior + "." + child.getName() + " != null)";
        }
        return "";
    }

    private static String overrideBuilderValue(CNode child) {
        String superior = "__superior";
        String method = "override";
        String name = child.getName();
        String callSetter = name + "(__superior." + name + ");";
        if (child.isArray) {
            String arrayOverride = "  " + name + ".addAll(__superior." + name + ");";
            return BuilderGenerator.conditionStatement(child) + "\n" + arrayOverride;
        }
        if (child instanceof InnerCNode && !child.isArray && !child.isMap) {
            return name + "(" + name + ".override(__superior." + name + "));";
        }
        if (child.isMap) {
            return callSetter;
        }
        return BuilderGenerator.conditionStatement(child) + "\n  " + callSetter;
    }

    private static String getOverrideMethod(CNode node) {
        String superior = "__superior";
        String method = "override";
        return "private Builder " + method + "(Builder " + superior + ") {\n" + ConfigGenerator.indentCode("  ", Arrays.stream(node.getChildren()).map(BuilderGenerator::overrideBuilderValue).collect(Collectors.joining("\n"))) + "\n  return this;\n}";
    }

    private static String builderType(CNode node) {
        if (node instanceof InnerCNode) {
            return ConfigGenerator.boxedDataType(node) + ".Builder";
        }
        if (node instanceof LeafCNode.FileLeaf) {
            return "String";
        }
        if (node instanceof LeafCNode.PathLeaf) {
            return "FileReference";
        }
        if (node instanceof LeafCNode.OptionalPathLeaf) {
            return "Optional<FileReference>";
        }
        if (node instanceof LeafCNode.UrlLeaf) {
            return "UrlReference";
        }
        if (node instanceof LeafCNode.ModelLeaf) {
            return "ModelReference";
        }
        if (node instanceof LeafCNode && (node.isArray || node.isMap)) {
            return ConfigGenerator.boxedDataType(node);
        }
        return ConfigGenerator.userDataType(node);
    }

    private static String boxedBuilderType(LeafCNode node) {
        if (node instanceof LeafCNode.FileLeaf) {
            return "String";
        }
        if (node instanceof LeafCNode.PathLeaf) {
            return "FileReference";
        }
        if (node instanceof LeafCNode.OptionalPathLeaf) {
            return "Optional<FileReference>";
        }
        if (node instanceof LeafCNode.UrlLeaf) {
            return "UrlReference";
        }
        if (node instanceof LeafCNode.ModelLeaf) {
            return "ModelReference";
        }
        return ConfigGenerator.boxedDataType(node);
    }

    private static class BuilderSetters {
        private BuilderSetters() {
        }

        private static String structSetter(InnerCNode n) {
            return "public Builder " + n.getName() + "(" + BuilderGenerator.builderType(n) + " __builder) {\n  " + n.getName() + " = __builder;\n  return this;\n}\n/**\n * Make a new builder and run the supplied function on it before adding it to the list\n * @param __func lambda that modifies the given builder\n * @return this builder\n */\npublic Builder " + n.getName() + "(java.util.function.Consumer<" + BuilderGenerator.builderType(n) + "> __func) {\n  " + BuilderGenerator.builderType(n) + " __inner = new " + BuilderGenerator.builderType(n) + "();\n  __func.accept(__inner);\n  " + n.getName() + " = __inner;\n  return this;\n}";
        }

        private static String innerArraySetters(InnerCNode n) {
            return "/**\n * Add the given builder to this builder's list of " + ConfigGenerator.nodeClass(n) + " builders\n * @param __builder a builder\n * @return this builder\n */\npublic Builder " + n.getName() + "(" + BuilderGenerator.builderType(n) + " __builder) {\n  " + n.getName() + ".add(__builder);\n  return this;\n}\n\n/**\n * Make a new builder and run the supplied function on it before adding it to the list\n * @param __func lambda that modifies the given builder\n * @return this builder\n */\npublic Builder " + n.getName() + "(java.util.function.Consumer<" + BuilderGenerator.builderType(n) + "> __func) {\n  " + BuilderGenerator.builderType(n) + " __inner = new " + BuilderGenerator.builderType(n) + "();\n  __func.accept(__inner);\n  " + n.getName() + ".add(__inner);\n  return this;\n}\n\n/**\n * Set the given list as this builder's list of " + ConfigGenerator.nodeClass(n) + " builders\n * @param __builders a list of builders\n * @return this builder\n */\npublic Builder " + n.getName() + "(List<" + BuilderGenerator.builderType(n) + "> __builders) {\n  " + n.getName() + " = __builders;\n  return this;\n}";
        }

        private static String publicLeafNodeSetters(LeafCNode n) {
            return "public Builder " + n.getName() + "(" + BuilderGenerator.builderType(n) + " __value) {\n  " + n.getName() + ".add(__value);\n  return this;\n}\n\npublic Builder " + n.getName() + "(Collection<" + BuilderGenerator.builderType(n) + "> __values) {\n  " + n.getName() + ".addAll(__values);\n  return this;\n}";
        }

        private static String privateLeafNodeSetter(LeafCNode n) {
            if ("String".equals(BuilderGenerator.builderType(n)) || "FileReference".equals(BuilderGenerator.builderType(n))) {
                return "";
            }
            if ("Optional<FileReference>".equals(BuilderGenerator.builderType(n))) {
                return "\n\nprivate Builder " + n.getName() + "(String __value) {\n  return " + n.getName() + "(" + BuilderGenerator.builderType(n) + ".of(__value));\n}";
            }
            return "\n\nprivate Builder " + n.getName() + "(String __value) {\n  return " + n.getName() + "(" + BuilderGenerator.builderType(n) + ".valueOf(__value));\n}";
        }

        private static String leafArraySetters(LeafCNode n) {
            return BuilderSetters.publicLeafNodeSetters(n) + BuilderSetters.privateLeafNodeSetter(n);
        }

        private static String innerMapSetters(CNode n) {
            String r = "public Builder " + n.getName() + "(String __key, " + BuilderGenerator.builderType(n) + " __value) {\n  " + n.getName() + ".put(__key, __value);\n  return this;\n}\n\npublic Builder " + n.getName() + "(Map<String, " + BuilderGenerator.builderType(n) + "> __values) {\n  " + n.getName() + ".putAll(__values);\n  return this;\n}";
            if (n instanceof InnerCNode) {
                r = r + "\n\n/**\n * Make a new builder and run the supplied function on it before using it as the value\n * @param __func lambda that modifies the given builder\n * @return this builder\n */\npublic Builder " + n.getName() + "(String __key, java.util.function.Consumer<" + BuilderGenerator.builderType(n) + "> __func) {\n  " + BuilderGenerator.builderType(n) + " __inner = new " + BuilderGenerator.builderType(n) + "();\n  __func.accept(__inner);\n  " + n.getName() + ".put(__key, __inner);\n  return this;\n}";
            }
            return r;
        }

        private static String privateLeafMapSetter(CNode n) {
            if ("String".equals(BuilderGenerator.builderType(n)) || "FileReference".equals(BuilderGenerator.builderType(n))) {
                return "";
            }
            return "\n\nprivate Builder " + n.getName() + "(String __key, String __value) {\n  return " + n.getName() + "(__key, " + BuilderGenerator.builderType(n) + ".valueOf(__value));\n}";
        }

        private static String leafMapSetters(CNode n) {
            return BuilderSetters.innerMapSetters(n) + BuilderSetters.privateLeafMapSetter(n);
        }

        private static String scalarSetters(LeafCNode n) {
            String name = n.getName();
            Object signalInitialized = n.getDefaultValue() == null ? "  __uninitialized.remove(\"" + name + "\");\n" : "";
            String bType = BuilderGenerator.builderType(n);
            String privateSetter = "";
            if (!Set.of("String", "FileReference", "ModelReference", "Optional<FileReference>").contains(bType)) {
                String type = ConfigGenerator.boxedDataType(n);
                if ("UrlReference".equals(bType)) {
                    type = bType;
                }
                privateSetter = String.format("\nprivate Builder %s(String %svalue) {\n  return %s(%s.valueOf(%svalue));\n}", name, "__", name, type, "__");
            } else if ("Optional<FileReference>".equals(bType)) {
                privateSetter = String.format("\nprivate Builder %s(FileReference %svalue) {\n  return %s(Optional.of(%svalue));\n}", name, "__", name, "__");
            }
            String getNullGuard = bType.equals(BuilderGenerator.boxedBuilderType(n)) ? String.format("\nif (%svalue == null) throw new IllegalArgumentException(\"Null value is not allowed.\");", "__") : "";
            return String.format("public Builder %s(%s %svalue) {%s\n  %s = %svalue;\n%s", name, bType, "__", getNullGuard, name, "__", signalInitialized) + "  return this;\n}\n" + privateSetter;
        }
    }
}

