/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.codegen;

import com.yahoo.config.codegen.PropertyException;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class MakeConfigProperties {
    private static final List<String> legalLanguages = List.of("java", "cpp");
    final File destDir;
    final List<File> specFiles;
    final String language;
    final String dirInRoot;
    final String javaPackagePrefix;
    final boolean dumpTree;
    final boolean generateFrameworkCode;

    MakeConfigProperties() throws PropertyException {
        this(System.getProperty("config.dest"), System.getProperty("config.spec"), System.getProperty("config.lang"), System.getProperty("config.subdir"), System.getProperty("config.dumpTree"), System.getProperty("config.useFramework"), System.getProperty("config.packagePrefix"));
    }

    public MakeConfigProperties(String destDir, String specFiles, String language, String dirInRoot, String dumpTree, String generateFrameworkCode, String javaPackagePrefix) throws PropertyException {
        this.destDir = MakeConfigProperties.checkDestinationDir(destDir);
        this.specFiles = MakeConfigProperties.checkSpecificationFiles(specFiles);
        this.language = MakeConfigProperties.checkLanguage(language);
        this.dirInRoot = MakeConfigProperties.checkDirInRoot(this.destDir, dirInRoot);
        this.dumpTree = Boolean.parseBoolean(dumpTree);
        this.generateFrameworkCode = Boolean.parseBoolean(generateFrameworkCode);
        this.javaPackagePrefix = javaPackagePrefix;
    }

    private static File checkDestinationDir(String destination) throws PropertyException {
        if (destination == null) {
            throw new PropertyException("Missing property: config.dest.");
        }
        File dir = new File(destination);
        if (!dir.isDirectory()) {
            throw new PropertyException("Could not find directory: " + dir.getPath());
        }
        return dir;
    }

    private static String checkDirInRoot(File destDir, String dirInRoot) throws PropertyException {
        if (dirInRoot == null) {
            return null;
        }
        File f = new File(destDir, dirInRoot);
        if (!f.isDirectory()) {
            throw new PropertyException("Could not find directory: " + f.getPath());
        }
        return dirInRoot;
    }

    private static String checkLanguage(String lang) throws PropertyException {
        String inputLang;
        String string = inputLang = lang != null ? lang.toLowerCase() : "java";
        if (!legalLanguages.contains(inputLang)) {
            throw new PropertyException("Unsupported code language: '" + inputLang + "'. Supported languages are: " + String.valueOf(legalLanguages));
        }
        return inputLang;
    }

    private static List<File> checkSpecificationFiles(String spec) throws PropertyException {
        if (spec == null || spec.isEmpty()) {
            throw new PropertyException("Missing property: config.spec");
        }
        ArrayList<File> files = new ArrayList<File>();
        for (String token : spec.split(",", -1)) {
            File file = new File(token);
            if (!file.isFile()) {
                throw new PropertyException("Could not read file " + String.valueOf(file));
            }
            files.add(file);
        }
        return files;
    }
}

