/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.secret.model;

public record SecretValue(String value) {
    private static final int MAX_LENGTH = 65536;

    public SecretValue {
        if (value == null || value.isBlank()) {
            throw new IllegalArgumentException("Secret value cannot be null or empty");
        }
        if (value.length() > 65536) {
            throw new IllegalArgumentException("Secret value is too long");
        }
    }

    public static SecretValue of(String value) {
        return new SecretValue(value);
    }
}

