/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.messagebus.shared;

import com.yahoo.jdisc.AbstractResource;
import com.yahoo.jdisc.ResourceReference;
import com.yahoo.messagebus.Message;
import com.yahoo.messagebus.Reply;
import com.yahoo.messagebus.ReplyHandler;
import com.yahoo.messagebus.Result;
import com.yahoo.messagebus.SourceSession;
import com.yahoo.messagebus.SourceSessionParams;
import com.yahoo.messagebus.shared.ClientSession;
import com.yahoo.messagebus.shared.SharedMessageBus;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class SharedSourceSession
extends AbstractResource
implements ClientSession,
ReplyHandler {
    private static final Logger log = Logger.getLogger(SharedSourceSession.class.getName());
    private final SourceSession session;
    private final ResourceReference mbusReference;

    public SharedSourceSession(SharedMessageBus mbus, SourceSessionParams params) {
        if (params.getReplyHandler() != null) {
            throw new IllegalArgumentException("Reply handler must be null.");
        }
        this.session = mbus.messageBus().createSourceSession(params.setReplyHandler((ReplyHandler)this));
        this.mbusReference = mbus.refer(this);
    }

    public SourceSession session() {
        return this.session;
    }

    @Override
    public Result sendMessage(Message msg) {
        return this.session.send(msg);
    }

    public Result sendMessageBlocking(Message msg) throws InterruptedException {
        return this.session.sendBlocking(msg);
    }

    public void handleReply(Reply reply) {
        reply.popHandler().handleReply(reply);
    }

    protected void destroy() {
        log.log(Level.FINE, "Destroying shared source session.");
        this.session.close();
        this.mbusReference.close();
    }
}

