/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.cluster;

import com.yahoo.component.ComponentId;
import com.yahoo.component.annotation.Inject;
import com.yahoo.component.chain.dependencies.After;
import com.yahoo.component.provider.ComponentRegistry;
import com.yahoo.container.QrSearchersConfig;
import com.yahoo.container.core.documentapi.VespaDocumentAccess;
import com.yahoo.container.handler.VipStatus;
import com.yahoo.prelude.IndexFacts;
import com.yahoo.prelude.fastsearch.ClusterParams;
import com.yahoo.prelude.fastsearch.DocumentdbInfoConfig;
import com.yahoo.prelude.fastsearch.FastSearcher;
import com.yahoo.prelude.fastsearch.SummaryParameters;
import com.yahoo.prelude.fastsearch.VespaBackEndSearcher;
import com.yahoo.search.Query;
import com.yahoo.search.Result;
import com.yahoo.search.Searcher;
import com.yahoo.search.config.ClusterConfig;
import com.yahoo.search.dispatch.Dispatcher;
import com.yahoo.search.query.ParameterParser;
import com.yahoo.search.ranking.GlobalPhaseRanker;
import com.yahoo.search.result.ErrorMessage;
import com.yahoo.search.schema.SchemaInfo;
import com.yahoo.search.searchchain.Execution;
import com.yahoo.vespa.streamingvisitors.StreamingSearcher;
import com.yahoo.yolean.Exceptions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RejectedExecutionException;

@After(value={"*"})
public class ClusterSearcher
extends Searcher {
    private static final long DEFAULT_MAX_QUERY_TIMEOUT = 600000L;
    private static final long DEFAULT_MAX_QUERY_CACHE_TIMEOUT = 10000L;
    private final String searchClusterName;
    private final Set<String> schemas;
    private final long maxQueryTimeout;
    private final long maxQueryCacheTimeout;
    private final VespaBackEndSearcher server;
    private final Executor executor;
    private final GlobalPhaseRanker globalPhaseRanker;

    @Inject
    public ClusterSearcher(ComponentId id, Executor executor, QrSearchersConfig qrsConfig, ClusterConfig clusterConfig, DocumentdbInfoConfig documentDbConfig, SchemaInfo schemaInfo, ComponentRegistry<Dispatcher> dispatchers, GlobalPhaseRanker globalPhaseRanker, VipStatus vipStatus, VespaDocumentAccess access) {
        super(id);
        this.executor = executor;
        int searchClusterIndex = clusterConfig.clusterId();
        this.searchClusterName = clusterConfig.clusterName();
        QrSearchersConfig.Searchcluster searchClusterConfig = ClusterSearcher.getSearchClusterConfigFromClusterName(qrsConfig, this.searchClusterName);
        this.globalPhaseRanker = searchClusterConfig.globalphase() ? globalPhaseRanker : null;
        this.schemas = new LinkedHashSet<String>();
        this.maxQueryTimeout = ParameterParser.asMilliSeconds(clusterConfig.maxQueryTimeout(), 600000L);
        this.maxQueryCacheTimeout = ParameterParser.asMilliSeconds(clusterConfig.maxQueryCacheTimeout(), 10000L);
        SummaryParameters docSumParams = new SummaryParameters(qrsConfig.com().yahoo().prelude().fastsearch().FastSearcher().docsum().defaultclass());
        for (DocumentdbInfoConfig.Documentdb docDb : documentDbConfig.documentdb()) {
            this.schemas.add(docDb.name());
        }
        String uniqueServerId = UUID.randomUUID().toString();
        if (searchClusterConfig.indexingmode() == QrSearchersConfig.Searchcluster.Indexingmode.STREAMING) {
            this.server = ClusterSearcher.streamingCluster(uniqueServerId, searchClusterIndex, searchClusterConfig, docSumParams, documentDbConfig, schemaInfo, access);
            vipStatus.addToRotation(this.server.getName());
        } else {
            this.server = ClusterSearcher.searchDispatch(searchClusterIndex, this.searchClusterName, uniqueServerId, docSumParams, documentDbConfig, schemaInfo, dispatchers);
        }
    }

    private static QrSearchersConfig.Searchcluster getSearchClusterConfigFromClusterName(QrSearchersConfig config, String name) {
        for (QrSearchersConfig.Searchcluster searchCluster : config.searchcluster()) {
            if (!searchCluster.name().equals(name)) continue;
            return searchCluster;
        }
        return null;
    }

    private static ClusterParams makeClusterParams(int searchclusterIndex) {
        return new ClusterParams("sc" + searchclusterIndex + ".num0");
    }

    private static FastSearcher searchDispatch(int searchclusterIndex, String searchClusterName, String serverId, SummaryParameters docSumParams, DocumentdbInfoConfig documentdbInfoConfig, SchemaInfo schemaInfo, ComponentRegistry<Dispatcher> dispatchers) {
        ClusterParams clusterParams = ClusterSearcher.makeClusterParams(searchclusterIndex);
        ComponentId dispatcherComponentId = new ComponentId("dispatcher." + searchClusterName);
        Dispatcher dispatcher = (Dispatcher)((Object)dispatchers.getComponent(dispatcherComponentId));
        if (dispatcher == null) {
            throw new IllegalArgumentException("Configuration error: No dispatcher " + dispatcherComponentId + " is configured");
        }
        return new FastSearcher(serverId, dispatcher, docSumParams, clusterParams, documentdbInfoConfig, schemaInfo);
    }

    private static StreamingSearcher streamingCluster(String serverId, int searchclusterIndex, QrSearchersConfig.Searchcluster searchClusterConfig, SummaryParameters docSumParams, DocumentdbInfoConfig documentdbInfoConfig, SchemaInfo schemaInfo, VespaDocumentAccess access) {
        if (searchClusterConfig.searchdef().size() != 1) {
            throw new IllegalArgumentException("Streaming search clusters can only contain a single schema but got " + searchClusterConfig.searchdef());
        }
        ClusterParams clusterParams = ClusterSearcher.makeClusterParams(searchclusterIndex);
        StreamingSearcher searcher = new StreamingSearcher(access);
        searcher.setSearchClusterName(searchClusterConfig.rankprofiles().configid());
        searcher.setDocumentType(searchClusterConfig.searchdef(0));
        searcher.setStorageClusterRouteSpec(searchClusterConfig.storagecluster().routespec());
        searcher.init(serverId, docSumParams, clusterParams, documentdbInfoConfig, schemaInfo);
        return searcher;
    }

    ClusterSearcher(Set<String> schemas, VespaBackEndSearcher searcher, Executor executor) {
        this.schemas = schemas;
        this.searchClusterName = "testScenario";
        this.maxQueryTimeout = 600000L;
        this.maxQueryCacheTimeout = 10000L;
        this.server = searcher;
        this.executor = executor;
        this.globalPhaseRanker = null;
    }

    ClusterSearcher(Set<String> schemas) {
        this(schemas, null, null);
    }

    @Override
    public void fill(Result result, String summaryClass, Execution execution) {
        Query query = result.getQuery();
        VespaBackEndSearcher searcher = this.server;
        if (searcher != null) {
            if (query.getTimeLeft() > 0L) {
                ((Searcher)searcher).fill(result, summaryClass, execution);
            } else if (result.hits().getErrorHit() == null) {
                result.hits().addError(ErrorMessage.createTimeout("No time left to get summaries, query timeout was " + query.getTimeout() + " ms"));
            }
        } else if (result.hits().getErrorHit() == null) {
            result.hits().addError(ErrorMessage.createNoBackendsInService("Could not fill result"));
        }
    }

    @Override
    public Result search(Query query, Execution execution) {
        this.validateQueryTimeout(query);
        this.validateQueryCache(query);
        VespaBackEndSearcher searcher = this.server;
        if (searcher == null) {
            return new Result(query, ErrorMessage.createNoBackendsInService("Could not search"));
        }
        if (query.getTimeLeft() <= 0L) {
            return new Result(query, ErrorMessage.createTimeout("No time left for searching"));
        }
        return this.doSearch(searcher, query, execution);
    }

    private void validateQueryTimeout(Query query) {
        if (query.getTimeout() <= this.maxQueryTimeout) {
            return;
        }
        if (query.getTrace().isTraceable(2)) {
            query.trace("Query timeout (" + query.getTimeout() + " ms) > max query timeout (" + this.maxQueryTimeout + " ms). Setting timeout to " + this.maxQueryTimeout + " ms.", 2);
        }
        query.setTimeout(this.maxQueryTimeout);
    }

    private void validateQueryCache(Query query) {
        if (!query.getRanking().getQueryCache()) {
            return;
        }
        if (query.getTimeout() <= this.maxQueryCacheTimeout) {
            return;
        }
        if (query.getTrace().isTraceable(2)) {
            query.trace("Query timeout (" + query.getTimeout() + " ms) > max query cache timeout (" + this.maxQueryCacheTimeout + " ms). Disabling query cache.", 2);
        }
        query.getRanking().setQueryCache(false);
    }

    private Result doSearch(Searcher searcher, Query query, Execution execution) {
        if (this.schemas.size() > 1) {
            return this.searchMultipleDocumentTypes(searcher, query, execution);
        }
        String docType = this.schemas.iterator().next();
        query.getModel().setRestrict(docType);
        return this.perSchemaSearch(searcher, query, execution);
    }

    private Result perSchemaSearch(Searcher searcher, Query query, Execution execution) {
        ErrorMessage error;
        boolean useGlobalPhase;
        Set<String> restrict = query.getModel().getRestrict();
        if (restrict.size() != 1) {
            throw new IllegalStateException("perSchemaSearch must always be called with 1 schema, got: " + restrict.size());
        }
        String schema = restrict.iterator().next();
        boolean bl = useGlobalPhase = this.globalPhaseRanker != null;
        if (useGlobalPhase && (error = (ErrorMessage)this.globalPhaseRanker.validateNoSorting(query, schema).orElse(null)) != null) {
            return new Result(query, error);
        }
        Result result = searcher.search(query, execution);
        if (useGlobalPhase) {
            this.globalPhaseRanker.rerankHits(query, result, schema);
        }
        return result;
    }

    private static void processResult(Query query, FutureTask<Result> task, Result mergedResult) {
        try {
            Result result = task.get();
            mergedResult.mergeWith(result);
            mergedResult.hits().addAll(result.hits().asUnorderedHits());
        }
        catch (InterruptedException | ExecutionException e) {
            mergedResult.hits().addError(ErrorMessage.createInternalServerError("Failed querying '" + query.getModel().getRestrict() + "': " + Exceptions.toMessageString((Throwable)e)));
        }
    }

    private Result searchMultipleDocumentTypes(Searcher searcher, Query query, Execution execution) {
        Set<String> schemas = this.resolveSchemas(query, execution.context().getIndexFacts());
        List<Query> queries = this.createQueries(query, schemas);
        if (queries.size() == 1) {
            return this.perSchemaSearch(searcher, queries.get(0), execution);
        }
        Result mergedResult = new Result(query);
        ArrayList<FutureTask<Result>> pending = new ArrayList<FutureTask<Result>>(queries.size());
        for (Query query2 : queries) {
            FutureTask<Result> task = new FutureTask<Result>(() -> this.perSchemaSearch(searcher, q, execution));
            try {
                this.executor.execute(task);
                pending.add(task);
            }
            catch (RejectedExecutionException rej) {
                task.run();
                ClusterSearcher.processResult(query, task, mergedResult);
            }
        }
        for (FutureTask futureTask : pending) {
            ClusterSearcher.processResult(query, futureTask, mergedResult);
        }
        if (query.getOffset() > 0 || query.getHits() < mergedResult.hits().size()) {
            if (mergedResult.getHitOrderer() != null) {
                searcher.fill(mergedResult, "attributeprefetch", execution);
            }
            mergedResult.hits().trim(query.getOffset(), query.getHits());
            query.setOffset(0);
        }
        return mergedResult;
    }

    Set<String> resolveSchemas(Query query, IndexFacts indexFacts) {
        Set<String> restrict = query.getModel().getRestrict();
        if (restrict == null || restrict.isEmpty()) {
            Set<String> sources = query.getModel().getSources();
            return sources == null || sources.isEmpty() ? this.schemas : new HashSet<String>(indexFacts.newSession(sources, Collections.emptyList(), this.schemas).documentTypes());
        }
        return this.filterValidDocumentTypes(restrict);
    }

    private Set<String> filterValidDocumentTypes(Collection<String> restrict) {
        LinkedHashSet<String> retval = new LinkedHashSet<String>();
        for (String docType : restrict) {
            if (docType == null || !this.schemas.contains(docType)) continue;
            retval.add(docType);
        }
        return retval;
    }

    private List<Query> createQueries(Query query, Set<String> docTypes) {
        query.getModel().getQueryTree();
        ArrayList<Query> retval = new ArrayList<Query>(docTypes.size());
        if (docTypes.size() == 1) {
            query.getModel().setRestrict(docTypes.iterator().next());
            retval.add(query);
        } else if (!docTypes.isEmpty()) {
            for (String docType : docTypes) {
                Query q = query.clone();
                q.setOffset(0);
                q.setHits(query.getOffset() + query.getHits());
                q.getModel().setRestrict(docType);
                retval.add(q);
            }
        }
        return retval;
    }

    public void deconstruct() {
        if (this.server != null) {
            this.server.shutDown();
        }
    }
}

