/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.query.parser;

import com.yahoo.prelude.query.parser.Token;
import java.util.List;

final class TokenPosition {
    private List<Token> tokenList;
    private int position = 0;

    public void initialize(List<Token> tokens) {
        this.tokenList = tokens;
        this.position = 0;
    }

    public Token current() {
        return this.current(0);
    }

    public Token currentNoIgnore() {
        return this.currentNoIgnore(0);
    }

    public Token current(int offset) {
        int i = this.position + offset;
        while (i < this.tokenList.size()) {
            Token token = this.tokenList.get(i++);
            if (token.kind == Token.Kind.SPACE) continue;
            return token;
        }
        return null;
    }

    public Token currentNoIgnore(int offset) {
        if (this.tokenList.size() <= this.position + offset) {
            return null;
        }
        return this.tokenList.get(this.position + offset);
    }

    public boolean currentIs(Token.Kind kind) {
        Token current = this.current();
        if (current == null) {
            return false;
        }
        return current.kind == kind;
    }

    public boolean currentIsNoIgnore(Token.Kind kind) {
        Token current = this.currentNoIgnore();
        if (current == null) {
            return false;
        }
        return current.kind == kind;
    }

    public boolean hasNext() {
        return this.tokenList.size() > this.position + 1;
    }

    public Token next() {
        while (this.position < this.tokenList.size()) {
            Token current = this.tokenList.get(this.position++);
            if (current.kind == Token.Kind.SPACE) continue;
            return current;
        }
        return null;
    }

    public void skip() {
        this.next();
    }

    public void skipNoIgnore() {
        ++this.position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public int getPosition() {
        return this.position;
    }

    public boolean skipMultiple(Token.Kind kind) {
        boolean skipped = false;
        while (this.hasNext() && this.current().kind == kind) {
            skipped = true;
            this.skip();
        }
        return skipped;
    }

    public boolean skipMultipleNoIgnore(Token.Kind kind) {
        boolean skipped = false;
        while (this.hasNext() && this.currentNoIgnore().kind == kind) {
            skipped = true;
            this.skip();
        }
        return skipped;
    }

    public boolean skip(Token.Kind kind) {
        Token current = this.current();
        if (current == null || current.kind != kind) {
            return false;
        }
        this.skip();
        return true;
    }

    public boolean skipNoIgnore(Token.Kind kind) {
        Token current = this.currentNoIgnore();
        if (current == null || current.kind != kind) {
            return false;
        }
        this.skipNoIgnore();
        return true;
    }

    public String toString() {
        return "token " + this.current();
    }
}

