/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.semantics;

import com.yahoo.config.BooleanNode;
import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigBuilder;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.InnerNode;
import com.yahoo.config.InnerNodeVector;
import com.yahoo.config.StringNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;

public final class SemanticRulesConfig
extends ConfigInstance {
    public static final String CONFIG_DEF_MD5 = "fa8416d90768614c9689a3d33ce67684";
    public static final String CONFIG_DEF_NAME = "semantic-rules";
    public static final String CONFIG_DEF_NAMESPACE = "prelude.semantics";
    public static final String[] CONFIG_DEF_SCHEMA = new String[]{"namespace=prelude.semantics", "compatibility bool default=false", "rulebase[].name string", "rulebase[].isdefault bool default=false", "rulebase[].automata string default=\"\"", "rulebase[].rules string"};
    private final BooleanNode compatibility;
    private final InnerNodeVector<Rulebase> rulebase;

    public static String getDefMd5() {
        return CONFIG_DEF_MD5;
    }

    public static String getDefName() {
        return CONFIG_DEF_NAME;
    }

    public static String getDefNamespace() {
        return CONFIG_DEF_NAMESPACE;
    }

    public SemanticRulesConfig(Builder builder) {
        this(builder, true);
    }

    private SemanticRulesConfig(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
            throw new IllegalArgumentException("The following builder parameters for semantic-rules must be initialized: " + builder.__uninitialized);
        }
        this.compatibility = builder.compatibility == null ? new BooleanNode(false) : new BooleanNode(builder.compatibility.booleanValue());
        this.rulebase = Rulebase.createVector(builder.rulebase);
    }

    public boolean compatibility() {
        return this.compatibility.value();
    }

    public List<Rulebase> rulebase() {
        return this.rulebase;
    }

    public Rulebase rulebase(int i) {
        return (Rulebase)((Object)this.rulebase.get(i));
    }

    private ChangesRequiringRestart getChangesRequiringRestart(SemanticRulesConfig newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart(CONFIG_DEF_NAME);
        return changes;
    }

    private static boolean containsFieldsFlaggedWithRestart() {
        return false;
    }

    public static final class Builder
    implements ConfigInstance.Builder {
        private Set<String> __uninitialized = new HashSet<String>();
        private Boolean compatibility = null;
        public List<Rulebase.Builder> rulebase = new ArrayList<Rulebase.Builder>();
        private boolean _applyOnRestart = false;

        public Builder() {
        }

        public Builder(SemanticRulesConfig config) {
            this.compatibility(config.compatibility());
            for (Rulebase r : config.rulebase()) {
                this.rulebase(new Rulebase.Builder(r));
            }
        }

        private Builder override(Builder __superior) {
            if (__superior.compatibility != null) {
                this.compatibility(__superior.compatibility);
            }
            if (!__superior.rulebase.isEmpty()) {
                this.rulebase.addAll(__superior.rulebase);
            }
            return this;
        }

        public Builder compatibility(boolean __value) {
            this.compatibility = __value;
            return this;
        }

        private Builder compatibility(String __value) {
            return this.compatibility(Boolean.valueOf(__value));
        }

        public Builder rulebase(Rulebase.Builder __builder) {
            this.rulebase.add(__builder);
            return this;
        }

        public Builder rulebase(Consumer<Rulebase.Builder> __func) {
            Rulebase.Builder __inner = new Rulebase.Builder();
            __func.accept(__inner);
            this.rulebase.add(__inner);
            return this;
        }

        public Builder rulebase(List<Rulebase.Builder> __builders) {
            this.rulebase = __builders;
            return this;
        }

        public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
            if (producer instanceof Producer) {
                ((Producer)producer).getConfig(this);
                return true;
            }
            return false;
        }

        public final String getDefMd5() {
            return SemanticRulesConfig.CONFIG_DEF_MD5;
        }

        public final String getDefName() {
            return SemanticRulesConfig.CONFIG_DEF_NAME;
        }

        public final String getDefNamespace() {
            return SemanticRulesConfig.CONFIG_DEF_NAMESPACE;
        }

        public final boolean getApplyOnRestart() {
            return this._applyOnRestart;
        }

        public final void setApplyOnRestart(boolean applyOnRestart) {
            this._applyOnRestart = applyOnRestart;
        }

        public SemanticRulesConfig build() {
            return new SemanticRulesConfig(this);
        }
    }

    public static final class Rulebase
    extends InnerNode {
        private final StringNode name;
        private final BooleanNode isdefault;
        private final StringNode automata;
        private final StringNode rules;

        public Rulebase(Builder builder) {
            this(builder, true);
        }

        private Rulebase(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for semantic-rules.rulebase[] must be initialized: " + builder.__uninitialized);
            }
            this.name = builder.name == null ? new StringNode() : new StringNode(builder.name);
            this.isdefault = builder.isdefault == null ? new BooleanNode(false) : new BooleanNode(builder.isdefault.booleanValue());
            this.automata = builder.automata == null ? new StringNode("") : new StringNode(builder.automata);
            this.rules = builder.rules == null ? new StringNode() : new StringNode(builder.rules);
        }

        public String name() {
            return this.name.value();
        }

        public boolean isdefault() {
            return this.isdefault.value();
        }

        public String automata() {
            return this.automata.value();
        }

        public String rules() {
            return this.rules.value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Rulebase newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("rulebase");
            return changes;
        }

        private static InnerNodeVector<Rulebase> createVector(List<Builder> builders) {
            ArrayList<Rulebase> elems = new ArrayList<Rulebase>();
            for (Builder b : builders) {
                elems.add(new Rulebase(b));
            }
            return new InnerNodeVector(elems);
        }

        public static final class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>(Arrays.asList("name", "rules"));
            private String name = null;
            private Boolean isdefault = null;
            private String automata = null;
            private String rules = null;

            public Builder() {
            }

            public Builder(Rulebase config) {
                this.name(config.name());
                this.isdefault(config.isdefault());
                this.automata(config.automata());
                this.rules(config.rules());
            }

            private Builder override(Builder __superior) {
                if (__superior.name != null) {
                    this.name(__superior.name);
                }
                if (__superior.isdefault != null) {
                    this.isdefault(__superior.isdefault);
                }
                if (__superior.automata != null) {
                    this.automata(__superior.automata);
                }
                if (__superior.rules != null) {
                    this.rules(__superior.rules);
                }
                return this;
            }

            public Builder name(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.name = __value;
                this.__uninitialized.remove("name");
                return this;
            }

            public Builder isdefault(boolean __value) {
                this.isdefault = __value;
                return this;
            }

            private Builder isdefault(String __value) {
                return this.isdefault(Boolean.valueOf(__value));
            }

            public Builder automata(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.automata = __value;
                return this;
            }

            public Builder rules(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.rules = __value;
                this.__uninitialized.remove("rules");
                return this;
            }

            public Rulebase build() {
                return new Rulebase(this);
            }
        }
    }

    public static interface Producer
    extends ConfigInstance.Producer {
        public void getConfig(Builder var1);
    }
}

