/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.semantics.engine;

import com.yahoo.prelude.query.CompositeItem;
import com.yahoo.prelude.query.Item;
import com.yahoo.prelude.query.TermItem;
import com.yahoo.prelude.query.WordItem;
import com.yahoo.prelude.semantics.engine.FlattenedItem;
import java.util.Objects;

public class Match {
    private final int position;
    private final TermItem item;
    private final String replaceValue;
    private final CompositeItem parent;

    public Match(FlattenedItem item, String replaceValue) {
        this.item = item.getItem();
        this.replaceValue = replaceValue == null ? item.getItem().getIndexedString() : replaceValue;
        this.parent = this.item.getParent();
        this.position = item.getPosition();
    }

    public int getPosition() {
        return this.position;
    }

    public TermItem getItem() {
        return this.item;
    }

    public String getReplaceValue() {
        return this.replaceValue;
    }

    public CompositeItem getParent() {
        return this.parent;
    }

    public Item toItem(String label) {
        return this.toItem(label, this.getReplaceValue());
    }

    public Item toItem(String label, String term) {
        WordItem newItem = new WordItem(term, label);
        newItem.setWeight(this.item.getWeight());
        return newItem;
    }

    public int hashCode() {
        return Objects.hash(this.item.getIndexedString(), this.item.getIndexName());
    }

    public boolean equals(Object o) {
        if (!(o instanceof Match)) {
            return false;
        }
        Match other = (Match)o;
        if (other.position != this.position) {
            return false;
        }
        return other.item.equals(this.item);
    }

    public String toString() {
        return "match of " + this.item + " at " + this.position + " to be replaced by " + this.replaceValue;
    }
}

