/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search;

import ai.vespa.cloud.ZoneInfo;
import com.google.common.collect.ImmutableMap;
import com.yahoo.container.jdisc.HttpRequest;
import com.yahoo.jdisc.http.HttpRequest;
import com.yahoo.language.process.Embedder;
import com.yahoo.prelude.query.textualrepresentation.TextualQueryRepresentation;
import com.yahoo.processing.Request;
import com.yahoo.processing.request.CompoundName;
import com.yahoo.search.dispatch.Dispatcher;
import com.yahoo.search.federation.FederationSearcher;
import com.yahoo.search.query.Model;
import com.yahoo.search.query.ParameterParser;
import com.yahoo.search.query.Presentation;
import com.yahoo.search.query.Properties;
import com.yahoo.search.query.Ranking;
import com.yahoo.search.query.Select;
import com.yahoo.search.query.SessionId;
import com.yahoo.search.query.Sorting;
import com.yahoo.search.query.Trace;
import com.yahoo.search.query.UniqueRequestId;
import com.yahoo.search.query.context.QueryContext;
import com.yahoo.search.query.profile.ModelObjectMap;
import com.yahoo.search.query.profile.QueryProfileProperties;
import com.yahoo.search.query.profile.compiled.CompiledQueryProfile;
import com.yahoo.search.query.profile.compiled.CompiledQueryProfileRegistry;
import com.yahoo.search.query.profile.types.FieldDescription;
import com.yahoo.search.query.profile.types.FieldType;
import com.yahoo.search.query.profile.types.QueryProfileFieldType;
import com.yahoo.search.query.profile.types.QueryProfileType;
import com.yahoo.search.query.profile.types.QueryProfileTypeRegistry;
import com.yahoo.search.query.properties.DefaultProperties;
import com.yahoo.search.query.properties.PropertyMap;
import com.yahoo.search.query.properties.QueryProperties;
import com.yahoo.search.query.properties.QueryPropertyAliases;
import com.yahoo.search.query.properties.RankProfileInputProperties;
import com.yahoo.search.query.properties.RequestContextProperties;
import com.yahoo.search.query.ranking.RankFeatures;
import com.yahoo.search.schema.SchemaInfo;
import com.yahoo.search.yql.NullItemException;
import com.yahoo.search.yql.VespaSerializer;
import com.yahoo.yolean.Exceptions;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class Query
extends Request
implements Cloneable {
    private long startTime;
    private int offset = 0;
    private int hits = 10;
    private static final long dumpTimeout = 360000L;
    private static final long defaultTimeout = 500L;
    private long timeout = 500L;
    private boolean noCache = false;
    private boolean groupingSessionCache = true;
    private final HttpRequest httpRequest;
    private QueryContext context = null;
    private UniqueRequestId requestId = null;
    private Ranking ranking = new Ranking(this);
    private Model model = new Model(this);
    private Presentation presentation = new Presentation(this);
    private Select select = new Select(this);
    public Trace trace = new Trace(this);
    public static final CompoundName OFFSET = CompoundName.from((String)"offset");
    public static final CompoundName HITS = CompoundName.from((String)"hits");
    public static final CompoundName QUERY_PROFILE = CompoundName.from((String)"queryProfile");
    public static final CompoundName SEARCH_CHAIN = CompoundName.from((String)"searchChain");
    public static final CompoundName NO_CACHE = CompoundName.from((String)"noCache");
    public static final CompoundName GROUPING_SESSION_CACHE = CompoundName.from((String)"groupingSessionCache");
    public static final CompoundName TIMEOUT = CompoundName.from((String)"timeout");
    @Deprecated
    public static final CompoundName TRACE_LEVEL = CompoundName.from((String)"traceLevel");
    @Deprecated
    public static final CompoundName EXPLAIN_LEVEL = CompoundName.from((String)"explainLevel");
    private static final QueryProfileType argumentType = new QueryProfileType("native");
    private static final Map<String, CompoundName> propertyAliases;
    public static final List<CompoundName> nativeProperties;

    public static QueryProfileType getArgumentType() {
        return argumentType;
    }

    private static void addAliases(QueryProfileType arguments, String prefix, Map<String, CompoundName> aliases) {
        for (FieldDescription field : arguments.fields().values()) {
            QueryProfileType type;
            for (String alias : field.getAliases()) {
                aliases.put(alias, CompoundName.from((String)Query.append(prefix, field.getName())));
            }
            if (!(field.getType() instanceof QueryProfileFieldType) || (type = ((QueryProfileFieldType)field.getType()).getQueryProfileType()) == null) continue;
            Query.addAliases(type, Query.append(prefix, type.getComponentIdAsCompoundName().toString()), aliases);
        }
    }

    private static CompoundName getPrefix(QueryProfileType type) {
        if (type.getId().getName().equals("native")) {
            return CompoundName.empty;
        }
        return type.getComponentIdAsCompoundName();
    }

    public static void addNativeQueryProfileTypesTo(QueryProfileTypeRegistry registry) {
        registry.register(Query.getArgumentType().unfrozen());
        registry.register(Model.getArgumentType().unfrozen());
        registry.register(Select.getArgumentType().unfrozen());
        registry.register(Ranking.getArgumentType().unfrozen());
        registry.register(Presentation.getArgumentType().unfrozen());
        registry.register(Trace.getArgumentType().unfrozen());
        registry.register(DefaultProperties.argumentType.unfrozen());
    }

    private static List<CompoundName> namesUnder(String prefix, QueryProfileType type) {
        if (type == null) {
            return List.of();
        }
        ArrayList<CompoundName> names = new ArrayList<CompoundName>();
        for (Map.Entry<String, FieldDescription> field : type.fields().entrySet()) {
            String name = Query.append(prefix, field.getKey());
            if (field.getValue().getType() instanceof QueryProfileFieldType) {
                names.addAll(Query.namesUnder(name, ((QueryProfileFieldType)field.getValue().getType()).getQueryProfileType()));
                continue;
            }
            names.add(CompoundName.from((String)name));
        }
        return names;
    }

    public Query() {
        this("");
    }

    public Query(String query) {
        this(query, null);
    }

    public Query(HttpRequest request) {
        this(request, null);
    }

    public Query(String query, CompiledQueryProfile queryProfile) {
        this(HttpRequest.createTestRequest((String)query, (HttpRequest.Method)HttpRequest.Method.GET), queryProfile);
    }

    public Query(HttpRequest request, CompiledQueryProfile queryProfile) {
        this(request, request.propertyMap(), queryProfile);
    }

    public Query(HttpRequest request, Map<String, String> requestMap, CompiledQueryProfile queryProfile) {
        super((com.yahoo.processing.request.Properties)new QueryPropertyAliases(propertyAliases));
        this.httpRequest = request;
        this.init(requestMap, queryProfile, Embedder.throwsOnUse.asMap(), ZoneInfo.defaultInfo(), SchemaInfo.empty());
    }

    private Query(Builder builder) {
        this(builder.getRequest(), builder.getRequestMap(), builder.getQueryProfile(), builder.getEmbedders(), builder.getZoneInfo(), builder.getSchemaInfo());
    }

    private Query(HttpRequest request, Map<String, String> requestMap, CompiledQueryProfile queryProfile, Map<String, Embedder> embedders, ZoneInfo zoneInfo, SchemaInfo schemaInfo) {
        super((com.yahoo.processing.request.Properties)new QueryPropertyAliases(propertyAliases));
        this.httpRequest = request;
        this.init(requestMap, queryProfile, embedders, zoneInfo, schemaInfo);
    }

    private void init(Map<String, String> requestMap, CompiledQueryProfile queryProfile, Map<String, Embedder> embedders, ZoneInfo zoneInfo, SchemaInfo schemaInfo) {
        this.startTime = this.httpRequest.creationTime(TimeUnit.MILLISECONDS);
        if (queryProfile != null) {
            QueryProfileProperties queryProfileProperties = new QueryProfileProperties(queryProfile, embedders, zoneInfo);
            this.properties().chain(queryProfileProperties);
            this.setPropertiesFromRequestMap(requestMap, this.properties(), true);
            this.properties().chain(new RankProfileInputProperties(schemaInfo, this, embedders)).chain((com.yahoo.processing.request.Properties)new QueryProperties(this, queryProfile.getRegistry(), embedders)).chain((com.yahoo.processing.request.Properties)new ModelObjectMap()).chain((com.yahoo.processing.request.Properties)new RequestContextProperties(requestMap)).chain((com.yahoo.processing.request.Properties)queryProfileProperties).chain((com.yahoo.processing.request.Properties)new DefaultProperties());
            this.setFieldsFrom(queryProfileProperties, requestMap);
            String select = requestMap.get("select");
            if (select != null) {
                this.properties().set("select", select);
            }
        } else {
            this.properties().chain(new RankProfileInputProperties(schemaInfo, this, embedders)).chain((com.yahoo.processing.request.Properties)new QueryProperties(this, CompiledQueryProfileRegistry.empty, embedders)).chain((com.yahoo.processing.request.Properties)new PropertyMap()).chain((com.yahoo.processing.request.Properties)new DefaultProperties());
            this.setPropertiesFromRequestMap(requestMap, this.properties(), false);
        }
        this.properties().setParentQuery(this);
        this.trace.traceProperties();
    }

    public Query(Query query) {
        this(query, query.getStartTime());
    }

    private Query(Query query, long startTime) {
        super((com.yahoo.processing.request.Properties)query.properties().clone());
        this.startTime = startTime;
        this.httpRequest = query.httpRequest;
        query.copyPropertiesTo(this);
    }

    public static Query createNewQuery(Query query) {
        return new Query(query, System.currentTimeMillis());
    }

    private void setFieldsFrom(Properties properties, Map<String, String> context) {
        this.setFrom("", properties, Query.getArgumentType(), context);
    }

    private static String append(String a, String b) {
        if (a.isEmpty()) {
            return b;
        }
        if (b.isEmpty()) {
            return a;
        }
        return a + "." + b;
    }

    private void setFrom(String prefix, Properties originalProperties, QueryProfileType arguments, Map<String, String> context) {
        prefix = Query.append(prefix, Query.getPrefix(arguments).toString());
        for (FieldDescription field : arguments.fields().values()) {
            String fullName;
            if (field.getType() == FieldType.genericQueryProfileType) {
                fullName = Query.append(prefix, field.getCompoundName().toString());
                for (Map.Entry entry : originalProperties.listProperties(CompoundName.from((String)fullName), context).entrySet()) {
                    this.properties().set(CompoundName.from((String)Query.append(fullName, (String)entry.getKey())), entry.getValue(), context);
                }
                continue;
            }
            if (field.getType() instanceof QueryProfileFieldType) {
                this.setFrom(prefix, originalProperties, ((QueryProfileFieldType)field.getType()).getQueryProfileType(), context);
                continue;
            }
            fullName = prefix.isEmpty() ? field.getCompoundName() : CompoundName.from((String)Query.append(prefix, field.getCompoundName().toString()));
            Object value = originalProperties.get((CompoundName)fullName, context);
            if (value == null) continue;
            this.properties().set((CompoundName)fullName, value, context);
        }
    }

    private void setPropertiesFromRequestMap(Map<String, String> requestMap, Properties properties, boolean ignoreSelect) {
        Set<Map.Entry<String, String>> entrySet = requestMap.entrySet();
        for (Map.Entry<String, String> entry : entrySet) {
            if (ignoreSelect && entry.getKey().equals("select") || RankFeatures.isFeatureName(entry.getKey())) continue;
            properties.set(CompoundName.from((String)entry.getKey()), entry.getValue(), requestMap);
        }
        for (Map.Entry<String, String> entry : entrySet) {
            if (!RankFeatures.isFeatureName(entry.getKey())) continue;
            properties.set(CompoundName.from((String)entry.getKey()), entry.getValue(), requestMap);
        }
    }

    public Properties properties() {
        return (Properties)super.properties();
    }

    public String validate() {
        QueryProfileProperties queryProfileProperties = (QueryProfileProperties)this.properties().getInstance(QueryProfileProperties.class);
        if (queryProfileProperties == null) {
            return null;
        }
        StringBuilder missingName = new StringBuilder();
        if (!queryProfileProperties.isComplete(missingName, this.httpRequest.propertyMap())) {
            return "Incomplete query: Parameter '" + missingName + "' is mandatory in " + queryProfileProperties.getQueryProfile() + " but is not set";
        }
        return null;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getDurationTime() {
        return System.currentTimeMillis() - this.startTime;
    }

    public long getTimeLeft() {
        return this.getTimeout() - this.getDurationTime();
    }

    public long getTimeout() {
        return this.properties().getBoolean(Ranking.RANKFEATURES, false) ? 360000L : this.timeout;
    }

    public void setTimeout(long timeout) {
        if (timeout > 1000000000L || timeout < 0L) {
            throw new IllegalArgumentException("'timeout' must be positive and smaller than 1000000000 ms but was " + timeout);
        }
        this.timeout = timeout;
    }

    public void setTimeout(String timeoutString) {
        this.setTimeout(ParameterParser.asMilliSeconds(timeoutString, this.timeout));
    }

    public void resetTimeout() {
        this.startTime = System.currentTimeMillis();
    }

    @Deprecated
    public void setTraceLevel(int traceLevel) {
        this.trace.setLevel(traceLevel);
    }

    @Deprecated
    public void setExplainLevel(int explainLevel) {
        this.trace.setExplainLevel(explainLevel);
    }

    @Deprecated
    public int getTraceLevel() {
        return this.trace.getLevel();
    }

    @Deprecated
    public int getExplainLevel() {
        return this.getTrace().getExplainLevel();
    }

    @Deprecated
    public final boolean isTraceable(int level) {
        return this.trace.isTraceable(level);
    }

    public boolean getNoCache() {
        return this.noCache;
    }

    public void setNoCache(boolean noCache) {
        this.noCache = noCache;
    }

    public boolean getGroupingSessionCache() {
        return this.groupingSessionCache;
    }

    public void setGroupingSessionCache(boolean groupingSessionCache) {
        this.groupingSessionCache = groupingSessionCache;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getHits() {
        return this.hits;
    }

    public void setHits(int hits) {
        if (hits < 0) {
            throw new IllegalArgumentException("Must be a positive number");
        }
        this.hits = hits;
    }

    public void setOffset(int offset) {
        if (offset < 0) {
            throw new IllegalArgumentException("Must be a positive number");
        }
        this.offset = offset;
    }

    public void setWindow(int offset, int hits) {
        this.setOffset(offset);
        this.setHits(hits);
    }

    public String toString() {
        Object queryTree;
        try {
            queryTree = this.model.getQueryTree().toString();
        }
        catch (Exception | StackOverflowError e) {
            queryTree = "[Could not parse user input: " + this.model.getQueryString() + "]";
        }
        return "query '" + (String)queryTree + "'";
    }

    public String toDetailString() {
        return "query=[" + new TextualQueryRepresentation(this.getModel().getQueryTree().getRoot()) + "] offset=" + this.getOffset() + " hits=" + this.getHits() + " sources=" + this.getModel().getSources() + " restrict= " + this.getModel().getRestrict() + " rank profile=" + this.getRanking().getProfile();
    }

    public int encode(ByteBuffer buffer) {
        return this.model.getQueryTree().encode(buffer);
    }

    public void trace(String message, int traceLevel) {
        this.trace.trace(message, traceLevel);
    }

    public void trace(Object message, int traceLevel) {
        this.trace.trace(message, traceLevel);
    }

    public void trace(String message, boolean includeQuery, int traceLevel) {
        this.trace.trace(message, includeQuery, traceLevel);
    }

    public void trace(boolean includeQuery, int traceLevel, Object ... messages) {
        this.trace.trace(includeQuery, traceLevel, messages);
    }

    public void attachContext(Query query) throws IllegalStateException {
        query.getTrace().setLevel(this.getTrace().getLevel());
        query.getTrace().setExplainLevel(this.getTrace().getExplainLevel());
        query.getTrace().setProfileDepth(this.getTrace().getProfileDepth());
        if (this.context == null) {
            return;
        }
        if (query.getContext(false) != null) {
            throw new IllegalStateException("Query to attach already has context information stored");
        }
        query.context = this.context;
    }

    public String yqlRepresentation() {
        try {
            return this.yqlRepresentation(true);
        }
        catch (NullItemException e) {
            return "Query currently a placeholder, NullItem encountered.";
        }
        catch (IllegalArgumentException e) {
            return "Invalid query: " + Exceptions.toMessageString((Throwable)e);
        }
        catch (RuntimeException e) {
            return "Unexpected error parsing or serializing query: " + Exceptions.toMessageString((Throwable)e);
        }
    }

    private void commaSeparated(StringBuilder yql, Set<String> fields) {
        int initLen = yql.length();
        for (String field : fields) {
            if (yql.length() > initLen) {
                yql.append(", ");
            }
            yql.append(field);
        }
    }

    public String yqlRepresentation(boolean includeHitsAndOffset) {
        Set<String> sources = this.getModel().getSources();
        Set<String> fields = this.getPresentation().getSummaryFields();
        StringBuilder yql = new StringBuilder("select ");
        if (fields.isEmpty()) {
            yql.append('*');
        } else {
            this.commaSeparated(yql, fields);
        }
        yql.append(" from ");
        if (sources.isEmpty()) {
            yql.append("sources *");
        } else {
            if (sources.size() > 1) {
                yql.append("sources ");
            }
            this.commaSeparated(yql, sources);
        }
        yql.append(" where ");
        String insert = this.serializeSortingAndLimits(includeHitsAndOffset);
        yql.append(VespaSerializer.serialize(this, insert));
        return yql.toString();
    }

    private String serializeSortingAndLimits(boolean includeHitsAndOffset) {
        StringBuilder insert = new StringBuilder();
        if (this.getRanking().getSorting() != null && this.getRanking().getSorting().fieldOrders().size() > 0) {
            this.serializeSorting(insert);
        }
        if (includeHitsAndOffset) {
            if (this.getOffset() != 0) {
                insert.append(" limit ").append(this.getHits() + this.getOffset()).append(" offset ").append(this.getOffset());
            } else if (this.getHits() != 10) {
                insert.append(" limit ").append(this.getHits());
            }
        }
        if (this.getTimeout() != 500L) {
            insert.append(" timeout ").append(this.getTimeout());
        }
        return insert.toString();
    }

    private void serializeSorting(StringBuilder yql) {
        yql.append(" order by ");
        int initLen = yql.length();
        for (Sorting.FieldOrder f : this.getRanking().getSorting().fieldOrders()) {
            Class<?> sorterType;
            if (yql.length() > initLen) {
                yql.append(", ");
            }
            if ((sorterType = f.getSorter().getClass()) == Sorting.RawSorter.class) {
                yql.append("[{\"").append("function").append("\": \"").append("raw").append("\"}]");
            } else if (sorterType == Sorting.LowerCaseSorter.class) {
                yql.append("[{\"").append("function").append("\": \"").append("lowercase").append("\"}]");
            } else if (sorterType == Sorting.UcaSorter.class) {
                Sorting.UcaSorter uca = (Sorting.UcaSorter)f.getSorter();
                String ucaLocale = uca.getLocale();
                Sorting.UcaSorter.Strength ucaStrength = uca.getStrength();
                yql.append("[{\"").append("function").append("\": \"").append("uca").append("\"");
                if (ucaLocale != null) {
                    yql.append(", \"").append("locale").append("\": \"").append(ucaLocale).append('\"');
                }
                if (ucaStrength != Sorting.UcaSorter.Strength.UNDEFINED) {
                    yql.append(", \"").append("strength").append("\": \"").append(ucaStrength.name()).append('\"');
                }
                yql.append("}]");
            }
            yql.append(f.getFieldName());
            if (f.getSortOrder() != Sorting.Order.DESCENDING) continue;
            yql.append(" desc");
        }
    }

    public QueryContext getContext(boolean create) {
        if (this.context == null && create) {
            this.context = new QueryContext(this.getTraceLevel(), this);
        }
        return this.context;
    }

    public int hashCode() {
        return Objects.hash(this.ranking, this.presentation, this.model, this.offset, this.hits);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Query)) {
            return false;
        }
        Query q = (Query)other;
        if (this.getOffset() != q.getOffset()) {
            return false;
        }
        if (this.getHits() != q.getHits()) {
            return false;
        }
        if (!this.getPresentation().equals(q.getPresentation())) {
            return false;
        }
        if (!this.getRanking().equals(q.getRanking())) {
            return false;
        }
        return this.getModel().equals(q.getModel());
    }

    public Query clone() {
        Query clone = (Query)super.clone();
        this.copyPropertiesTo(clone);
        return clone;
    }

    private void copyPropertiesTo(Query clone) {
        clone.model = this.model.cloneFor(clone);
        clone.select = this.select.cloneFor(clone);
        clone.ranking = this.ranking.cloneFor(clone);
        clone.trace = this.trace.cloneFor(clone);
        clone.presentation = (Presentation)this.presentation.clone();
        clone.context = this.getContext(true).cloneFor(clone);
        clone.properties().setParentQuery(clone);
        assert (clone.properties().getParentQuery() == clone);
        clone.setTimeout(this.getTimeout());
        clone.setHits(this.getHits());
        clone.setOffset(this.getOffset());
        clone.setNoCache(this.getNoCache());
        clone.setGroupingSessionCache(this.getGroupingSessionCache());
        clone.requestId = null;
    }

    public Presentation getPresentation() {
        return this.presentation;
    }

    public Select getSelect() {
        return this.select;
    }

    public Ranking getRanking() {
        return this.ranking;
    }

    public Model getModel() {
        return this.model;
    }

    public Trace getTrace() {
        return this.trace;
    }

    public HttpRequest getHttpRequest() {
        return this.httpRequest;
    }

    public URI getUri() {
        return this.httpRequest != null ? this.httpRequest.getUri() : null;
    }

    public SessionId getSessionId() {
        if (this.requestId == null) {
            return null;
        }
        return new SessionId(this.requestId, this.getRanking().getProfile());
    }

    public SessionId getSessionId(String serverId) {
        if (this.requestId == null) {
            this.requestId = UniqueRequestId.next(serverId);
        }
        return new SessionId(this.requestId, this.getRanking().getProfile());
    }

    public void prepare() {
        this.getModel().prepare(this.getRanking());
        this.getPresentation().prepare();
        this.getRanking().prepare();
    }

    static {
        argumentType.setBuiltin(true);
        argumentType.addField(new FieldDescription(OFFSET.toString(), "integer", "offset start"));
        argumentType.addField(new FieldDescription(HITS.toString(), "integer", "hits count"));
        argumentType.addField(new FieldDescription(QUERY_PROFILE.toString(), "string"));
        argumentType.addField(new FieldDescription(SEARCH_CHAIN.toString(), "string"));
        argumentType.addField(new FieldDescription(NO_CACHE.toString(), "boolean", "nocache"));
        argumentType.addField(new FieldDescription(GROUPING_SESSION_CACHE.toString(), "boolean", "groupingSessionCache"));
        argumentType.addField(new FieldDescription(TIMEOUT.toString(), "string", "timeout"));
        argumentType.addField(new FieldDescription(FederationSearcher.SOURCENAME.toString(), "string"));
        argumentType.addField(new FieldDescription(FederationSearcher.PROVIDERNAME.toString(), "string"));
        argumentType.addField(new FieldDescription("model", new QueryProfileFieldType(Model.getArgumentType())));
        argumentType.addField(new FieldDescription("select", new QueryProfileFieldType(Select.getArgumentType())));
        argumentType.addField(new FieldDescription("dispatch", new QueryProfileFieldType(Dispatcher.getArgumentType())));
        argumentType.addField(new FieldDescription("ranking", new QueryProfileFieldType(Ranking.getArgumentType())));
        argumentType.addField(new FieldDescription("presentation", new QueryProfileFieldType(Presentation.getArgumentType())));
        argumentType.addField(new FieldDescription("trace", new QueryProfileFieldType(Trace.getArgumentType())));
        argumentType.freeze();
        HashMap<String, CompoundName> propertyAliasesBuilder = new HashMap<String, CompoundName>();
        Query.addAliases(Query.getArgumentType(), "", propertyAliasesBuilder);
        propertyAliases = ImmutableMap.copyOf(propertyAliasesBuilder);
        nativeProperties = List.copyOf(Query.namesUnder("", Query.getArgumentType()));
    }

    public static class Builder {
        private HttpRequest request = null;
        private Map<String, String> requestMap = null;
        private CompiledQueryProfile queryProfile = null;
        private Map<String, Embedder> embedders = Embedder.throwsOnUse.asMap();
        private ZoneInfo zoneInfo = ZoneInfo.defaultInfo();
        private SchemaInfo schemaInfo = SchemaInfo.empty();

        public Builder setRequest(String query) {
            this.request = HttpRequest.createTestRequest((String)query, (HttpRequest.Method)HttpRequest.Method.GET);
            return this;
        }

        public Builder setRequest(HttpRequest request) {
            this.request = request;
            return this;
        }

        public HttpRequest getRequest() {
            if (this.request == null) {
                return HttpRequest.createTestRequest((String)"", (HttpRequest.Method)HttpRequest.Method.GET);
            }
            return this.request;
        }

        public Builder setRequestMap(Map<String, String> requestMap) {
            this.requestMap = requestMap;
            return this;
        }

        public Map<String, String> getRequestMap() {
            if (this.requestMap == null) {
                return this.getRequest().propertyMap();
            }
            return this.requestMap;
        }

        public Builder setQueryProfile(CompiledQueryProfile queryProfile) {
            this.queryProfile = queryProfile;
            return this;
        }

        public CompiledQueryProfile getQueryProfile() {
            return this.queryProfile;
        }

        public Builder setEmbedder(Embedder embedder) {
            return this.setEmbedders(Map.of("default", embedder));
        }

        public Builder setEmbedders(Map<String, Embedder> embedders) {
            this.embedders = embedders;
            return this;
        }

        public Embedder getEmbedder() {
            if (this.embedders.size() != 1) {
                throw new IllegalArgumentException("Attempt to get single embedder but multiple exists.");
            }
            return (Embedder)((Map.Entry)this.embedders.entrySet().stream().findFirst().get()).getValue();
        }

        public Map<String, Embedder> getEmbedders() {
            return this.embedders;
        }

        public Builder setZoneInfo(ZoneInfo zoneInfo) {
            this.zoneInfo = zoneInfo;
            return this;
        }

        public ZoneInfo getZoneInfo() {
            return this.zoneInfo;
        }

        public Builder setSchemaInfo(SchemaInfo schemaInfo) {
            this.schemaInfo = schemaInfo;
            return this;
        }

        public SchemaInfo getSchemaInfo() {
            return this.schemaInfo;
        }

        public Query build() {
            return new Query(this);
        }
    }

    public static enum Type {
        ALL(0, "all"),
        ANY(1, "any"),
        PHRASE(2, "phrase"),
        ADVANCED(3, "adv"),
        WEB(4, "web"),
        PROGRAMMATIC(5, "prog"),
        YQL(6, "yql"),
        SELECT(7, "select"),
        WEAKAND(8, "weakAnd"),
        TOKENIZE(9, "tokenize");

        private final int intValue;
        private final String stringValue;

        private Type(int intValue, String stringValue) {
            this.intValue = intValue;
            this.stringValue = stringValue;
        }

        public static Type getType(String typeString) {
            for (Type type : Type.values()) {
                if (!type.stringValue.equals(typeString)) continue;
                return type;
            }
            throw new IllegalArgumentException("No query type '" + typeString + "'");
        }

        public int asInt() {
            return this.intValue;
        }

        public String toString() {
            return this.stringValue;
        }
    }
}

